/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.graphics.filters.BoxBlurFilter;
import com.alee.graphics.filters.GaussianFilter;
import com.alee.graphics.filters.MotionBlurOp;
import com.alee.graphics.filters.OpacityFilter;
import com.alee.utils.ImageUtils;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;

public final class ImageFilterUtils {
    private static final ColorConvertOp grayscaleColorConvert = new ColorConvertOp(ColorSpace.getInstance(1003), null);

    public static BufferedImage applyBoxBlurFilter(Image src, Image dst, int hRadius, int vRadius, int iterations) {
        return ImageFilterUtils.applyBoxBlurFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst), hRadius, vRadius, iterations);
    }

    public static BufferedImage applyBoxBlurFilter(BufferedImage src, BufferedImage dst, int hRadius, int vRadius, int iterations) {
        return new BoxBlurFilter(hRadius, vRadius, iterations).filter(src, dst);
    }

    public static BufferedImage applyGrayscaleFilter(Image src, Image dst) {
        return ImageFilterUtils.applyGrayscaleFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst));
    }

    public static BufferedImage applyGrayscaleFilter(BufferedImage src, BufferedImage dst) {
        return grayscaleColorConvert.filter(src, dst);
    }

    public static BufferedImage applyGaussianFilter(Image src, Image dst, float radius) {
        return ImageFilterUtils.applyGaussianFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst), radius);
    }

    public static BufferedImage applyGaussianFilter(BufferedImage src, BufferedImage dst, float radius) {
        return new GaussianFilter(radius).filter(src, dst);
    }

    public static BufferedImage applyZoomBlurFilter(Image src, Image dst, float zoom, float centreX, float centreY) {
        return ImageFilterUtils.applyZoomBlurFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst), zoom, centreX, centreY);
    }

    public static BufferedImage applyZoomBlurFilter(BufferedImage src, BufferedImage dst, float zoom, float centreX, float centreY) {
        return new MotionBlurOp(0.0f, 0.0f, 0.0f, zoom, centreX, centreY).filter(src, dst);
    }

    public static BufferedImage applyRotationBlurFilter(Image src, Image dst, float rotation, float centreX, float centreY) {
        return ImageFilterUtils.applyRotationBlurFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst), rotation, centreX, centreY);
    }

    public static BufferedImage applyRotationBlurFilter(BufferedImage src, BufferedImage dst, float rotation, float centreX, float centreY) {
        return new MotionBlurOp(0.0f, 0.0f, rotation, 0.0f, centreX, centreY).filter(src, dst);
    }

    public static BufferedImage applyMotionBlurFilter(Image src, Image dst, float distance, float angle, float rotation, float zoom, float centreX, float centreY) {
        return ImageFilterUtils.applyMotionBlurFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst), distance, angle, rotation, zoom, centreX, centreY);
    }

    public static BufferedImage applyMotionBlurFilter(BufferedImage src, BufferedImage dst, float distance, float angle, float rotation, float zoom, float centreX, float centreY) {
        return new MotionBlurOp(distance, angle, rotation, zoom, centreX, centreY).filter(src, dst);
    }

    public static BufferedImage applyOpacityFilter(Image src, Image dst, int opacity) {
        return ImageFilterUtils.applyOpacityFilter(ImageUtils.getBufferedImage(src), ImageUtils.getBufferedImage(dst), opacity);
    }

    public static BufferedImage applyOpacityFilter(BufferedImage src, BufferedImage dst, int opacity) {
        return new OpacityFilter(opacity).filter(src, dst);
    }
}

