/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.laf.combobox.WebComboBoxUI;
import com.alee.laf.table.WebTableStyle;
import com.alee.managers.hotkey.Hotkey;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class WebDefaultCellEditor<C extends JComponent>
extends AbstractCellEditor
implements TableCellEditor,
TreeCellEditor {
    public static final String COMBOBOX_CELL_EDITOR = "JComboBox.isTableCellEditor";
    protected C editorComponent;
    protected EditorDelegate delegate;
    protected int clickCountToStart = WebTableStyle.clickCountToStartEdit;

    public WebDefaultCellEditor() {
    }

    public WebDefaultCellEditor(JTextField textField) {
        this.initialize(textField);
    }

    public WebDefaultCellEditor(JCheckBox checkBox) {
        this.initialize(checkBox);
    }

    public WebDefaultCellEditor(JComboBox comboBox) {
        this.initialize(comboBox);
    }

    protected void initialize(C editor) {
        this.editorComponent = editor;
        if (editor instanceof JTextField) {
            final JTextField textField = (JTextField)editor;
            this.delegate = new EditorDelegate(){

                public void setValue(Object value) {
                    textField.setText(value != null ? value.toString() : "");
                }

                public Object getCellEditorValue() {
                    return textField.getText();
                }
            };
            textField.addActionListener(this.delegate);
        } else if (editor instanceof JCheckBox) {
            final JCheckBox checkBox = (JCheckBox)editor;
            this.delegate = new EditorDelegate(){

                public void setValue(Object value) {
                    boolean selected = false;
                    if (value instanceof Boolean) {
                        selected = (Boolean)value;
                    } else if (value instanceof String) {
                        selected = value.equals("true");
                    }
                    checkBox.setSelected(selected);
                }

                public Object getCellEditorValue() {
                    return checkBox.isSelected();
                }
            };
            checkBox.addActionListener(this.delegate);
            checkBox.setRequestFocusEnabled(false);
        } else if (editor instanceof JComboBox) {
            final JComboBox comboBox = (JComboBox)editor;
            if (comboBox.getUI() instanceof WebComboBoxUI) {
                WebComboBoxUI webComboBoxUI = (WebComboBoxUI)comboBox.getUI();
                webComboBoxUI.setDrawBorder(false);
            }
            comboBox.putClientProperty(COMBOBOX_CELL_EDITOR, Boolean.TRUE);
            this.delegate = new EditorDelegate(){

                public void setValue(Object value) {
                    comboBox.setSelectedItem(value);
                }

                public Object getCellEditorValue() {
                    return comboBox.getSelectedItem();
                }

                @Override
                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }

                @Override
                public boolean stopCellEditing() {
                    if (comboBox.isEditable()) {
                        comboBox.actionPerformed(new ActionEvent(WebDefaultCellEditor.this, 0, ""));
                    }
                    return super.stopCellEditing();
                }
            };
            comboBox.addActionListener(this.delegate);
        }
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public Object getCellEditorValue() {
        return this.delegate.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return this.delegate.shouldSelectCell(anEvent);
    }

    @Override
    public boolean stopCellEditing() {
        return this.delegate.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.delegate.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.delegate.setValue(value);
        return this.editorComponent;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.delegate.setValue(value);
        return this.editorComponent;
    }

    protected class EditorDelegate<T>
    implements ActionListener,
    ItemListener,
    Serializable {
        protected T value;

        protected EditorDelegate() {
        }

        public T getCellEditorValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent == null || anEvent instanceof ActionEvent) {
                return true;
            }
            if (anEvent instanceof KeyEvent) {
                KeyEvent keyEvent = (KeyEvent)anEvent;
                return Hotkey.F2.isTriggered(keyEvent);
            }
            if (anEvent instanceof MouseEvent) {
                MouseEvent mouseEvent = (MouseEvent)anEvent;
                return WebDefaultCellEditor.this.clickCountToStart >= 0 && mouseEvent.getClickCount() >= WebDefaultCellEditor.this.clickCountToStart;
            }
            return false;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        public boolean stopCellEditing() {
            WebDefaultCellEditor.this.fireEditingStopped();
            return true;
        }

        public void cancelCellEditing() {
            WebDefaultCellEditor.this.fireEditingCanceled();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WebDefaultCellEditor.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WebDefaultCellEditor.this.stopCellEditing();
        }
    }
}

