/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes;

import com.formdev.flatlaf.FlatIntelliJLaf;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.system.ToolSystem;
import com.touchcomp.touchversoes.Splash;
import com.touchcomp.touchversoes.gui.MainFrame;
import contato.dialog.ContatoDialogsHelper;
import org.springframework.beans.BeansException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.jms.JndiConnectionFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;

@EntityScan(basePackages={"com.touchcomp.touchversoes.model"})
@SpringBootApplication(scanBasePackages={"com.touchcomp.touchversoes"})
@EnableAutoConfiguration(exclude={JndiConnectionFactoryAutoConfiguration.class, ErrorMvcAutoConfiguration.class})
public class Main
implements ApplicationContextAware {
    private static ApplicationContext context;

    public static void main(String[] args) {
        Splash.startSplash();
        FlatIntelliJLaf.setup();
        try {
            SpringApplication.run(Main.class, (String[])args);
        }
        catch (Exception ex) {
            Splash.finishSplash();
            ex.printStackTrace();
            TLogger.get(Main.class).error((Throwable)ex);
            ContatoDialogsHelper.showError((String)("Erro ao iniciar o webform\n\n\n\n" + ex.getMessage()));
        }
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void executePerformanceBenchmark() {
        Splash.finishSplash();
        MainFrame t = new MainFrame();
        t.setSize(ToolSystem.getScreenSize());
        t.setLocationRelativeTo(null);
        t.afterShow();
        t.setVisible(true);
    }

    public static ApplicationContext getApplicationContext() {
        return context;
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)context.getBean(clazz);
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        context = ac;
    }
}

