/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes;

import contato.swing.ContatoLabel;
import contato.swing.ContatoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

public class Splash
extends JWindow {
    private static Splash splash;
    private ContatoPanel jContentPane = null;
    private ContatoLabel lbl = null;
    private ContatoPanel pnlRodape = null;
    private ContatoLabel lblDescricao = null;
    private JProgressBar progress = null;
    private ContatoLabel lblLoading = null;
    private LoadThread t = null;

    public Splash() {
        this.initialize();
        this.t = new LoadThread();
        this.t.start();
    }

    private void initialize() {
        this.setSize(500, 240);
        this.setPreferredSize(new Dimension(500, 320));
        this.setContentPane((Container)this.getJContentPane());
        this.setAlwaysOnTop(true);
    }

    private ContatoPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.lbl = new ContatoLabel();
            this.lbl.setText("");
            this.lbl.setHorizontalTextPosition(0);
            this.lbl.setHorizontalAlignment(0);
            Image i = Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("/images/logo_geek.jpg"));
            this.lbl.setIcon((Icon)new ImageIcon(i.getScaledInstance(700, 448, 4)));
            this.jContentPane = new ContatoPanel();
            this.jContentPane.setLayout((LayoutManager)new BorderLayout());
            this.jContentPane.add((Component)this.lbl, (Object)"Center");
            this.jContentPane.add((Component)this.getPnlRodape(), (Object)"South");
        }
        return this.jContentPane;
    }

    private ContatoPanel getPnlRodape() {
        if (this.pnlRodape == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
            gridBagConstraints2.gridy = 1;
            this.lblLoading = new ContatoLabel();
            this.lblLoading.setText("Loading...");
            this.lblLoading.setFont(new Font("Dialog", 1, 12));
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints1.gridy = 1;
            gridBagConstraints1.fill = 0;
            gridBagConstraints1.anchor = 13;
            gridBagConstraints1.gridx = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 20, 0, 20);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 0;
            this.lblDescricao = new ContatoLabel();
            this.lblDescricao.setText("Touch Comp - 2022");
            this.lblDescricao.setFont(new Font("Dialog", 0, 10));
            this.pnlRodape = new ContatoPanel();
            this.pnlRodape.setLayout((LayoutManager)new GridBagLayout());
            this.pnlRodape.setPreferredSize(new Dimension(10, 35));
            this.pnlRodape.add((Component)this.getProgress(), (Object)gridBagConstraints);
            this.pnlRodape.add((Component)this.lblDescricao, (Object)gridBagConstraints1);
            this.pnlRodape.add((Component)this.lblLoading, (Object)gridBagConstraints2);
        }
        return this.pnlRodape;
    }

    private JProgressBar getProgress() {
        if (this.progress == null) {
            this.progress = new JProgressBar();
            Color c = new Color(128, 130, 133);
            this.progress.setForeground(c);
            this.progress.setBackground(Color.WHITE);
            this.progress.setStringPainted(true);
            this.progress.setString("");
            this.progress.setPreferredSize(new Dimension(300, 20));
            this.progress.setValue(0);
        }
        return this.progress;
    }

    private void close() {
        this.progress.setValue(this.progress.getMaximum());
        if (this.t.isAlive()) {
            this.t.terminate = true;
        }
        try {
            this.lblLoading.setText("Loaded...");
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
        this.dispose();
    }

    public static void startSplash() {
        splash = new Splash();
        splash.setAlwaysOnTop(true);
        splash.setLocationRelativeTo(null);
        splash.setVisible(true);
    }

    public static void finishSplash() {
        if (splash != null) {
            splash.close();
        }
    }

    public static void setLabel(String txt) {
        if (splash != null) {
            Splash.splash.lblLoading.setText(txt);
        }
    }

    private class LoadThread
    extends Thread {
        private boolean terminate = false;

        private LoadThread() {
        }

        @Override
        public void run() {
            this.terminate = false;
            while (!this.terminate) {
                if (this.terminate) {
                    Splash.this.progress.setValue(Splash.this.progress.getMaximum());
                    break;
                }
                Splash.this.progress.setValue(Splash.this.progress.getValue() + 1);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

