/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.conf;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchversoes.properties.PropertiesDatabase;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.hibernate.dialect.FirebirdDialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@PropertySource(value={"classpath:application.yml"})
@EnableTransactionManagement
public class PersistenceConfig {
    @Autowired
    private Environment environment;
    @Value(value="${spring.datasource.url}")
    private String databaseURL;
    @Value(value="${spring.datasource.driver-class-name}")
    private String driverClassName;
    @Value(value="${spring.datasource.username}")
    private String username;
    @Value(value="${spring.datasource.password}")
    private String password;
    @Value(value="${spring.datasource.properties.hibernate.ddl-auto}")
    private String ddlAutoHibernate;
    @Value(value="${spring.datasource.properties.hibernate.show_sql}")
    private String showSql;
    @Value(value="${spring.datasource.properties.hibernate.enable_lazy_load_no_trans}")
    private String enableLazyLoadCollections;

    @Bean
    public DataSource dataSource() throws ExceptionIO, ExceptionInvalidData {
        String urlLocal = PropertiesDatabase.get().getURLBDMentor();
        String userNameLocal = PropertiesDatabase.get().getDBUser(this.username);
        String passwordLocal = PropertiesDatabase.get().getDBPass(this.password);
        String driverClassNameLocal = PropertiesDatabase.get().getDBDriver(this.driverClassName);
        if (!TMethods.isStrWithData((String)urlLocal)) {
            urlLocal = this.databaseURL;
        }
        Object[] profiles = this.environment.getActiveProfiles();
        System.out.println("\n\n\n");
        System.out.println("Configurando bancos de dados");
        if (!ToolMethods.containsInArray((Object[])profiles, (Object)"tests") && !ToolMethods.containsInArray((Object[])profiles, (Object)"test")) {
            Properties properties = PropertiesDatabase.getProperties();
            String aux = properties.getProperty("jdbc.url");
            System.out.println("URL DATABASE Mentor: " + aux);
            if (ToolMethods.isStrWithData((String)aux)) {
                urlLocal = aux;
            }
        }
        System.out.println("\n\n\n");
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(driverClassNameLocal);
        ds.setUsername(userNameLocal);
        ds.setPassword(passwordLocal);
        ds.setUrl(urlLocal);
        ds.setMinIdle(2);
        return ds;
    }

    private Properties getHibernateProps() {
        try {
            Properties hibernateProperties = new Properties();
            String showSQLInternal = "true";
            if (ToolMethods.isStrWithData((String)showSQLInternal)) {
                hibernateProperties.put("hibernate.show_sql", showSQLInternal);
            } else {
                hibernateProperties.put("hibernate.show_sql", this.showSql);
            }
            hibernateProperties.put("hibernate.format_sql", (Object)false);
            hibernateProperties.put("hibernate.enable_lazy_load_no_trans", String.valueOf(this.enableLazyLoadCollections));
            hibernateProperties.put("hibernate.hbm2ddl.auto", String.valueOf(this.ddlAutoHibernate));
            hibernateProperties.put("hibernate.dialect", FirebirdDialect.class.getCanonicalName());
            hibernateProperties.put("hibernate.id.new_generator_mappings", "false");
            hibernateProperties.put("hibernate.event.merge.entity_copy_observer", "allow");
            hibernateProperties.put("hibernate.ejb.use_class_enhancer", "true");
            return hibernateProperties;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }
}

