/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui;

import com.touchcomp.basementor.constants.enums.controlepatchversao.EnumConstMaturidade;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchversoes.Main;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.dto.DTOFilesInfo;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.AuxValidacoes;
import com.touchcomp.touchversoes.gui.configuracoes.TouchVersoesConfigFrame;
import com.touchcomp.touchversoes.gui.getdown.GetDownFrame;
import com.touchcomp.touchversoes.gui.instaladores.AuxInstallBuilder;
import com.touchcomp.touchversoes.gui.instaladores.InstaladoresFrame;
import com.touchcomp.touchversoes.gui.log.TouchLogFrame;
import com.touchcomp.touchversoes.gui.mavenbuild.AuxMavenBuilder;
import com.touchcomp.touchversoes.gui.mavenbuild.TouchMavenBuildFrame;
import com.touchcomp.touchversoes.gui.patches.TouchPatchFrame;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.gui.progress.TouchProgressFrame;
import com.touchcomp.touchversoes.gui.suiteversao.AuxAlterProfileYAMLApp;
import com.touchcomp.touchversoes.gui.suiteversao.AuxAlterVersaoCodeApp;
import com.touchcomp.touchversoes.gui.suiteversao.AuxVersao;
import com.touchcomp.touchversoes.gui.suiteversao.TouchArquivoConfVersoesFrame;
import com.touchcomp.touchversoes.gui.suiteversao.TouchSuiteVersaoFrame;
import com.touchcomp.touchversoes.gui.suiteversao.util.UtilSuiteVersao;
import com.touchcomp.touchversoes.gui.testsquality.AuxFrontEndTests;
import com.touchcomp.touchversoes.gui.testsquality.AuxNodoSearchTests;
import com.touchcomp.touchversoes.gui.testsquality.AuxQualityTests;
import com.touchcomp.touchversoes.gui.testsquality.AuxTestWeb;
import com.touchcomp.touchversoes.gui.testsquality.TouchQualityTestsFrame;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.model.VersaoMentorSistema;
import com.touchcomp.touchversoes.properties.ConfigProperties;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoLocal;
import com.touchcomp.touchversoes.service.suiteversao.ServiceSuiteVersaoItemImpl;
import com.touchcomp.touchversoes.service.versaomentor.ServiceVersaoMentorImpl;
import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoButton;
import contato.swing.ContatoCheckBox;
import contato.swing.ContatoComboBox;
import contato.swing.ContatoLabel;
import contato.swing.ContatoPanel;
import contato.swing.ContatoTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MainFrame
extends JFrame {
    TouchVersoesConfigFrame pnlConfig;
    InstaladoresFrame pnlInstaladores;
    TouchLogFrame pnlLog;
    TouchMavenBuildFrame pnlMaven;
    TouchQualityTestsFrame pnlQualidade;
    GetDownFrame pnlGetDownFrame;
    TouchPatchFrame pnlPatchs;
    private AuxSuiteVersao auxSuiteVersao;
    private int currentTask = 0;
    private int allTasks = 4;
    private StagioController stagioController;
    private ContatoButton btnIniciar;
    private ContatoButton btnSomenteTestes;
    private ButtonGroup buttonGroup1;
    private ContatoCheckBox chcGerarInstaladores;
    private ContatoCheckBox chcGerarVersao;
    private ContatoCheckBox chcNaoRealizarTestes;
    private ContatoCheckBox chcNaoTestarWildfly;
    private ContatoComboBox cmbVersao;
    private ContatoLabel contatoLabel1;
    private ContatoLabel contatoLabel2;
    private ContatoLabel contatoLabel3;
    private ContatoPanel contatoPanel1;
    private ContatoPanel contatoPanel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private TouchArquivoConfVersoesFrame pnlArquivoVersoes;
    private TouchProgressFrame pnlProgressTask;
    private TouchSuiteVersaoFrame pnlSuiteVersao;
    private JRadioButton rdbVersaoCompleta;
    private JRadioButton rdbVersaoEspecifica;
    private ContatoTabbedPane tabMain;
    private ContatoTabbedPane tabVersoesInstaladores;

    public MainFrame() {
        this.initComponents();
        this.pnlConfig = new TouchVersoesConfigFrame();
        this.pnlInstaladores = new InstaladoresFrame();
        this.pnlLog = new TouchLogFrame();
        this.pnlMaven = new TouchMavenBuildFrame();
        this.pnlQualidade = new TouchQualityTestsFrame();
        this.pnlPatchs = new TouchPatchFrame();
        this.pnlGetDownFrame = new GetDownFrame();
        this.setTitle("Touch Comp Sistemas e Versoes");
        this.initFields();
    }

    private void initFields() {
        this.pnlInstaladores.setPnlMain(this);
        this.pnlSuiteVersao.setPnlMain(this);
        this.pnlMaven.setPnlMain(this);
        this.pnlPatchs.setPnlMain(this);
        this.pnlQualidade.setPnlMain(this);
        this.tabVersoesInstaladores.add("Instaladores", (Component)this.pnlInstaladores);
        this.tabMain.add("Patchs Locais", (Component)this.pnlPatchs);
        this.tabMain.add("Build", (Component)this.pnlMaven);
        this.tabMain.add("Qualidade", (Component)this.pnlQualidade);
        this.tabMain.add("Configura\u00e7\u00f5es", (Component)this.pnlConfig);
        this.tabMain.add("Log", (Component)this.pnlLog);
        this.tabMain.add("GetDown", (Component)this.pnlGetDownFrame);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.contatoLabel1 = new ContatoLabel();
        this.cmbVersao = new ContatoComboBox();
        this.tabMain = new ContatoTabbedPane();
        this.contatoPanel2 = new ContatoPanel();
        this.contatoPanel1 = new ContatoPanel();
        this.jPanel1 = new JPanel();
        this.btnIniciar = new ContatoButton();
        this.btnSomenteTestes = new ContatoButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.rdbVersaoCompleta = new JRadioButton();
        this.rdbVersaoEspecifica = new JRadioButton();
        this.jPanel4 = new JPanel();
        this.chcGerarInstaladores = new ContatoCheckBox();
        this.chcGerarVersao = new ContatoCheckBox();
        this.tabVersoesInstaladores = new ContatoTabbedPane();
        this.pnlSuiteVersao = new TouchSuiteVersaoFrame();
        this.pnlArquivoVersoes = new TouchArquivoConfVersoesFrame();
        this.jPanel5 = new JPanel();
        this.chcNaoRealizarTestes = new ContatoCheckBox();
        this.chcNaoTestarWildfly = new ContatoCheckBox();
        this.contatoLabel3 = new ContatoLabel();
        this.pnlProgressTask = new TouchProgressFrame();
        this.contatoLabel2 = new ContatoLabel();
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new GridBagLayout());
        this.contatoLabel1.setText("Vers\u00e3o");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.contatoLabel1, gridBagConstraints);
        this.cmbVersao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MainFrame.this.cmbVersaoItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 3, 0);
        this.getContentPane().add((Component)this.cmbVersao, gridBagConstraints);
        this.btnIniciar.setText("Iniciar");
        this.btnIniciar.setMinimumSize(new Dimension(150, 30));
        this.btnIniciar.setPreferredSize(new Dimension(150, 30));
        this.btnIniciar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnIniciarActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.btnIniciar);
        this.btnSomenteTestes.setText("Somente Testes");
        this.btnSomenteTestes.setMinimumSize(new Dimension(150, 30));
        this.btnSomenteTestes.setPreferredSize(new Dimension(150, 30));
        this.btnSomenteTestes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.btnSomenteTestesActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.btnSomenteTestes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.contatoPanel1.add((Component)this.jPanel1, (Object)gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.rdbVersaoCompleta);
        this.rdbVersaoCompleta.setText("Todos os itens/sistemas da vers\u00e3o");
        this.jPanel3.add(this.rdbVersaoCompleta);
        this.buttonGroup1.add(this.rdbVersaoEspecifica);
        this.rdbVersaoEspecifica.setText("Itens especificos(selecione abaixo)");
        this.jPanel3.add(this.rdbVersaoEspecifica);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.chcGerarInstaladores.setText("Gerar Instaladores");
        this.jPanel4.add((Component)this.chcGerarInstaladores);
        this.chcGerarVersao.setText("Gerar Vers\u00e3o");
        this.jPanel4.add((Component)this.chcGerarVersao);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.contatoPanel1.add((Component)this.jPanel2, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        this.contatoPanel2.add((Component)this.contatoPanel1, (Object)gridBagConstraints);
        this.tabVersoesInstaladores.addTab("Vers\u00e3o", (Component)this.pnlSuiteVersao);
        this.tabVersoesInstaladores.addTab("Arquivo Vers\u00f5es", (Component)this.pnlArquivoVersoes);
        this.jPanel5.setLayout(new GridBagLayout());
        this.chcNaoRealizarTestes.setText("N\u00e3o realizar testes");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel5.add((Component)this.chcNaoRealizarTestes, gridBagConstraints);
        this.chcNaoTestarWildfly.setText("N\u00e3o testar Wildfly");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.jPanel5.add((Component)this.chcNaoTestarWildfly, gridBagConstraints);
        this.contatoLabel3.setText("Marque em \u00faltimo caso!");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.jPanel5.add((Component)this.contatoLabel3, gridBagConstraints);
        this.tabVersoesInstaladores.addTab("Outras Op\u00e7\u00f5es", (Component)this.jPanel5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.contatoPanel2.add((Component)this.tabVersoesInstaladores, (Object)gridBagConstraints);
        this.tabMain.addTab("Vers\u00f5es e Instaladores", (Component)this.contatoPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(0, 5, 6, 5);
        this.getContentPane().add((Component)this.tabMain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.pnlProgressTask, gridBagConstraints);
        this.contatoLabel2.setText("Modificado em 16/07/2025");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.anchor = 26;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.getContentPane().add((Component)this.contatoLabel2, gridBagConstraints);
        this.pack();
    }

    private void cmbVersaoItemStateChanged(ItemEvent evt) {
        this.setVersao();
    }

    private void btnSomenteTestesActionPerformed(ActionEvent evt) {
        this.runAllTasks(true);
    }

    private void btnIniciarActionPerformed(ActionEvent evt) {
        this.runAllTasks(false);
    }

    public void afterShow() {
        ServiceVersaoMentorImpl service = Main.getBean(ServiceVersaoMentorImpl.class);
        List<VersaoMentor> versoes = service.getVersoesAtivas();
        this.cmbVersao.setModel(new DefaultComboBoxModel<Object>(versoes.toArray()));
        this.cmbVersao.clear();
        this.pnlSuiteVersao.afterShow();
        this.pnlConfig.afterShow();
    }

    public void setSelectedLog() {
        this.tabMain.setSelectedComponent((Component)this.pnlLog);
    }

    public ProgressCurrentTask getCurrentTask() {
        return this.pnlProgressTask.getCurrentTask();
    }

    public ProgressCurrentTask getAllTasks() {
        return this.pnlProgressTask.getAllTasks();
    }

    private void runTasksInternal(boolean somenteTestes) {
        try {
            this.showNoModalInfo("Iniciando processo. Serao realizados testes unitarios, build dos projetos,\ne em paralelo o envio para nuvem do update da aplicacao e criacao dos instaladores.");
            DTOConfiguracoes conf = ConfigProperties.get().getConfiguracoes();
            VersaoMentor ver = (VersaoMentor)this.cmbVersao.getSelectedItem();
            new UtilSuiteVersao().checkGitBranch(conf, ver);
            AuxSuiteVersao suiteVersao = this.getSuiteVersao(ver);
            this.currentTask = 0;
            if (!new AuxValidacoes().isValideBefore(conf, suiteVersao)) {
                return;
            }
            EnumConstMaturidade mat = EnumConstMaturidade.get((Object)ver.getMaturidade());
            if (mat == null) {
                throw new Exception("Informe a maturidade no cadastro da vers\u00e3o");
            }
            if (!somenteTestes && !this.isArqModificacoesInformado(ver)) {
                return;
            }
            if (this.stagioController == null) {
                this.stagioController = new StagioController();
            }
            LinkedHashSet<AuxMavenBuilder.AppType> typesBuild = new LinkedHashSet<AuxMavenBuilder.AppType>();
            LinkedHashSet<AuxInstallBuilder.AppType> typesInstall = new LinkedHashSet<AuxInstallBuilder.AppType>();
            List<SuiteVersaoItem> itens = this.getSuiteItens(suiteVersao);
            this.auxSuiteVersao.setItensSelecionadosVersao(itens);
            if (!ToolMethods.isWithData(itens)) {
                ContatoDialogsHelper.showInfo((String)"Selecione os produtos que ser\u00e3o gerados as vers\u00f5es.");
                return;
            }
            List<EnumConstTipoSistemasTouch> tipos = this.getTypes(itens);
            this.getTypesBuild(tipos, typesBuild);
            this.getTypesInstall(tipos, typesInstall);
            this.getAllTasks().onProgress(this.currentTask++, this.allTasks, "Lendo dados da versao");
            this.setSelectedLog();
            this.changeVersaoAppCode(suiteVersao);
            this.getAllTasks().onProgress(2, 4, "Build de projetos");
            this.testarAppsBeforeBuild(conf, suiteVersao, this.stagioController, tipos);
            new AuxMavenBuilder(conf, suiteVersao, this.getCurrentTask()).build(typesBuild);
            this.getAllTasks().onProgress(1, 4, "Realizando Testes Unitarios");
            this.testarAppsAfterBuild(conf, suiteVersao, this.stagioController, tipos);
            if (!somenteTestes) {
                this.getAllTasks().onProgress(3, 4, "Testando Wildfly");
                this.testarWildFly(conf, suiteVersao, tipos);
                this.getAllTasks().onProgress(4, 4, "Finalizado");
                this.gerarVersao(conf, suiteVersao);
                this.gerarInstaladores(conf, suiteVersao, typesInstall);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            ContatoDialogsHelper.showError((String)("Erro ao executar as tarefas: " + ex.getMessage()));
        }
    }

    private List<EnumConstTipoSistemasTouch> getTypes(List<SuiteVersaoItem> itens) {
        LinkedList<EnumConstTipoSistemasTouch> ret = new LinkedList<EnumConstTipoSistemasTouch>();
        for (SuiteVersaoItem item : itens) {
            EnumConstTipoSistemasTouch tipo = EnumConstTipoSistemasTouch.get((Object)item.getTipoBDVersao().getCodigoSistema());
            ret.add(tipo);
        }
        return ret;
    }

    private List<SuiteVersaoItem> getSuiteItens(AuxSuiteVersao suiteVersao) {
        List<SuiteVersaoItem> itens = this.rdbVersaoCompleta.isSelected() ? suiteVersao.getSuiteVersao().getItens() : this.pnlSuiteVersao.getItensVersaoSelecionados();
        return itens;
    }

    private void getTypesBuild(List<EnumConstTipoSistemasTouch> sistemas, Set<AuxMavenBuilder.AppType> typesBuild) {
        for (EnumConstTipoSistemasTouch tipo : sistemas) {
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.MENTOR_DESKTOP)) {
                typesBuild.add(AuxMavenBuilder.AppType.WEB_MODULES);
                typesBuild.add(AuxMavenBuilder.AppType.TOUCH_ERP_DESKTOP);
            }
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.NFCE)) {
                typesBuild.add(AuxMavenBuilder.AppType.WEB_MODULES);
                typesBuild.add(AuxMavenBuilder.AppType.TOUCH_NFCE);
            }
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO)) {
                typesBuild.add(AuxMavenBuilder.AppType.WEB_MODULES);
                typesBuild.add(AuxMavenBuilder.AppType.TOUCH_WEB_ANTIGO);
            }
            if (!TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.TOUCH_WEB_API) && !TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT)) continue;
            typesBuild.add(AuxMavenBuilder.AppType.WEB_MODULES);
            typesBuild.add(AuxMavenBuilder.AppType.TOUCH_WEB);
        }
    }

    private void getTypesInstall(List<EnumConstTipoSistemasTouch> sistemas, Set<AuxInstallBuilder.AppType> typesInstall) {
        for (EnumConstTipoSistemasTouch tipo : sistemas) {
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.MENTOR_DESKTOP)) {
                typesInstall.add(AuxInstallBuilder.AppType.TOUCH_ERP_DESKTOP);
            }
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.NFCE)) {
                typesInstall.add(AuxInstallBuilder.AppType.TOUCH_NFCE);
            }
            if (TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO)) {
                typesInstall.add(AuxInstallBuilder.AppType.TOUCH_WEB_ANTIGO);
            }
            if (!TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.TOUCH_WEB_API) && !TMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT)) continue;
            typesInstall.add(AuxInstallBuilder.AppType.TOUCH_WEB);
        }
    }

    private void changeVersaoAppCode(AuxSuiteVersao auxSuiteVersao) throws Exception {
        List<SuiteVersaoItem> itens = auxSuiteVersao.getItensSelecionadosVersao();
        for (SuiteVersaoItem item : itens) {
            new AuxAlterVersaoCodeApp().alterarVersaoApp(auxSuiteVersao.getSuiteVersao().getVersaoMentor(), item.getTipoBDVersao());
            new AuxAlterProfileYAMLApp().alterarProfileApp(auxSuiteVersao.getSuiteVersao().getVersaoMentor(), item.getTipoBDVersao());
        }
    }

    private void testarWildFly(DTOConfiguracoes conf, AuxSuiteVersao suiteVersao, List<EnumConstTipoSistemasTouch> tipos) throws Exception {
        Optional<EnumConstTipoSistemasTouch> find = tipos.stream().filter(i -> i.isWebApp()).findFirst();
        if (!find.isPresent()) {
            return;
        }
        if (this.chcNaoTestarWildfly.isSelected()) {
            return;
        }
        new AuxTestWeb(conf, this.getCurrentTask(), suiteVersao).testWeb(suiteVersao.getItensSelecionadosVersao());
        this.showNoModalInfo("Wildfly foi testado com sucesso. Feche a janela do Wildfly para economizar recursos e evitar erros em subir novamente as versoes.");
    }

    private void testarAppsAfterBuild(DTOConfiguracoes conf, AuxSuiteVersao suiteVersao, StagioController stagio, List<EnumConstTipoSistemasTouch> tipos) throws Exception {
        if (this.chcNaoRealizarTestes.isSelected()) {
            return;
        }
        Optional<EnumConstTipoSistemasTouch> find = tipos.stream().filter(i -> i.isApp()).findFirst();
        if (!find.isPresent()) {
            return;
        }
        new AuxQualityTests(conf, suiteVersao, this.getCurrentTask(), stagio, true, true).iniciarTestesApp();
    }

    private void testarAppsBeforeBuild(DTOConfiguracoes conf, AuxSuiteVersao suiteVersao, StagioController stagio, List<EnumConstTipoSistemasTouch> tipos) throws Exception {
        new AuxFrontEndTests(conf, suiteVersao.getSuiteVersao(), this.getCurrentTask(), stagio).iniciarTestesQualidade();
        new AuxNodoSearchTests(conf, suiteVersao.getSuiteVersao(), this.getCurrentTask(), stagio).iniciarTestesQualidade();
    }

    private void runVersao(DTOConfiguracoes conf, AuxSuiteVersao suiteVersao) {
        try {
            this.getAllTasks().onProgress(3, 3, "Construindo e enviando versao");
            new AuxVersao(conf, suiteVersao, this.getCurrentTask()).buildVersao();
            this.showNoModalInfo("Versao enviada com sucesso.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TLogger.get(TouchVersoesConfigFrame.class).error((Throwable)ex);
            ContatoDialogsHelper.showBigInfo((String)("Erro ao gerar a Versao. Verifique o log: " + ex.getMessage()));
        }
    }

    private void runInstaladores(DTOConfiguracoes conf, AuxSuiteVersao suiteVersao, Set<AuxInstallBuilder.AppType> typesInstall) {
        try {
            this.setSelectedLog();
            this.getAllTasks().onProgress(1, 2, "Instaladores");
            new AuxInstallBuilder(conf, suiteVersao, this.getCurrentTask()).build(typesInstall);
            this.getAllTasks().onProgress(2, 2, "Instaladores");
            this.showNoModalInfo("Instaladores gerados com sucesso.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TLogger.get(TouchVersoesConfigFrame.class).error((Throwable)ex);
            ContatoDialogsHelper.showBigInfo((String)("Erro ao realizar as tarefas. Verifique o log: " + ex.getMessage()));
        }
    }

    private void runAllTasks(final boolean somenteTestes) {
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                new Thread(this){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.runTasksInternal(somenteTestes);
                    }
                }.start();
            }
        });
    }

    private AuxSuiteVersao getSuiteVersao(VersaoMentor versao) {
        if (versao == null) {
            return null;
        }
        this.auxSuiteVersao = new AuxSuiteVersao(versao);
        return this.auxSuiteVersao;
    }

    private void setVersao() {
        VersaoMentor v = (VersaoMentor)this.cmbVersao.getSelectedItem();
        this.pnlInstaladores.clearScreen();
        this.pnlSuiteVersao.clearScreen();
        if (v == null) {
            this.auxSuiteVersao = null;
            return;
        }
        this.auxSuiteVersao = this.getSuiteVersao(v);
        this.pnlInstaladores.setSuiteVersao(this.auxSuiteVersao);
        this.pnlSuiteVersao.setSuiteVersao(this.auxSuiteVersao);
        this.pnlMaven.setSuiteVersao(this.auxSuiteVersao);
        this.pnlPatchs.setAuxSuiteVersao(this.auxSuiteVersao);
        this.pnlArquivoVersoes.setAuxSuiteVersao(this.auxSuiteVersao);
    }

    private void gerarVersao(final DTOConfiguracoes conf, final AuxSuiteVersao suiteVersao) {
        new Thread(this){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getAllTasks().onProgress(this.this$0.currentTask++, this.this$0.allTasks, "Gerando Versao e Instaladores");
                if (this.this$0.chcGerarVersao.isSelected()) {
                    this.this$0.runVersao(conf, suiteVersao);
                }
            }
        }.start();
    }

    private void gerarInstaladores(final DTOConfiguracoes conf, final AuxSuiteVersao suiteVersao, final Set<AuxInstallBuilder.AppType> typesInstall) {
        new Thread(this){
            final /* synthetic */ MainFrame this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.getAllTasks().onProgress(this.this$0.currentTask++, this.this$0.allTasks, "Gerando Instaladores");
                if (this.this$0.chcGerarInstaladores.isSelected()) {
                    this.this$0.runInstaladores(conf, suiteVersao, typesInstall);
                }
            }
        }.start();
    }

    private void showNoModalInfo(String string) {
        JOptionPane pane = new JOptionPane(string);
        JDialog dialog = pane.createDialog(this, "Informacao");
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    private boolean isArqModificacoesInformado(VersaoMentor versao) {
        for (VersaoMentorSistema v : versao.getSistemasVersao()) {
            if (!TMethods.isAffirmative((Number)v.getTipoBDVersao().getObrigarInfModificacoes()) || TMethods.isStrWithData((String)v.getUrlModificacoes())) continue;
            JOptionPane.showMessageDialog(null, "Sistema " + String.valueOf(v.getTipoBDVersao()) + " requer arquivo de modifica\u00e7\u00f5es, que n\u00e3o foi informado. Informe antes de continuar.");
            return false;
        }
        return true;
    }

    private void tempMesclarArquivos() throws ExceptionIO {
        ServiceSuiteVersaoItemImpl service = Main.getBean(ServiceSuiteVersaoItemImpl.class);
        List<SuiteVersaoItem> versoes = service.getVersoesHistArquivos();
        HashSet<TipoBDVersao> tipos = new HashSet<TipoBDVersao>();
        for (SuiteVersaoItem versoe : versoes) {
            tipos.add(versoe.getTipoBDVersao());
        }
        for (TipoBDVersao tipo : tipos) {
            LinkedList<SuiteVersaoItem> versoesSis = new LinkedList<SuiteVersaoItem>();
            for (SuiteVersaoItem vv : versoes) {
                if (!vv.getTipoBDVersao().equals(tipo)) continue;
                versoesSis.add(vv);
            }
            Collections.sort(versoesSis, (v1, v2) -> v1.getSuiteVersao().getVersaoMentor().getCodigo().compareTo(v2.getSuiteVersao().getVersaoMentor().getCodigo()));
            SuiteVersaoItem vAnt = null;
            for (SuiteVersaoItem vv : versoesSis) {
                if (vAnt != null) {
                    try {
                        List arquivosAntigos = ToolJson.readJsonList((String)vAnt.getDadosArquivos(), DTOFilesInfo.class);
                        List arquivosNovos = ToolJson.readJsonList((String)vv.getDadosArquivos(), DTOFilesInfo.class);
                        List<DTOFilesInfo> temp = new AuxCriarArquivoAtualizacaoLocal(null, null).mesclarArquivos(arquivosNovos, arquivosAntigos);
                        vv.setDadosArquivos(ToolJson.toJson(temp));
                        Main.getBean(ServiceSuiteVersaoItemImpl.class).saveOrUpdate(vv);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                vAnt = vv;
            }
        }
    }

    public static class StagioController {
        private List<StringToken> keys = new LinkedList<StringToken>();

        public StringToken getToken(String key) {
            Optional<StringToken> found = this.keys.stream().filter(i -> TMethods.isEquals((Object)i.getChave(), (Object)key)).findFirst();
            if (found.isPresent()) {
                return found.get();
            }
            return null;
        }

        public boolean containsToken(String key) {
            return this.getToken(key) != null;
        }
    }
}

