/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.instaladores;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.tools.ToolPaths;
import java.io.File;

public class AuxCopyInstaladores {
    private static final String INSTALL_64 = "output_x64.exe";
    private static final String INSTALL_32 = "output_x32.exe";
    final DTOConfiguracoes configuracoes;
    final AuxSuiteVersao suiteVersao;
    final ProgressCurrentTask currentTask;

    public AuxCopyInstaladores(DTOConfiguracoes configuracoes, AuxSuiteVersao suiteVersao, ProgressCurrentTask currentTask) {
        this.configuracoes = configuracoes;
        this.suiteVersao = suiteVersao;
        this.currentTask = currentTask;
    }

    public void copyInstaladoresEXE(SuiteVersaoItem item) throws Exception {
        File origx32 = new File(String.valueOf(ToolPaths.getLocalInstalador(item)) + File.separator + "output" + File.separator + INSTALL_32);
        File origx64 = new File(String.valueOf(ToolPaths.getLocalInstalador(item)) + File.separator + "output" + File.separator + INSTALL_64);
        String baseInstall = this.getBaseInstall(this.configuracoes, item);
        File destx32 = new File(baseInstall + File.separator + item.getSuiteVersao().getVersaoMentor().getCodigo() + File.separator + this.getAppName(item.getTipoBDVersao()) + "-" + item.getSuiteVersao().getVersaoMentor().getCodigo() + "-x32.exe");
        File destx64 = new File(baseInstall + File.separator + item.getSuiteVersao().getVersaoMentor().getCodigo() + File.separator + this.getAppName(item.getTipoBDVersao()) + "-" + item.getSuiteVersao().getVersaoMentor().getCodigo() + "-x64.exe");
        if (origx32.exists()) {
            ToolFile.copyFile((File)origx32, (File)destx32);
        }
        if (origx64.exists()) {
            ToolFile.copyFile((File)origx64, (File)destx64);
        }
    }

    public void copyInstaladoresJava(SuiteVersaoItem item) throws Exception {
        String baseInstall = this.getBaseInstall(this.configuracoes, item);
        File dest = new File(baseInstall + File.separator + item.getSuiteVersao().getVersaoMentor().getCodigo() + File.separator + this.getAppName(item.getTipoBDVersao()) + "-" + item.getSuiteVersao().getVersaoMentor().getCodigo() + ".jar");
        File orig = new File(String.valueOf(ToolPaths.getLocalInstaladorJava(item)) + File.separator + File.separator + "install.jar");
        ToolFile.copyFile((File)orig, (File)dest);
    }

    public void copyWars(SuiteVersaoItem item) throws Exception {
        String baseInstall = this.getBaseInstall(this.configuracoes, item);
        File dest = new File(baseInstall + File.separator + item.getSuiteVersao().getVersaoMentor().getCodigo() + File.separator + this.getAppName(item.getTipoBDVersao()) + "-" + item.getSuiteVersao().getVersaoMentor().getCodigo() + ".war");
        this.copyWars(item, dest);
    }

    public void copyJars(SuiteVersaoItem item) throws Exception {
        String baseInstall = this.getBaseInstall(this.configuracoes, item);
        File dest = new File(baseInstall + File.separator + item.getSuiteVersao().getVersaoMentor().getCodigo() + File.separator + this.getAppName(item.getTipoBDVersao()) + "-" + item.getSuiteVersao().getVersaoMentor().getCodigo() + ".jar");
        this.copyWars(item, dest);
    }

    public File copyWars(SuiteVersaoItem item, File dest) throws Exception {
        File orig = ToolPaths.getFileApp(item.getTipoBDVersao(), ".war");
        System.out.println("Copiando arquivo " + orig.getName() + " para " + dest.getAbsolutePath());
        if (dest.isDirectory()) {
            dest = new File(dest.getAbsolutePath() + File.separator + orig.getName());
        }
        if (!orig.exists()) {
            throw new Exception("Arquivo nao existe " + orig.getAbsolutePath() + ". Verifique o cadastro do Tipo BD Versao no ERP " + item.getTipoBDVersao().getDescricao());
        }
        if (dest.exists() && !dest.delete()) {
            throw new Exception("Arquivo ja existe no diretorio e nao possivel exclui-lo. Exclua e repita o processo. " + dest.getAbsolutePath());
        }
        ToolFile.copyFile((File)orig, (File)dest);
        return new File(dest.getParentFile().getAbsolutePath() + File.separator + orig.getName());
    }

    private String getAppName(TipoBDVersao tipoBDVersao) {
        String desc = tipoBDVersao.getDescricao();
        desc = desc.toLowerCase();
        desc = desc.replaceAll(" ", "_");
        return desc;
    }

    private String getBaseInstall(DTOConfiguracoes configuracoes, SuiteVersaoItem item) throws Exception {
        String baseInstall;
        if (TMethods.isEqualsNumber((Number)item.getTipoBDVersao().getCodigoSistema(), (Number)EnumConstTipoSistemasTouch.MENTOR_DESKTOP.getValue())) {
            baseInstall = configuracoes.getLocalInstaladoresBaseERP();
        } else if (TMethods.isEqualsNumber((Number)item.getTipoBDVersao().getCodigoSistema(), (Number)EnumConstTipoSistemasTouch.NFCE.getValue())) {
            baseInstall = configuracoes.getLocalInstaladoresBaseNFCe();
        } else if (TMethods.isEqualsNumber((Number)item.getTipoBDVersao().getCodigoSistema(), (Number)EnumConstTipoSistemasTouch.TOUCH_WEB_API.getValue()) || TMethods.isEqualsNumber((Number)item.getTipoBDVersao().getCodigoSistema(), (Number)EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO.getValue()) || TMethods.isEqualsNumber((Number)item.getTipoBDVersao().getCodigoSistema(), (Number)EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT.getValue())) {
            baseInstall = configuracoes.getLocalInstaladoresBaseWEB();
        } else {
            throw new Exception("Local de instalacao para o item n\u00e3o mapeado: " + String.valueOf(item));
        }
        return baseInstall;
    }
}

