/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.instaladores;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.instaladores.AuxCopyInstaladores;
import com.touchcomp.touchversoes.gui.mavenbuild.AuxMavenBuilder;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.tasks.instaladores.InstallExeFiles;
import com.touchcomp.touchversoes.tasks.instaladores.InstallJava;
import com.touchcomp.touchversoes.tools.ToolPaths;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class AuxInstallBuilder {
    final DTOConfiguracoes configuracoes;
    final AuxSuiteVersao suiteVersao;
    final ProgressCurrentTask currentTask;

    public AuxInstallBuilder(DTOConfiguracoes configuracoes, AuxSuiteVersao suiteVersao, ProgressCurrentTask currentTask) {
        this.configuracoes = configuracoes;
        this.suiteVersao = suiteVersao;
        this.currentTask = currentTask;
    }

    public void buildInstallerWEB(EnumConstTipoSistemasTouch tipo) throws Exception {
        if (!ToolPaths.existsSuiteItem(tipo, this.suiteVersao)) {
            return;
        }
        SuiteVersaoItem item = ToolPaths.getSuiteItem(tipo, this.suiteVersao);
        new AuxMavenBuilder(this.configuracoes, this.suiteVersao, this.currentTask).buildProjectsWeb(item, true);
        new AuxCopyInstaladores(this.configuracoes, this.suiteVersao, this.currentTask).copyWars(item);
        new AuxMavenBuilder(this.configuracoes, this.suiteVersao, this.currentTask).buildProjectsWeb(item, false);
        new AuxCopyInstaladores(this.configuracoes, this.suiteVersao, this.currentTask).copyJars(item);
    }

    private void buildInstallerTouchERP(EnumConstTipoSistemasTouch tipo) throws Exception {
        SuiteVersaoItem item = ToolPaths.getSuiteItem(tipo, this.suiteVersao);
        new InstallJava(this.getCurrentTask()).buildInstall(this.configuracoes, item);
        new AuxCopyInstaladores(this.configuracoes, this.suiteVersao, this.currentTask).copyInstaladoresJava(item);
        new InstallExeFiles(this.getCurrentTask()).buildInstall(this.configuracoes, item);
        new AuxCopyInstaladores(this.configuracoes, this.suiteVersao, this.currentTask).copyInstaladoresEXE(item);
    }

    public void build(AppType ... types) throws Exception {
        this.build(new LinkedHashSet<AppType>(Arrays.asList(types)));
    }

    public void build(Set<AppType> types) throws Exception {
        for (AppType type : types) {
            switch (type.ordinal()) {
                case 0: {
                    this.buildInstallerTouchERP(EnumConstTipoSistemasTouch.MENTOR_DESKTOP);
                    break;
                }
                case 1: {
                    this.buildInstallerTouchERP(EnumConstTipoSistemasTouch.NFCE);
                    break;
                }
                case 2: {
                    this.buildInstallerWEB(EnumConstTipoSistemasTouch.TOUCH_WEB_API);
                    this.buildInstallerWEB(EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT);
                    break;
                }
                case 3: {
                    this.buildInstallerWEB(EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO);
                }
            }
        }
    }

    public DTOConfiguracoes getConfiguracoes() {
        return this.configuracoes;
    }

    public AuxSuiteVersao getSuiteVersao() {
        return this.suiteVersao;
    }

    public String getCodigoVersao() {
        return this.suiteVersao.getSuiteVersao().getVersaoMentor().getCodigo().toString();
    }

    public ProgressCurrentTask getCurrentTask() {
        return this.currentTask;
    }

    public static enum AppType {
        TOUCH_ERP_DESKTOP,
        TOUCH_NFCE,
        TOUCH_WEB,
        TOUCH_WEB_ANTIGO;

    }
}

