/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.mavenbuild;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.mavenbuild.AuxForceWebJar;
import com.touchcomp.touchversoes.gui.mavenbuild.AuxForceWebWar;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.SuiteVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.tasks.build.maven.BuildMaven;
import com.touchcomp.touchversoes.tools.ToolPaths;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;

public class AuxMavenBuilder {
    private final DTOConfiguracoes configuracoes;
    private final AuxSuiteVersao suiteVersao;
    private final ProgressCurrentTask currentTask;

    public AuxMavenBuilder(DTOConfiguracoes configuracoes, AuxSuiteVersao suiteVersao, ProgressCurrentTask currentTask) {
        this.configuracoes = configuracoes;
        this.suiteVersao = suiteVersao;
        this.currentTask = currentTask;
    }

    public void build(AppType ... types) throws Exception {
        this.build(new LinkedHashSet<AppType>(Arrays.asList(types)));
    }

    public void build(Set<AppType> types) throws Exception {
        if (ToolPaths.existsSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_API, this.suiteVersao)) {
            new AuxForceWebWar().forceType(this.configuracoes, ToolPaths.getSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_API, this.suiteVersao));
        }
        if (ToolPaths.existsSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT, this.suiteVersao)) {
            new AuxForceWebWar().forceType(this.configuracoes, ToolPaths.getSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT, this.suiteVersao));
        }
        if (ToolPaths.existsSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO, this.suiteVersao)) {
            new AuxForceWebWar().forceType(this.configuracoes, ToolPaths.getSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO, this.suiteVersao));
        }
        new BuildMaven(this.getCurrentTask()).buildMavenPreProjects(this.getConfiguracoes());
        for (AppType type : types) {
            switch (type.ordinal()) {
                case 1: {
                    new BuildMaven(this.getCurrentTask()).buildMavenPreProjectsDesktop(this.getConfiguracoes());
                    this.buildProjects(EnumConstTipoSistemasTouch.MENTOR_DESKTOP);
                    break;
                }
                case 2: {
                    new BuildMaven(this.getCurrentTask()).buildMavenPreProjectsNFCe(this.getConfiguracoes());
                    this.buildProjects(EnumConstTipoSistemasTouch.NFCE);
                    break;
                }
                case 3: {
                    if (ToolPaths.existsSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_API, this.suiteVersao)) {
                        this.buildProjectsWeb(EnumConstTipoSistemasTouch.TOUCH_WEB_API);
                    }
                    if (!ToolPaths.existsSuiteItem(EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT, this.suiteVersao)) break;
                    this.buildProjectsWeb(EnumConstTipoSistemasTouch.TOUCH_WEB_FRONT);
                    break;
                }
                case 4: {
                    this.buildProjectsWeb(EnumConstTipoSistemasTouch.TOUCH_WEB_ANTIGO);
                    break;
                }
                case 0: {
                    this.buildProjectsWebModules();
                }
            }
        }
    }

    public void buildProjectsWebModules() throws Exception {
        System.out.println("build webmodules");
        new BuildMaven(this.getCurrentTask()).buildTouchWebModules(this.getConfiguracoes());
    }

    private void buildProjects(EnumConstTipoSistemasTouch tipoSys) throws Exception {
        System.out.println("build " + tipoSys.toString());
        new BuildMaven(this.getCurrentTask()).buildMaven(this.getConfiguracoes(), ToolPaths.getSuiteItem(tipoSys, this.suiteVersao));
    }

    public void buildProjectsWeb(EnumConstTipoSistemasTouch tipo) throws Exception {
        this.buildProjectsWeb(ToolPaths.getSuiteItem(tipo, this.suiteVersao), true);
    }

    public void buildProjectsWeb(SuiteVersaoItem item, boolean isWar) throws Exception {
        System.out.println("build projetos web");
        if (isWar) {
            new AuxForceWebWar().forceType(this.configuracoes, item);
        } else {
            new AuxForceWebJar().forceType(this.configuracoes, item);
        }
        this.buildProjects(EnumConstTipoSistemasTouch.get((Object)item.getTipoBDVersao().getCodigoSistema()));
    }

    public DTOConfiguracoes getConfiguracoes() {
        return this.configuracoes;
    }

    public SuiteVersao getSuiteVersao() {
        return this.suiteVersao.getSuiteVersao();
    }

    public String getCodigoVersao() {
        return this.suiteVersao.getSuiteVersao().getVersaoMentor().getCodigo().toString();
    }

    public ProgressCurrentTask getCurrentTask() {
        return this.currentTask;
    }

    public static enum AppType {
        WEB_MODULES,
        TOUCH_ERP_DESKTOP,
        TOUCH_NFCE,
        TOUCH_WEB,
        TOUCH_WEB_ANTIGO;

    }
}

