/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.patches;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.ftp.ToolFTP;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchversoes.Main;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.mavenbuild.AuxMavenBuilder;
import com.touchcomp.touchversoes.gui.patches.AuxBasePatch;
import com.touchcomp.touchversoes.gui.patches.dto.DTOPatches;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.gui.suiteversao.util.UtilSuiteVersao;
import com.touchcomp.touchversoes.model.ServidorFTP;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.service.suiteversao.ServiceSuiteVersaoImpl;
import contato.util.contatofilechooser.ContatoFileChooserUtilities;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class AuxAddPatch {
    public DTOPatches.Patch adicionarPath(DTOPatches dto, AuxSuiteVersao auxVersao, DTOConfiguracoes conf, ProgressCurrentTask progress) throws Exception {
        if (dto == null || dto.getPath() == null) {
            JOptionPane.showMessageDialog(null, "Selecione uma versao.");
            return null;
        }
        new UtilSuiteVersao().checkGitBranch(conf, auxVersao.getSuiteVersao().getVersaoMentor());
        String descricao = JOptionPane.showInputDialog("Informe a descricao para o arquivo");
        if (descricao == null || descricao.trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Informe a descri\u00e7\u00e3o para o arquivo.");
            return null;
        }
        auxVersao.setItensSelecionadosVersao(auxVersao.getSuiteVersao().getItens());
        int op = JOptionPane.showConfirmDialog(null, "Deseja gerar automaticamente?");
        File f = null;
        f = op == 0 ? this.getArquivoAuto(auxVersao, conf, progress) : this.getArquivo();
        if (f == null) {
            return null;
        }
        ServidorFTP servidor = auxVersao.getSuiteVersao().getServidorFTP();
        VersaoMentor versao = auxVersao.getSuiteVersao().getVersaoMentor();
        DTOPatches.Patch p = new DTOPatches.Patch();
        p.setCaminho(f.getAbsolutePath());
        p.setData(new Date());
        p.setDescricao(descricao);
        p.setNumero(this.gerarNumAleatorio(dto));
        p.setResponsavel("");
        p.setVersaoPath(versao.getDescricao());
        p.setVersaoPathCodigo(versao.getCodigo());
        String url = this.uparArquivo(f, p.getNumero().toString(), servidor);
        p.setUrl(url);
        dto.getPath().add(0, p);
        new AuxBasePatch().enviarConfiguracoes(servidor, dto);
        return p;
    }

    private String uparArquivo(File f, String number, ServidorFTP servidor) throws ExceptionIO {
        String ext = f.getName().substring(f.getName().lastIndexOf("."));
        ToolFTP.useFTP((String)servidor.getEndereco(), (String)servidor.getCaminhoBaseFtp(), (String)"/mentor/patch/arquivos/", (String)(number + ext), (File)f, (String)servidor.getUsuario(), (String)servidor.getSenha());
        return "https://www.toucherp.com.br/mentor/patch/arquivos/" + number + ext;
    }

    private Long gerarNumAleatorio(DTOPatches dto) {
        int iTemp;
        Optional<DTOPatches.Patch> aux = null;
        Integer i = 0;
        do {
            Random gerador = new Random();
            i = gerador.nextInt(100000);
            iTemp = i;
        } while (dto != null && dto.getPath() != null && (aux = dto.getPath().stream().filter(j -> j != null && j.getNumero().intValue() == iTemp).findFirst()) != null && aux.isPresent());
        return i.longValue();
    }

    private File getArquivo() {
        File f = ContatoFileChooserUtilities.getFileToLoad((FileFilter)new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return "Arquivos zip";
            }
        });
        return f;
    }

    private File getArquivoAuto(AuxSuiteVersao auxVersao, DTOConfiguracoes conf, ProgressCurrentTask progress) throws Exception {
        Optional<SuiteVersaoItem> sMentor = auxVersao.getSuiteVersao().getItens().stream().filter(i -> TMethods.isEquals((Object)EnumConstTipoSistemasTouch.get((Object)i.getTipoBDVersao().getCodigoSistema()), (Object)EnumConstTipoSistemasTouch.MENTOR_DESKTOP)).findFirst();
        if (!sMentor.isPresent()) {
            JOptionPane.showMessageDialog(null, "N\u00e3o foi encontraro o Touch Comp ERP nos aplicativos da versao.");
            return null;
        }
        LinkedHashSet<AuxMavenBuilder.AppType> typesBuild = new LinkedHashSet<AuxMavenBuilder.AppType>();
        typesBuild.add(AuxMavenBuilder.AppType.WEB_MODULES);
        typesBuild.add(AuxMavenBuilder.AppType.TOUCH_ERP_DESKTOP);
        new AuxMavenBuilder(conf, auxVersao, progress).build(typesBuild);
        ServiceSuiteVersaoImpl serv = Main.getBean(ServiceSuiteVersaoImpl.class);
        return serv.createFileLocalPatch(sMentor.get());
    }
}

