/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.patches;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jaxb.ExceptionJaxb;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.ftp.ToolFTP;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.patches.dto.DTOPatches;
import com.touchcomp.touchversoes.model.ServidorFTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class AuxBasePatch {
    public DTOPatches getPatches(AuxSuiteVersao auxSuiteVersao) throws ExceptionIO, ExceptionJaxb {
        FileInputStream fio = null;
        try {
            ServidorFTP servidor = auxSuiteVersao.getSuiteVersao().getServidorFTP();
            File tmp = ToolFile.createTempFile((String)"temp", (String)".touch");
            ToolFTP.getFileFTP((String)servidor.getEndereco(), (String)servidor.getCaminhoBaseFtp(), (String)"/mentor/patch/", (String)"paths.touch", (File)tmp, (String)servidor.getUsuario(), (String)servidor.getSenha());
            fio = new FileInputStream(tmp);
            Document d = new SAXBuilder().build((InputStream)fio);
            Element root = d.getRootElement();
            List childs = root.getChildren();
            ArrayList<DTOPatches.Patch> aux = new ArrayList<DTOPatches.Patch>();
            for (int i = childs.size() - 1; i >= 0; --i) {
                Element el = (Element)childs.get(i);
                Long numero = Long.valueOf(el.getAttributeValue("numero"));
                String descricao = el.getAttributeValue("descricao");
                String caminho = el.getAttributeValue("caminho");
                String url = el.getAttributeValue("url");
                String responsavel = el.getAttributeValue("responsavel");
                Date data = ToolDate.strToDate((String)el.getAttributeValue("Data"));
                String versao = el.getAttributeValue("versaoPath");
                Long versaoPathCodigo = 0L;
                String codVersao = el.getAttributeValue("versaoPathCodigo");
                if (ToolString.onlyNumbers((String)codVersao).length() == 10) {
                    versaoPathCodigo = Long.valueOf(codVersao);
                } else {
                    codVersao = ToolString.onlyNumbers((String)versao);
                    versaoPathCodigo = Long.valueOf(ToolString.completaZeros((String)codVersao, (int)10));
                }
                DTOPatches.Patch p = new DTOPatches.Patch();
                p.setCaminho(caminho);
                p.setData(data);
                p.setDescricao(descricao);
                p.setNumero(numero);
                p.setResponsavel(responsavel);
                p.setUrl(url);
                p.setVersaoPath(versao);
                p.setVersaoPathCodigo(versaoPathCodigo);
                aux.add(p);
            }
            this.ordenarData(aux);
            DTOPatches dto = new DTOPatches();
            dto.setPath(aux);
            DTOPatches dTOPatches = dto;
            return dTOPatches;
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionIO((IOException)ex);
        }
        catch (JDOMException ex) {
            throw new ExceptionIO((Exception)((Object)ex), new Object[0]);
        }
        catch (IOException ex) {
            throw new ExceptionIO(ex);
        }
        finally {
            try {
                if (fio != null) {
                    fio.close();
                }
            }
            catch (IOException ex) {
                throw new ExceptionIO(ex);
            }
        }
    }

    private List ordenarData(List<DTOPatches.Patch> aux) {
        if (aux != null) {
            Collections.sort(aux, new Comparator<DTOPatches.Patch>(this){

                @Override
                public int compare(DTOPatches.Patch o1, DTOPatches.Patch o2) {
                    if (o2.getData() == null || o1.getData() == null) {
                        return 0;
                    }
                    return o2.getData().compareTo(o1.getData());
                }
            });
            return aux;
        }
        return null;
    }

    public void enviarConfiguracoes(ServidorFTP servidor, DTOPatches dados) throws Exception {
        Element root = new Element("mentor");
        for (DTOPatches.Patch path : dados.getPath()) {
            Element e = new Element("path");
            e.setAttribute("numero", path.getNumero().toString());
            e.setAttribute("descricao", path.getDescricao());
            e.setAttribute("caminho", path.getCaminho());
            e.setAttribute("url", path.getUrl());
            e.setAttribute("responsavel", path.getResponsavel());
            e.setAttribute("Data", ToolDate.dateToStr((Date)path.getData(), (String)"dd/MM/yyyy"));
            e.setAttribute("versaoPath", path.getVersaoPath().toUpperCase());
            e.setAttribute("versaoPathCodigo", String.valueOf(path.getVersaoPathCodigo()));
            root.addContent((Content)e);
        }
        Document d = new Document(root);
        File tmp = ToolFile.createTempFile((String)"paths.touch");
        try (FileOutputStream outStream = new FileOutputStream(tmp);){
            XMLOutputter out = new XMLOutputter(Format.getPrettyFormat());
            out.output(d, (OutputStream)outStream);
            outStream.flush();
        }
        ToolFTP.useFTP((String)servidor.getEndereco(), (String)servidor.getCaminhoBaseFtp(), (String)"/mentor/patch/", (String)"paths.touch", (File)tmp, (String)servidor.getUsuario(), (String)servidor.getSenha());
    }
}

