/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.patches;

import com.touchcomp.basementortools.tools.ftp.ToolFTP;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.patches.AuxBasePatch;
import com.touchcomp.touchversoes.gui.patches.dto.DTOPatches;
import com.touchcomp.touchversoes.model.ServidorFTP;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class AuxLimparPatches {
    public void limparPatchs(DTOPatches dtoPatches, AuxSuiteVersao auxSuiteVersao) throws Exception {
        if (dtoPatches == null) {
            JOptionPane.showMessageDialog(null, "Carregue o arquivo de patches.");
            return;
        }
        if (auxSuiteVersao == null) {
            JOptionPane.showMessageDialog(null, "Selecione uma versao base para continuar.");
            return;
        }
        LinkedHashSet<Long> temp = new LinkedHashSet<Long>();
        dtoPatches.getPath().forEach(i -> temp.add(i.getVersaoPathCodigo()));
        List<Long> aux = this.ordenar(temp);
        Long sel = (Long)JOptionPane.showInputDialog(null, "Selecione uma versao. Todos os patch's anteriores a data ser\u00e3o exclu\u00eddos.", "", 1, null, aux.toArray(), null);
        if (sel == null) {
            return;
        }
        List patches = dtoPatches.getPath().stream().filter(i -> i.getVersaoPathCodigo() <= sel).collect(Collectors.toList());
        ServidorFTP serv = auxSuiteVersao.getSuiteVersao().getServidorFTP();
        for (DTOPatches.Patch path : patches) {
            String name = this.getName(path);
            ToolFTP.deleteFileFTP((String)serv.getEndereco(), (String)serv.getCaminhoBaseFtp(), (String)"/mentor/patch/arquivos/", (String)name, (String)serv.getUsuario(), (String)serv.getSenha());
        }
        dtoPatches.getPath().removeAll(patches);
        new AuxBasePatch().enviarConfiguracoes(auxSuiteVersao.getSuiteVersao().getServidorFTP(), dtoPatches);
    }

    public void removerPatchs(DTOPatches dtoPatches, DTOPatches.Patch patch, AuxSuiteVersao auxSuiteVersao) throws Exception {
        if (patch == null) {
            JOptionPane.showMessageDialog(null, "Selecione um patch.");
            return;
        }
        if (auxSuiteVersao == null) {
            JOptionPane.showMessageDialog(null, "Selecione uma versao base para continuar.");
            return;
        }
        dtoPatches.getPath().removeIf(i -> i.getNumero().longValue() == patch.getNumero().longValue());
        String name = this.getName(patch);
        ServidorFTP serv = auxSuiteVersao.getSuiteVersao().getServidorFTP();
        ToolFTP.deleteFileFTP((String)serv.getEndereco(), (String)serv.getCaminhoBaseFtp(), (String)"/mentor/patch/arquivos/", (String)name, (String)serv.getUsuario(), (String)serv.getSenha());
        new AuxBasePatch().enviarConfiguracoes(auxSuiteVersao.getSuiteVersao().getServidorFTP(), dtoPatches);
    }

    private List<Long> ordenar(Set<Long> versoes) {
        LinkedList<Long> aux = new LinkedList<Long>(versoes);
        Collections.sort(aux, new Comparator<Long>(this){

            @Override
            public int compare(Long o1, Long o2) {
                return o1.compareTo(o2);
            }
        });
        return aux;
    }

    private String getName(DTOPatches.Patch patch) {
        String name = patch.getUrl();
        name = name.substring(name.lastIndexOf("/") + 1);
        return name;
    }
}

