/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.patches;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.MainFrame;
import com.touchcomp.touchversoes.gui.patches.AuxAddPatch;
import com.touchcomp.touchversoes.gui.patches.AuxBasePatch;
import com.touchcomp.touchversoes.gui.patches.AuxLimparPatches;
import com.touchcomp.touchversoes.gui.patches.dto.DTOPatches;
import com.touchcomp.touchversoes.gui.patches.model.PacthesColumnModel;
import com.touchcomp.touchversoes.gui.patches.model.PacthesTableModel;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.gui.splash.SplashScreenFrame;
import com.touchcomp.touchversoes.properties.ConfigProperties;
import contato.swing.ContatoButton;
import contato.swing.ContatoCheckBox;
import contato.swing.ContatoPanel;
import contato.swing.ContatoTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TouchPatchFrame
extends JPanel
implements ActionListener {
    private AuxSuiteVersao auxSuiteVersao;
    private MainFrame pnlMain;
    private ProgressCurrentTask progress;
    private TLogger logger = TLogger.get((Object)this);
    private DTOPatches dtoPatches;
    private ContatoButton btnCarregar;
    private ContatoButton btnLimpar;
    private ContatoButton btnNovo;
    private ContatoButton btnRemover;
    private ContatoCheckBox chcCarregarTodosPatchs;
    private ContatoPanel contatoPanel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private ContatoTable tblPatches;

    public TouchPatchFrame() {
        this.initComponents();
        this.initFields();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblPatches = new ContatoTable();
        this.contatoPanel1 = new ContatoPanel();
        this.btnNovo = new ContatoButton();
        this.btnRemover = new ContatoButton();
        this.btnCarregar = new ContatoButton();
        this.btnLimpar = new ContatoButton();
        this.chcCarregarTodosPatchs = new ContatoCheckBox();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.tblPatches.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this.tblPatches);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.btnNovo.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/new.png")));
        this.btnNovo.setText("Novo");
        this.btnNovo.setMinimumSize(new Dimension(120, 20));
        this.btnNovo.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 6, 6, 0);
        this.contatoPanel1.add((Component)this.btnNovo, (Object)gridBagConstraints);
        this.btnRemover.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/delete.png")));
        this.btnRemover.setText("Remover");
        this.btnRemover.setMinimumSize(new Dimension(120, 20));
        this.btnRemover.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 6, 6, 0);
        this.contatoPanel1.add((Component)this.btnRemover, (Object)gridBagConstraints);
        this.btnCarregar.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/find.png")));
        this.btnCarregar.setText("Carregar");
        this.btnCarregar.setMinimumSize(new Dimension(120, 20));
        this.btnCarregar.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 6, 6, 0);
        this.contatoPanel1.add((Component)this.btnCarregar, (Object)gridBagConstraints);
        this.btnLimpar.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/delete.png")));
        this.btnLimpar.setText("Limpar");
        this.btnLimpar.setMinimumSize(new Dimension(120, 20));
        this.btnLimpar.setPreferredSize(new Dimension(120, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(7, 6, 6, 0);
        this.contatoPanel1.add((Component)this.btnLimpar, (Object)gridBagConstraints);
        this.chcCarregarTodosPatchs.setText("Carregar Todos Patchs");
        this.chcCarregarTodosPatchs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                TouchPatchFrame.this.chcCarregarTodosPatchsItemStateChanged(evt);
            }
        });
        this.chcCarregarTodosPatchs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TouchPatchFrame.this.chcCarregarTodosPatchsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        this.contatoPanel1.add((Component)this.chcCarregarTodosPatchs, (Object)gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        this.jPanel1.add((Component)this.contatoPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void chcCarregarTodosPatchsItemStateChanged(ItemEvent evt) {
    }

    private void chcCarregarTodosPatchsActionPerformed(ActionEvent evt) {
        this.carregarPatches();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.btnNovo)) {
            this.adicionarPath();
        } else if (e.getSource().equals(this.btnRemover)) {
            this.removerPath();
        } else if (e.getSource().equals(this.btnCarregar)) {
            this.carregarPatches();
        } else if (e.getSource().equals(this.btnLimpar)) {
            this.limparPatchs();
        }
    }

    private void initFields() {
        this.btnNovo.addActionListener((ActionListener)this);
        this.btnRemover.addActionListener((ActionListener)this);
        this.btnCarregar.addActionListener((ActionListener)this);
        this.btnLimpar.addActionListener((ActionListener)this);
        this.tblPatches.setModel((TableModel)((Object)new PacthesTableModel(null)));
        this.tblPatches.setColumnModel((TableColumnModel)((Object)new PacthesColumnModel()));
        this.tblPatches.setGetOutTableLastCell(false);
        this.tblPatches.setProcessFocusFirstCell(false);
    }

    private void removerPath() {
        Runnable run = () -> {
            try {
                DTOPatches.Patch sel = (DTOPatches.Patch)this.tblPatches.getSelectedObject();
                if (sel == null) {
                    JOptionPane.showMessageDialog(null, "Selecione um patch");
                }
                new AuxLimparPatches().removerPatchs(this.dtoPatches, sel, this.auxSuiteVersao);
                this.carregarPatches();
                JOptionPane.showMessageDialog(null, "Processo realizado com sucesso.");
            }
            catch (Exception ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
                JOptionPane.showMessageDialog(null, "Erro ao upar/ler o arquivo");
            }
        };
        SplashScreenFrame.runInThread(run);
    }

    private void carregarPatches() {
        Runnable run = () -> this.carregarPatchsInternal();
        SplashScreenFrame.runInThread(run);
    }

    private void getFocoUltimoPath() {
        if (!this.tblPatches.getObjects().isEmpty()) {
            this.tblPatches.setSelectRows(0, 0);
        }
    }

    public void limparPatchs() {
        Runnable run = () -> {
            SplashScreenFrame spl = new SplashScreenFrame((Window)this.pnlMain);
            try {
                spl.showSplash();
                new AuxLimparPatches().limparPatchs(this.dtoPatches, this.auxSuiteVersao);
                this.carregarPatches();
                JOptionPane.showMessageDialog(null, "Processo realizado com sucesso.");
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
                JOptionPane.showMessageDialog(null, "Erro ao limpar os arquivos de Patch.");
            }
            finally {
                spl.setVisible(false);
            }
        };
        SplashScreenFrame.runInThread(run);
    }

    public MainFrame getPnlMain() {
        return this.pnlMain;
    }

    public void setPnlMain(MainFrame pnlMain) {
        this.pnlMain = pnlMain;
    }

    private ProgressCurrentTask getCurrentTask() {
        return this.pnlMain.getCurrentTask();
    }

    private ProgressCurrentTask getAllTasks() {
        return this.pnlMain.getAllTasks();
    }

    public DTOConfiguracoes getConfiguracoes() {
        return ConfigProperties.get().getConfiguracoes();
    }

    public ProgressCurrentTask getProgress() {
        return this.progress;
    }

    public void setProgress(ProgressCurrentTask progress) {
        this.progress = progress;
    }

    public void setAuxSuiteVersao(AuxSuiteVersao auxSuiteVersao) {
        this.auxSuiteVersao = auxSuiteVersao;
    }

    private void adicionarPath() {
        Runnable run = () -> {
            try {
                this.carregarPatchsInternal();
                this.pnlMain.setSelectedLog();
                DTOPatches.Patch p = new AuxAddPatch().adicionarPath(this.dtoPatches, this.auxSuiteVersao, ConfigProperties.get().getConfiguracoes(), this.getAllTasks());
                if (p != null) {
                    JOptionPane.showMessageDialog(this, "Patch enviado com sucesso: " + p.getNumero());
                    this.carregarPatches();
                }
            }
            catch (Exception ex) {
                this.logger.error((Throwable)ex);
                JOptionPane.showMessageDialog(null, "Erro ao realizar a adicao do Patch: " + ex.getMessage());
            }
        };
        SplashScreenFrame.runInThread(run);
    }

    private void carregarPatchsTabela() {
        List<DTOPatches.Patch> aux = this.dtoPatches.getPath();
        if (!this.chcCarregarTodosPatchs.isSelected()) {
            aux = this.dtoPatches.getPath().stream().filter(i -> TMethods.isEquals((Object)i.getVersaoPathCodigo(), (Object)this.auxSuiteVersao.getSuiteVersao().getVersaoMentor().getCodigo())).collect(Collectors.toList());
        }
        this.tblPatches.addRows(aux, false);
        this.getFocoUltimoPath();
    }

    private void carregarPatchsInternal() {
        try {
            this.tblPatches.clear();
            if (this.auxSuiteVersao.getSuiteVersao().getServidorFTP() == null) {
                JOptionPane.showMessageDialog(this, "Informe o servidor FTP.");
                return;
            }
            this.dtoPatches = new AuxBasePatch().getPatches(this.auxSuiteVersao);
            this.carregarPatchsTabela();
            JOptionPane.showMessageDialog(null, "Patches carregados.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error(ex.getClass(), (Throwable)ex);
            JOptionPane.showMessageDialog(this, "Erro ao pesquisar os servidores FTP.");
        }
    }
}

