/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.suiteversao;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.tools.ToolPaths;
import java.io.File;
import java.util.List;
import java.util.Optional;

public class AuxAlterVersaoCodeApp {
    private final String VERSAO_SISTEMA_FIELD = "VERSAO_SISTEMA";
    private final String CONSTANTS_VERSAO_App_CLASS = "ConstantsVersaoApp";
    private final String CONSTANTS_VERSAO_APP_CLASS = "ConstantsVersaoAPP";

    public void alterarVersaoApp(VersaoMentor versao, TipoBDVersao tipoSistema) throws Exception {
        String pathClass = tipoSistema.getClasseControleVersao();
        if (!ToolMethods.isStrWithData((String)pathClass)) {
            return;
        }
        String filePath = ToolPaths.getProjectAppDir(tipoSistema).getAbsolutePath() + File.separator + pathClass;
        File fileClass = new File(filePath);
        if (!fileClass.exists()) {
            throw new Exception("Classe de controle de versao nao encontrada: " + filePath);
        }
        JavaParser parser = new JavaParser();
        ParseResult pr = parser.parse(fileClass);
        if (!pr.isSuccessful()) {
            throw new Exception("Nao foi possivel ler a classe: " + filePath + " Problemas:\n " + String.valueOf(pr.getProblems()));
        }
        CompilationUnit unit = (CompilationUnit)pr.getResult().get();
        Optional opClass = unit.getInterfaceByName("ConstantsVersaoApp");
        if (!opClass.isPresent()) {
            opClass = unit.getInterfaceByName("ConstantsVersaoAPP");
        }
        if (!opClass.isPresent()) {
            throw new Exception("Nao foi possivel ler a classe ConstantsVersaoAPP");
        }
        ClassOrInterfaceDeclaration myClassSourceFile = (ClassOrInterfaceDeclaration)opClass.get();
        List fields = myClassSourceFile.getFields();
        Optional<FieldDeclaration> fOp = fields.stream().filter(i -> this.getFieldName((FieldDeclaration)i).equals("VERSAO_SISTEMA")).findFirst();
        if (!fOp.isPresent()) {
            throw new Exception("Nao foi possivel encontrar o atributoVERSAO_SISTEMA na classe ConstantsVersaoAPP para o projeto " + String.valueOf(tipoSistema));
        }
        FieldDeclaration field = fOp.get();
        ((VariableDeclarator)field.getVariables().get(0)).setInitializer(String.valueOf(versao.getCodigo()));
        String code = unit.toString();
        ToolFile.writeStringInFile((File)fileClass, (String)code);
    }

    public String getFieldName(FieldDeclaration field) {
        for (Node childNode : field.getChildNodes()) {
            if (!(childNode instanceof VariableDeclarator)) continue;
            return ((VariableDeclarator)childNode).getNameAsString();
        }
        return "";
    }
}

