/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.suiteversao;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemaUpdate;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.touchversoes.Main;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.gui.suiteversao.util.UtilSuiteVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.service.suiteversao.ServiceSuiteVersaoImpl;
import com.touchcomp.touchversoes.service.tipobdversao.ServiceTipoBDVersaoImpl;
import com.touchcomp.touchversoes.tools.ToolPaths;
import com.touchcomp.touchvomodel.temp.DTOSuiteVersaoQueryTest;
import java.io.File;
import java.util.List;

public class AuxVersao {
    final DTOConfiguracoes configuracoes;
    final AuxSuiteVersao auxSuiteVersao;
    final ProgressCurrentTask currentTask;

    public AuxVersao(DTOConfiguracoes configuracoes, AuxSuiteVersao suiteVersao, ProgressCurrentTask currentTask) {
        this.configuracoes = configuracoes;
        this.auxSuiteVersao = suiteVersao;
        this.currentTask = currentTask;
    }

    public void buildVersao() throws Exception {
        List<TipoBDVersao> todos = Main.getBean(ServiceTipoBDVersaoImpl.class).getTiposAtivos();
        this.currentTask.onProgress(0, 0, "realizando build projetos");
        this.buildFiles();
        this.currentTask.onProgress(0, 0, "enviando versao FTP");
        this.enviarVersao(this.auxSuiteVersao.getItensSelecionadosVersao(), todos);
    }

    private void buildFiles() throws Exception {
        ToolFile.removeFiles((File)ToolPaths.getVersionsDir());
        int i = 0;
        for (SuiteVersaoItem item : this.auxSuiteVersao.getItensSelecionadosVersao()) {
            this.currentTask.onProgress(i, this.auxSuiteVersao.getItensSelecionadosVersao().size(), "Gerando atualizacao " + String.valueOf(item.getTipoBDVersao()));
            this.gerarVersao(item, this.configuracoes.getLocalProjetoBase());
            this.currentTask.onProgress(i, this.auxSuiteVersao.getItensSelecionadosVersao().size(), "Gerando atualizacao " + String.valueOf(item.getTipoBDVersao()));
            ++i;
        }
        this.auxSuiteVersao.saveOrUdate();
    }

    private void gerarVersao(SuiteVersaoItem item, String localProjetos) throws Exception {
        EnumConstTipoSistemaUpdate tipo = EnumConstTipoSistemaUpdate.get((Object)item.getTipoBDVersao().getTipo());
        ServiceSuiteVersaoImpl service = Main.getBean(ServiceSuiteVersaoImpl.class);
        File f = null;
        switch (tipo) {
            case TIPO_APP_BANCO: {
                f = service.createFileBDVersao(this.getVersaoMentor(), item, localProjetos);
                break;
            }
            case TIPO_APP_WEB: {
                f = service.createFileWEBApp(this.getVersaoMentor(), item);
                break;
            }
            case TIPO_APP_LOCAL: {
                f = service.createFileLocal(this.getVersaoMentor(), item);
                break;
            }
            case TIPO_APP_REMOTO: {
                f = service.createFileRemote(this.getVersaoMentor(), item);
                break;
            }
            case TIPO_APP_MOBILE: {
                break;
            }
            case TIPO_APP_LOCAL_BD: {
                f = service.createFileLocalBD(this.getVersaoMentor(), item, localProjetos);
            }
        }
        if (f != null && f.exists()) {
            this.loadFile(item, f);
        }
    }

    private void loadFile(SuiteVersaoItem q, File f) {
        if (f != null) {
            q.setArquivo(f.getAbsolutePath());
            q.setArquivoCarregado((short)1);
            q.setTamanhoArquivo(f.length());
        }
    }

    private void enviarVersao(List<SuiteVersaoItem> itens, List<TipoBDVersao> todos) throws Exception {
        new UtilSuiteVersao().validaArquivoVersao(this.auxSuiteVersao.getSuiteVersao());
        new UtilSuiteVersao().enviarAtualizarArquivoConfig(this.auxSuiteVersao.getSuiteVersao(), itens, true, todos);
        new UtilSuiteVersao().validaArquivoVersao(this.auxSuiteVersao.getSuiteVersao());
        this.auxSuiteVersao.saveOrUdate();
    }

    private DTOSuiteVersaoQueryTest testDatabase() throws Exception {
        return null;
    }

    private VersaoMentor getVersaoMentor() {
        return this.auxSuiteVersao.getSuiteVersao().getVersaoMentor();
    }
}

