/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.suiteversao;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.touchversoes.Main;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.suiteversao.model.DTOSuiteVersaoColumnModel;
import com.touchcomp.touchversoes.gui.suiteversao.model.DTOSuiteVersaoItemColumnModel;
import com.touchcomp.touchversoes.gui.suiteversao.model.DTOSuiteVersaoItemTableModel;
import com.touchcomp.touchversoes.gui.suiteversao.model.DTOSuiteVersaoTableModel;
import com.touchcomp.touchversoes.gui.suiteversao.util.UtilSuiteVersao;
import com.touchcomp.touchversoes.model.ServidorFTP;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.model.VersaoMentorSistema;
import com.touchcomp.touchversoes.service.servidorftp.ServiceServidorFTPImpl;
import com.touchcomp.touchvomodel.temp.DTOSuiteUpdate;
import contato.dialog.ContatoDialogsHelper;
import contato.swing.ContatoButton;
import contato.swing.ContatoPanel;
import contato.swing.ContatoSplitPane;
import contato.swing.ContatoTable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TouchArquivoConfVersoesFrame
extends JPanel {
    private AuxSuiteVersao auxSuiteVersao;
    private ContatoButton btnAtualizarConfVersaoSel;
    private ContatoButton btnCarregar;
    private ContatoButton btnEnviarAlteracoes;
    private ContatoPanel contatoPanel1;
    private ContatoPanel contatoPanel2;
    private ContatoPanel contatoPanel3;
    private ContatoSplitPane contatoSplitPane1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private ContatoTable tblItens;
    private ContatoTable tblVersoes;

    public TouchArquivoConfVersoesFrame() {
        this.initComponents();
        this.initTable();
    }

    private void initTable() {
        this.tblVersoes.setModel((TableModel)((Object)new DTOSuiteVersaoTableModel(null)));
        this.tblVersoes.setColumnModel((TableColumnModel)((Object)new DTOSuiteVersaoColumnModel()));
        this.tblVersoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DTOSuiteUpdate.DTOVersao ver = (DTOSuiteUpdate.DTOVersao)TouchArquivoConfVersoesFrame.this.tblVersoes.getSelectedObject();
                TouchArquivoConfVersoesFrame.this.tblItens.clear();
                if (ver != null) {
                    TouchArquivoConfVersoesFrame.this.tblItens.addRows(ver.getItem(), false);
                }
            }
        });
        this.tblItens.setModel((TableModel)((Object)new DTOSuiteVersaoItemTableModel(null)));
        this.tblItens.setColumnModel((TableColumnModel)((Object)new DTOSuiteVersaoItemColumnModel()));
    }

    private void initComponents() {
        this.contatoSplitPane1 = new ContatoSplitPane();
        this.contatoPanel1 = new ContatoPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblVersoes = new ContatoTable();
        this.contatoPanel2 = new ContatoPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tblItens = new ContatoTable();
        this.contatoPanel3 = new ContatoPanel();
        this.btnCarregar = new ContatoButton();
        this.btnAtualizarConfVersaoSel = new ContatoButton();
        this.btnEnviarAlteracoes = new ContatoButton();
        this.setLayout(new GridBagLayout());
        this.contatoSplitPane1.setDividerLocation(350);
        this.tblVersoes.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this.tblVersoes);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.contatoPanel1.add((Component)this.jScrollPane1, (Object)gridBagConstraints);
        this.contatoSplitPane1.setLeftComponent((Component)this.contatoPanel1);
        this.tblItens.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView((Component)this.tblItens);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.contatoPanel2.add((Component)this.jScrollPane2, (Object)gridBagConstraints);
        this.contatoSplitPane1.setRightComponent((Component)this.contatoPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.2;
        this.add((Component)this.contatoSplitPane1, gridBagConstraints);
        this.btnCarregar.setText("Carregar");
        this.btnCarregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TouchArquivoConfVersoesFrame.this.btnCarregarActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 4, 5, 0);
        this.contatoPanel3.add((Component)this.btnCarregar, (Object)gridBagConstraints);
        this.btnAtualizarConfVersaoSel.setText("Atualizar Conf. Vers\u00e3o Sel");
        this.btnAtualizarConfVersaoSel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TouchArquivoConfVersoesFrame.this.btnAtualizarConfVersaoSelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 4, 5, 0);
        this.contatoPanel3.add((Component)this.btnAtualizarConfVersaoSel, (Object)gridBagConstraints);
        this.btnEnviarAlteracoes.setText("Salvar/Enviar");
        this.btnEnviarAlteracoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TouchArquivoConfVersoesFrame.this.btnEnviarAlteracoesActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 4, 5, 0);
        this.contatoPanel3.add((Component)this.btnEnviarAlteracoes, (Object)gridBagConstraints);
        this.add((Component)this.contatoPanel3, new GridBagConstraints());
    }

    private void btnCarregarActionPerformed(ActionEvent evt) {
        this.btnCarregarActionPerformed();
    }

    private void btnEnviarAlteracoesActionPerformed(ActionEvent evt) {
        this.btnEnviarAlteracoesActionPerformed();
    }

    private void btnAtualizarConfVersaoSelActionPerformed(ActionEvent evt) {
        this.btnAtualizarConfVersaoSelActionPerformed();
    }

    private void btnCarregarActionPerformed() {
        try {
            ServidorFTP sel = this.getServidorFTP();
            if (sel == null) {
                return;
            }
            DTOSuiteUpdate su = new UtilSuiteVersao().getConfiguracoes(sel);
            this.tblVersoes.addRows(su.getVersao(), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            ContatoDialogsHelper.showError((String)("Erro ao buscar os dados " + ex.getMessage()));
        }
    }

    private void btnEnviarAlteracoesActionPerformed() {
        try {
            int op = ContatoDialogsHelper.showQuestion((String)"Deseja realmente salvar as altera\u00e7\u00f5es?");
            if (op != 0) {
                return;
            }
            ServidorFTP sel = this.getServidorFTP();
            if (sel == null) {
                ContatoDialogsHelper.showInfo((String)"Cadastre os servidores de FTP.");
                return;
            }
            DTOSuiteUpdate su = new UtilSuiteVersao().getConfiguracoes(sel);
            su.getVersao().clear();
            su.setVersao(this.tblVersoes.getObjects());
            new UtilSuiteVersao().enviarArquivoConfiguracao(sel, su);
            ContatoDialogsHelper.showInfo((String)"Arquivo enviado.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            ContatoDialogsHelper.showError((String)("Erro ao buscar/enviar os dados " + ex.getMessage()));
        }
    }

    private ServidorFTP getServidorFTP() {
        List<ServidorFTP> server = Main.getBean(ServiceServidorFTPImpl.class).getServidoresFTP();
        ServidorFTP sel = null;
        if (server.size() > 1) {
            sel = (ServidorFTP)ContatoDialogsHelper.showInputDialog((String)"Selecione um servidor", null, (Object[])server.toArray());
        } else if (server.size() == 1) {
            sel = server.get(0);
        }
        return sel;
    }

    public AuxSuiteVersao getAuxSuiteVersao() {
        return this.auxSuiteVersao;
    }

    public void setAuxSuiteVersao(AuxSuiteVersao auxSuiteVersao) {
        this.auxSuiteVersao = auxSuiteVersao;
    }

    private void btnAtualizarConfVersaoSelActionPerformed() {
        if (this.auxSuiteVersao == null) {
            JOptionPane.showMessageDialog(null, "Selecione uma versao");
            return;
        }
        if (this.tblVersoes.getObjects().isEmpty()) {
            JOptionPane.showMessageDialog(null, "Carregue os dados do arquivo");
            return;
        }
        VersaoMentor versaoMentor = this.auxSuiteVersao.getSuiteVersao().getVersaoMentor();
        List versoes = this.tblVersoes.getObjects();
        Optional<DTOSuiteUpdate.DTOVersao> found = versoes.stream().filter(i -> i.getCodigo().equals(versaoMentor.getCodigo())).findFirst();
        if (!found.isPresent()) {
            JOptionPane.showMessageDialog(null, "A vers\u00e3o selecionada n\u00e3o existe no arquivo (Ela foi enviada?):" + String.valueOf(versaoMentor));
            return;
        }
        DTOSuiteUpdate.DTOVersao ver = found.get();
        ver.setLiberada(versaoMentor.getLiberarVersao());
        ver.setMaturidade(versaoMentor.getMaturidade());
        ver.setVersaoPatch(versaoMentor.getVersaoPatch());
        for (DTOSuiteUpdate.DTOVersaoItem item : ver.getItem()) {
            Optional<VersaoMentorSistema> foundIt = versaoMentor.getSistemasVersao().stream().filter(i -> i.getTipoBDVersao().getCodigoSistema().equals(item.getCodigoAplicacao())).findFirst();
            if (!foundIt.isPresent()) continue;
            item.setUrlArquivoModificacoes(foundIt.get().getUrlModificacoes());
        }
        JOptionPane.showMessageDialog(null, "Dados atualizados. Se ok, salve o arquivo para atualizar no servidor FTP.");
        this.tblVersoes.repaint();
        this.tblItens.repaint();
    }
}

