/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.suiteversao.auxiliar;

import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.VersaoMentor;
import contatocore.util.ZipUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class UtilVersao {
    private static final String ENTRY_NAME_APLICACAO = "aplicacao.zip";
    private static final String ENTRY_NAME_SERVIDOR = "servidor.zip";
    private static final String ENTRY_NAME_F_PROPERTIES = "update.properties";

    private File createFProperty(File fBD, File fSys, SuiteVersaoItem q, VersaoMentor versao) throws Exception {
        File f = new File(ENTRY_NAME_F_PROPERTIES);
        f.delete();
        Properties props = new Properties();
        if (fBD != null) {
            props.setProperty("arquivo_servidor", fBD.getName());
        }
        if (fSys != null) {
            props.setProperty("arquivo_aplicacao", fSys.getName());
        }
        props.setProperty("descricao", versao.getDescricao());
        props.setProperty("versao", versao.getCodigo().toString());
        if (versao.getVersaoAnterior() != null && versao.getVersaoAnterior().getCodigo() != null) {
            props.setProperty("versaoMinimo", versao.getVersaoAnterior().getCodigo().toString());
        } else {
            props.setProperty("versaoMinimo", "0");
        }
        props.setProperty("codigoAplicacao", q.getTipoBDVersao().getCodigoSistema().toString());
        props.setProperty("tipo", q.getTipoBDVersao().getTipo().toString());
        if (q.getUrlModificacoes() != null) {
            props.setProperty("urlModificacoes", q.getUrlModificacoes());
        }
        props.store(new FileOutputStream(f), "Configuracoes de atualizador");
        return f;
    }

    public File createZipFile(File fileBD, File fSys, VersaoMentor versao, SuiteVersaoItem q) throws Exception {
        if (fileBD == null && fSys == null) {
            throw new Exception("Deve possuir um arquivo local, ou do servidor para gerar o arquivo.");
        }
        File fproperties = this.createFProperty(fileBD, fSys, q, versao);
        String parent = fileBD != null ? fileBD.getParentFile().getAbsolutePath() : fSys.getParentFile().getAbsolutePath();
        File fServer = new File(parent + "/" + versao.getCodigo() + "-" + q.getTipoBDVersao().getCodigoSistema() + ".zip");
        fServer.delete();
        FileOutputStream fout = new FileOutputStream(fServer);
        ZipOutputStream zos = new ZipUtils().criarZip((OutputStream)fout);
        if (fileBD != null) {
            this.addFileToZip(zos, fileBD, fileBD.getName());
            fileBD.delete();
            fileBD.deleteOnExit();
        }
        if (fSys != null) {
            this.addFileToZip(zos, fSys, fSys.getName());
            fSys.delete();
            fSys.deleteOnExit();
        }
        this.addFileToZip(zos, fproperties, ENTRY_NAME_F_PROPERTIES);
        zos.finish();
        fout.flush();
        fout.close();
        fproperties.delete();
        fproperties.deleteOnExit();
        return fServer;
    }

    private void addFileToZip(ZipOutputStream zos, File arquivo, String entradaZip) throws IOException {
        if ((entradaZip = entradaZip.replaceAll("\\\\", "/")).startsWith("\\") || entradaZip.startsWith("/")) {
            entradaZip = entradaZip.substring(1);
        }
        byte[] buffer = new byte[4096];
        ZipEntry entrada = new ZipEntry(entradaZip);
        zos.putNextEntry(entrada);
        zos.setMethod(8);
        FileInputStream fis = new FileInputStream(arquivo);
        BufferedInputStream bis = new BufferedInputStream(fis, 2048);
        int bytesLidos = 0;
        while ((bytesLidos = bis.read(buffer, 0, 2048)) != -1) {
            zos.write(buffer, 0, bytesLidos);
        }
        zos.closeEntry();
    }
}

