/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.suiteversao.util;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoUpateAPP;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.ftp.ToolFTP;
import com.touchcomp.basementortools.tools.jaxb.ToolJaxb;
import com.touchcomp.basementortools.tools.md5.ToolMD5;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.model.ServidorFTP;
import com.touchcomp.touchversoes.model.SuiteVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.model.VersaoMentorSistema;
import com.touchcomp.touchvomodel.temp.DTOSuiteUpdate;
import contato.dialog.ContatoDialogsHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class UtilSuiteVersao {
    TLogger logger = TLogger.get(this.getClass());

    public SuiteVersao enviarAtualizarArquivoConfig(SuiteVersao suite, List<SuiteVersaoItem> itens, boolean uparArquivos, List<TipoBDVersao> todos) throws Exception {
        this.validaExistenciaArquivos(itens);
        if (uparArquivos) {
            this.enviaArquivos(itens);
        }
        return this.atualizaArquivo(suite, itens, todos);
    }

    private DTOSuiteUpdate.DTOVersao getVersao(DTOSuiteUpdate configuracao, SuiteVersao suite) {
        DTOSuiteUpdate.DTOVersao versao;
        Optional<DTOSuiteUpdate.DTOVersao> found = configuracao.getVersao().stream().filter(i -> ToolMethods.isEquals((Object)i.getCodigo(), (Object)suite.getVersaoMentor().getCodigo())).findFirst();
        if (found.isPresent()) {
            versao = found.get();
        } else {
            versao = new DTOSuiteUpdate.DTOVersao();
            configuracao.getVersao().add(versao);
        }
        versao.setCodigo(suite.getVersaoMentor().getCodigo());
        versao.setMaturidade(suite.getMaturidade());
        versao.setLiberada(suite.getLiberarVersao());
        versao.setDescricao(suite.getVersaoMentor().getDescricao());
        versao.setVersaoAtualizador(suite.getVersaoAtualizador());
        versao.setVersaoPatch(suite.getVersaoMentor().getVersaoPatch());
        return versao;
    }

    private void addItensVersao(DTOSuiteUpdate.DTOVersao versao, SuiteVersao suite, List<TipoBDVersao> todos, List<SuiteVersaoItem> itens) throws Exception {
        for (TipoBDVersao tipo : todos) {
            this.addItemNaoExiste(tipo, versao, suite);
        }
        for (SuiteVersaoItem item : itens) {
            this.addItem(item.getTipoBDVersao(), versao, suite, item.getUrl(), item.getUrlModificacoes(), item.getTamanhoArquivo());
        }
    }

    private void addItemNaoExiste(TipoBDVersao tipo, DTOSuiteUpdate.DTOVersao versao, SuiteVersao suite) throws Exception {
        Optional<DTOSuiteUpdate.DTOVersaoItem> found = versao.getItem().stream().filter(i -> ToolMethods.isEquals((Object)i.getCodigoAplicacao(), (Object)tipo.getCodigoSistema())).findFirst();
        if (found.isPresent()) {
            return;
        }
        DTOSuiteUpdate.DTOVersaoItem itemVersao = new DTOSuiteUpdate.DTOVersaoItem();
        versao.getItem().add(itemVersao);
        itemVersao.setTipoAplicacao(tipo.getTipo());
        itemVersao.setCodigoAplicacao(tipo.getCodigoSistema());
        itemVersao.setUpdate(Short.valueOf(EnumConstTipoUpateAPP.SEM_ATUALIZACAO.getValue()));
        itemVersao.setCodigoVersao(versao.getCodigo());
        itemVersao.setTamanhoArquivo(Long.valueOf(0L));
        itemVersao.setHash(this.getHashCode(suite.getVersaoMentor().getCodigo(), tipo.getCodigoSistema()));
        itemVersao.setDescricao(tipo.getDescricao());
        if (itemVersao.getUrlArquivo() != null) {
            itemVersao.setUrlArquivo(itemVersao.getUrlArquivo().replaceAll("/www/", "/"));
        }
        String urlMod = this.getURLModificacoes1(suite.getVersaoMentor(), itemVersao);
        itemVersao.setUrlArquivoModificacoes(urlMod);
    }

    private void addItem(TipoBDVersao tipo, DTOSuiteUpdate.DTOVersao versao, SuiteVersao suite, String url, String urlModificacoes, Long tamanhoArquivo) throws Exception {
        DTOSuiteUpdate.DTOVersaoItem itemVersao;
        Optional<DTOSuiteUpdate.DTOVersaoItem> found = versao.getItem().stream().filter(i -> ToolMethods.isEquals((Object)i.getCodigoAplicacao(), (Object)tipo.getCodigoSistema())).findFirst();
        if (found.isPresent()) {
            itemVersao = found.get();
        } else {
            itemVersao = new DTOSuiteUpdate.DTOVersaoItem();
            versao.getItem().add(itemVersao);
        }
        itemVersao.setTipoAplicacao(tipo.getTipo());
        itemVersao.setCodigoAplicacao(tipo.getCodigoSistema());
        if (TMethods.isStrWithData((String)url)) {
            itemVersao.setUpdate(Short.valueOf(EnumConstTipoUpateAPP.get((Object)tipo.getTipoUpdate()).getValue()));
        } else {
            itemVersao.setUpdate(Short.valueOf(EnumConstTipoUpateAPP.SEM_ATUALIZACAO.getValue()));
        }
        itemVersao.setCodigoVersao(versao.getCodigo());
        itemVersao.setTamanhoArquivo(Long.valueOf(tamanhoArquivo == null ? 0L : tamanhoArquivo));
        itemVersao.setUrlArquivo(url);
        itemVersao.setUrlArquivoModificacoes(urlModificacoes);
        itemVersao.setHash(this.getHashCode(suite.getVersaoMentor().getCodigo(), tipo.getCodigoSistema()));
        itemVersao.setDescricao(tipo.getDescricao());
        if (itemVersao.getUrlArquivo() != null) {
            itemVersao.setUrlArquivo(itemVersao.getUrlArquivo().replaceAll("/www/", "/"));
        }
        String urlMod = this.getURLModificacoes1(suite.getVersaoMentor(), itemVersao);
        itemVersao.setUrlArquivoModificacoes(urlMod);
    }

    private void validaExistenciaArquivos(List<SuiteVersaoItem> itens) throws Exception {
        for (SuiteVersaoItem item : itens) {
            this.validaExistenciaArquivos(item);
        }
    }

    private void validaExistenciaArquivos(SuiteVersaoItem item) throws Exception {
        File f;
        if (item.getArquivo() != null && item.getArquivo().trim().length() > 0 && (!(f = new File(item.getArquivo())).exists() || f.isDirectory())) {
            throw new Exception("Erro ao localizar o arquivo " + f.getAbsolutePath() + ". O mesmo n\u00e3o existe ou \u00e9 inv\u00e1lido.");
        }
    }

    private void enviaArquivos(List<SuiteVersaoItem> itens) throws Exception {
        try {
            for (SuiteVersaoItem item : itens) {
                this.enviaItem(item);
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new Exception("Erro ao upar o arquivo.\n" + ex.getMessage());
        }
    }

    private File downloadArquivo(ServidorFTP server) throws IOException, ExceptionIO {
        File tmp = File.createTempFile("mentor_suite_update", ".xml");
        ToolFTP.getFileFTP((String)server.getEndereco(), (String)server.getCaminhoBaseFtp(), (String)"/mentor/suite_update/", (String)"mentor_suite_versao.xml", (File)tmp, (String)server.getUsuario(), (String)server.getSenha());
        return tmp;
    }

    private String getHashCode(Long codigo, Short tipo) throws Exception {
        String sout = ToolMD5.md5((String)(codigo + "_" + tipo));
        System.out.println(sout);
        return sout;
    }

    public void validaArquivoVersao(SuiteVersao suite) throws Exception {
        File arquivoConf = this.downloadArquivo(suite.getServidorFTP());
        DTOSuiteUpdate configuracao = (DTOSuiteUpdate)ToolJaxb.toObject((String)ToolFile.getConteudoArquivo((File)arquivoConf), DTOSuiteUpdate.class);
        Collections.sort(configuracao.getVersao(), (v1, v2) -> v1.getCodigo().compareTo(v2.getCodigo()));
        Long codigo = 0L;
        for (DTOSuiteUpdate.DTOVersao dto : configuracao.getVersao()) {
            if (!ToolMethods.isAffirmative((Number)dto.getLiberada())) {
                codigo = dto.getCodigo();
            }
            if (!ToolMethods.isAffirmative((Number)dto.getLiberada()) || codigo <= 0L || codigo <= dto.getCodigo()) continue;
            throw new Exception("Existe um conflito de vers\u00f5es, onde existem vers\u00f5es posteriores liberadas e anteriores bloqueadas: Vers\u00e3o bloqueada: " + codigo + " Vers\u00e3o Liberada: " + dto.getCodigo());
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (DTOSuiteUpdate.DTOVersao dto : configuracao.getVersao()) {
            for (DTOSuiteUpdate.DTOVersaoItem item : dto.getItem()) {
                if (counter.containsKey(item.getHash())) {
                    throw new Exception("Existe um conflito de vers\u00f5es, onde mais de uma versao possui codigo hash. Isso provavelmente foi \"Copiar e colar\" diretamente no arquivo de configuracoes. (suite_update.xml) Hash:" + item.getHash());
                }
                counter.put(item.getHash(), 1);
            }
        }
    }

    public DTOSuiteUpdate getConfiguracoes(ServidorFTP server) throws Exception {
        File arquivoConf = this.downloadArquivo(server);
        DTOSuiteUpdate configuracao = (DTOSuiteUpdate)ToolJaxb.toObject((String)ToolFile.getConteudoArquivo((File)arquivoConf), DTOSuiteUpdate.class);
        return configuracao;
    }

    private SuiteVersao atualizaArquivo(SuiteVersao suite, List<SuiteVersaoItem> itens, List<TipoBDVersao> todos) throws Exception {
        File arquivoConf = this.downloadArquivo(suite.getServidorFTP());
        DTOSuiteUpdate configuracao = (DTOSuiteUpdate)ToolJaxb.toObject((String)ToolFile.getConteudoArquivo((File)arquivoConf), DTOSuiteUpdate.class);
        DTOSuiteUpdate.DTOVersao versao = this.getVersao(configuracao, suite);
        this.addItensVersao(versao, suite, todos, itens);
        this.validaArquivoVersao(suite);
        this.enviarArquivoConfiguracao(arquivoConf, suite.getServidorFTP(), configuracao);
        return suite;
    }

    private void enviaItem(SuiteVersaoItem item) throws Exception {
        String basePath = "/mentor/suite_update/updates/" + item.getSuiteVersao().getVersaoMentor().getCodigo() + "/";
        if (item.getArquivo() != null && item.getArquivo().trim().length() > 0) {
            File temp = new File(item.getArquivo());
            String name = "arquivo_atualizacao_" + item.getTipoBDVersao().getCodigoSistema();
            temp = ToolFile.renameFileName((File)temp, (String)name, (boolean)true);
            System.out.println("Enviando arquivo para nuvem " + String.valueOf(item.getTipoBDVersao()) + ", tamanho: " + temp.length() / 1024L);
            this.enviarFTP(basePath, item, temp);
            item.setUrl("https://www.toucherp.com.br" + basePath + temp.getName());
            System.out.println("Arquivo enviado " + temp.getAbsolutePath());
        }
    }

    public void checkGitBranch(DTOConfiguracoes conf, VersaoMentor ver) throws Exception {
        try {
            String line;
            if (!ToolMethods.isStrWithData((String)ver.getNomeBranch())) {
                throw new Exception("A branch nao foi informada no sistema: " + String.valueOf(ver));
            }
            File dirProjects = new File(conf.getLocalProjetoBase());
            String cmd = "git branch --show-current";
            ProcessBuilder pb = new ProcessBuilder("cmd.exe", "/C", cmd);
            pb.directory(dirProjects);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader stdin = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder commandOutput = new StringBuilder();
            while ((line = stdin.readLine()) != null) {
                commandOutput.append(line);
            }
            int exitValue = -1;
            try {
                exitValue = p.waitFor();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                TLogger.get(this.getClass()).error((Throwable)ex);
                throw new Exception("Erro ao recuperar o nome da branch");
            }
            if (exitValue != 0) {
                throw new Exception("Erro ao recuperar o nome da branch");
            }
            if (!(commandOutput.length() != 0 && commandOutput.toString().contains(ver.getNomeBranch()) || commandOutput.toString().isEmpty())) {
                throw new Exception("A branch dos projetos esta diferente do especificado na versao, branch versao: " + String.valueOf(commandOutput) + ", branch versao informado no sistema: " + ver.getNomeBranch());
            }
            if (commandOutput.toString().isEmpty()) {
                ContatoDialogsHelper.showInfo((String)"A branch utilizada n\u00e3o est\u00e1 ligada a um branch remota. Tenha cuidado ao subir vers\u00f5es com branchs 'detached'");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new Exception("Erro ao recuperar o nome da branch");
        }
    }

    void enviarFTP(String basePath, SuiteVersaoItem item, File temp) throws ExceptionIO {
        ToolFTP.useFTP((String)item.getSuiteVersao().getServidorFTP().getEndereco(), (String)item.getSuiteVersao().getServidorFTP().getCaminhoBaseFtp(), (String)basePath, (String)temp.getName(), (File)temp, (String)item.getSuiteVersao().getServidorFTP().getUsuario(), (String)item.getSuiteVersao().getServidorFTP().getSenha());
    }

    public void enviarArquivoConfiguracao(ServidorFTP sel, DTOSuiteUpdate configuracao) throws Exception {
        File arquivoConf = this.downloadArquivo(sel);
        this.enviarArquivoConfiguracao(arquivoConf, sel, configuracao);
    }

    void enviarArquivoConfiguracao(File arquivoConf, ServidorFTP sel, DTOSuiteUpdate configuracao) throws Exception {
        ToolFile.writeBytesOnFile((File)arquivoConf, (byte[])ToolJaxb.toXMl((Object)configuracao, (boolean)true).getBytes());
        System.out.println(arquivoConf);
        ToolFTP.useFTP((String)sel.getEndereco(), (String)sel.getCaminhoBaseFtp(), (String)"/mentor/suite_update/", (String)"mentor_suite_versao.xml", (File)arquivoConf, (String)sel.getUsuario(), (String)sel.getSenha());
    }

    private String getURLModificacoes1(VersaoMentor versao, DTOSuiteUpdate.DTOVersaoItem itemVersao) {
        Optional<VersaoMentorSistema> found = versao.getSistemasVersao().stream().filter(i -> TMethods.isEquals((Object)i.getTipoBDVersao().getCodigoSistema(), (Object)itemVersao.getCodigoAplicacao())).findFirst();
        if (found.isPresent()) {
            return found.get().getUrlModificacoes();
        }
        return null;
    }
}

