/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.testsquality;

import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchversoes.Main;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.MainFrame;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.Nodo;
import com.touchcomp.touchversoes.model.SuiteVersao;
import com.touchcomp.touchversoes.service.nodo.ServiceNodoImpl;
import com.touchcomp.touchversoes.service.searchclass.ServiceSearchClassImpl;
import java.io.File;
import java.util.Date;
import java.util.List;

public class AuxFrontEndTests {
    final DTOConfiguracoes configuracoes;
    final SuiteVersao suiteVersao;
    final ProgressCurrentTask currentTask;

    public AuxFrontEndTests(DTOConfiguracoes configuracoes, SuiteVersao suiteVersao, ProgressCurrentTask currentTask, MainFrame.StagioController stagio) {
        this.configuracoes = configuracoes;
        this.suiteVersao = suiteVersao;
        this.currentTask = currentTask;
    }

    public void iniciarTestesQualidade() throws Exception {
        System.out.println("Iniciando testes de qualidade, sobre nodos");
        ServiceNodoImpl serviceNodo = Main.getBean(ServiceNodoImpl.class);
        ServiceSearchClassImpl serviceSearch = Main.getBean(ServiceSearchClassImpl.class);
        List<Nodo> nodosWEB = serviceNodo.getNodosWEBAll();
        Object urlFileMapping = this.configuracoes.getLocalProjetoBase();
        urlFileMapping = (String)urlFileMapping + "\\web\\touchwebfrontent\\frontend\\src\\util\\enums\\url.js";
        StringBuilder errors = new StringBuilder();
        File f = new File((String)urlFileMapping);
        String fileContent = ToolFile.getConteudoArquivo((File)f);
        for (Nodo nodo : nodosWEB) {
            System.out.println("\t* " + String.valueOf(nodo));
            this.checkErrors(nodo, errors, fileContent, serviceSearch, this.suiteVersao.getVersaoMentor().getDataFinal());
        }
        System.out.println(errors);
        System.out.println("\n\nFinalziado testes nodos\n\n");
        if (TMethods.isStrWithData((String)errors.toString())) {
            throw new Exception("Ocorreram erros sobre os recursos do sistema que devem ser corridos antes de continuar. Verifique o log da aplicacao.");
        }
    }

    private void checkErrors(Nodo nodo, StringBuilder errors, String fileContent, ServiceSearchClassImpl serviceSearch, Date dataFimVersao) {
        if (nodo.getDataLiberacaoWeb().after(dataFimVersao)) {
            return;
        }
        Object url = nodo.getPathWeb();
        if (!((String)url).startsWith("/")) {
            url = "/" + (String)url;
        }
        if (fileContent.contains((CharSequence)(url = "/touch-web" + (String)url))) {
            return;
        }
        if (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).lastIndexOf("/"));
        }
        if (fileContent.contains((CharSequence)url)) {
            return;
        }
        errors.append("Path WEB nao encontrado no Front: ").append((String)url).append(", recurso: ").append(nodo).append("\n");
    }
}

