/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.testsquality;

import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchversoes.Main;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.MainFrame;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.Nodo;
import com.touchcomp.touchversoes.model.SearchClass;
import com.touchcomp.touchversoes.model.SearchClassField;
import com.touchcomp.touchversoes.model.SearchClassFieldResItem;
import com.touchcomp.touchversoes.model.SuiteVersao;
import com.touchcomp.touchversoes.service.nodo.ServiceNodoImpl;
import com.touchcomp.touchversoes.service.searchclass.ServiceSearchClassImpl;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class AuxNodoSearchTests {
    final DTOConfiguracoes configuracoes;
    final SuiteVersao suiteVersao;
    final ProgressCurrentTask currentTask;

    public AuxNodoSearchTests(DTOConfiguracoes configuracoes, SuiteVersao suiteVersao, ProgressCurrentTask currentTask, MainFrame.StagioController stagio) {
        this.configuracoes = configuracoes;
        this.suiteVersao = suiteVersao;
        this.currentTask = currentTask;
    }

    public void iniciarTestesQualidade() throws Exception {
        System.out.println("Iniciando testes de qualidade, sobre nodos(Dados Pesquisa)");
        ServiceNodoImpl serviceNodo = Main.getBean(ServiceNodoImpl.class);
        ServiceSearchClassImpl serviceSearch = Main.getBean(ServiceSearchClassImpl.class);
        List<Nodo> nodosWEB = serviceNodo.getNodosWEBCrud();
        Object baseProjectVO = this.configuracoes.getLocalProjetoBase();
        baseProjectVO = (String)baseProjectVO + "\\web\\basementor\\src\\main\\java\\com\\touchcomp\\basementor\\model\\vo\\";
        StringBuilder errors = new StringBuilder();
        for (Nodo nodo : nodosWEB) {
            System.out.println("\t* " + String.valueOf(nodo));
            this.checkErrors(nodo, errors, (String)baseProjectVO, serviceSearch, this.suiteVersao.getVersaoMentor().getDataFinal());
        }
        System.out.println(errors);
        System.out.println("Finalizado testes de qualidade, sobre nodos");
        if (TMethods.isStrWithData((String)errors.toString())) {
            throw new Exception("Ocorreram erros sobre os recursos do sistema que devem ser corridos antes de continuar. Verifique o log da aplicacao.");
        }
    }

    private void checkErrors(Nodo nodo, StringBuilder errors, String baseProjectVO, ServiceSearchClassImpl serviceSearch, Date dataFimVersao) {
        String voClass;
        SearchClass search;
        if (nodo.getDataLiberacaoWeb() != null && !TMethods.isStrWithData((String)nodo.getPathWeb())) {
            errors.append("Nodo esta liberado para web(Com data de liberacao), mas nao foi informado o path web: ").append(nodo).append("\n");
        }
        if (nodo.getDataLiberacaoWeb() == null) {
            return;
        }
        if (nodo.getDataLiberacaoWeb().after(dataFimVersao)) {
            return;
        }
        if (!TMethods.isStrWithData((String)nodo.getVoClasses())) {
            return;
        }
        File vo = new File(baseProjectVO + nodo.getVoClasses() + ".java");
        if (!vo.exists()) {
            errors.append("Classe VO informada no nodo nao existe, nodo: ").append(nodo).append(" classe: ").append(vo.getAbsolutePath()).append("\n");
        }
        if ((search = serviceSearch.getSearchClass(voClass = "com.touchcomp.basementor.model.vo." + nodo.getVoClasses())) == null) {
            errors.append("Pesquisa nao definida para a entidade e esta esta vinculada a um recurso web: ").append(voClass).append("\n");
            return;
        }
        LinkedList<Object> itensAtivos = new LinkedList<Object>();
        for (SearchClassField searchClassField : search.getSearchFields()) {
            if (searchClassField == null) {
                errors.append("Indice de campos de pesquisa invalidos. Verifique o indice dos campos e pesquisa.").append(voClass).append("\n");
                return;
            }
            itensAtivos.add(searchClassField);
        }
        if (!TMethods.isWithData(itensAtivos)) {
            errors.append("Campos de pesquisa nao definida para a entidade e esta esta vinculada a um recurso web(Verifique se os itens estao ativos): ").append(voClass).append("\n");
        }
        if (search.getSearchFieldsRes() == null || !TMethods.isStrWithData((String)search.getSearchFieldsRes().getMascara())) {
            errors.append("Pesquisa Resumida nao definida para a entidade e esta esta vinculada a um recurso web: ").append(voClass).append("\n");
            return;
        }
        for (SearchClassFieldResItem searchClassFieldResItem : search.getSearchFieldsRes().getFields()) {
            if (searchClassFieldResItem == null) {
                errors.append("Indice de campos de pesquisa invalidos. Verifique o indice dos campos e pesquisa.").append(voClass).append("\n");
                return;
            }
            itensAtivos.add(searchClassFieldResItem);
        }
        if (!TMethods.isWithData(itensAtivos)) {
            errors.append("Campos de pesquisa resumida nao definidos para a entidade e esta esta vinculada a um recurso web(Verifique se os itens estao ativos): ").append(voClass).append("\n");
        }
    }
}

