/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.gui.testsquality;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.gui.instaladores.AuxCopyInstaladores;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuxTestWeb
extends CommandBaseProgress {
    private DTOConfiguracoes configuracoes;
    private ProgressCurrentTask currentTask;
    private AuxSuiteVersao suiteVersao;

    public AuxTestWeb(DTOConfiguracoes configuracoes, ProgressCurrentTask currentTask, AuxSuiteVersao suiteVersao) {
        super(currentTask);
        this.configuracoes = configuracoes;
        this.currentTask = currentTask;
        this.suiteVersao = suiteVersao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWeb(List<SuiteVersaoItem> itens) throws Exception {
        File wild = new File(ToolFile.getUserDir() + "/wildfly");
        if (!wild.exists()) {
            throw new Exception("Local do Wildfly nao existe.");
        }
        File stand = new File(wild.getAbsolutePath() + File.separator + "bin" + File.separator + "standalone.bat");
        File deploys = new File(wild.getAbsolutePath() + File.separator + "standalone" + File.separator + "deployments");
        ToolFile.removeFiles((File)deploys);
        deploys.mkdirs();
        List<File> files = this.copyWars(itens, deploys);
        DTOCommand cmd = new DTOCommand("cmd /c start powershell.exe -NoExit " + stand.getAbsolutePath(), stand.getParentFile(), "Testando Wildfly");
        Process process = this.getProcess(cmd);
        try {
            this.execProcess(process);
            System.out.println("Esperando deploy de aplicativos wildfly.");
            this.waitItDeploy(files, process);
        }
        finally {
            process.destroy();
        }
    }

    private List<File> copyWars(List<SuiteVersaoItem> itens, File deploys) throws Exception {
        LinkedList<File> aux = new LinkedList<File>();
        for (SuiteVersaoItem item : itens) {
            EnumConstTipoSistemasTouch tipo = EnumConstTipoSistemasTouch.get((Object)item.getTipoBDVersao().getCodigoSistema());
            if (!tipo.isWeb(tipo)) continue;
            aux.add(new AuxCopyInstaladores(this.configuracoes, this.suiteVersao, this.currentTask).copyWars(item, deploys));
        }
        return aux;
    }

    private void waitItDeploy(List<File> files, Process process) throws Exception {
        boolean all;
        long time = 0L;
        do {
            all = true;
            for (File file : files) {
                boolean bl = all = all && this.isDeployed(file);
                if (!this.isFailed(file)) continue;
                throw new Exception("Arquivo WEB falhou ao realizar deploy. Verifique-o " + file.getAbsolutePath());
            }
            Thread.sleep(1000L);
            if ((time += 1000L) <= 900000L) continue;
            throw new Exception("Wildfly nao subiu corretamente. Verifique-o.");
        } while (!all);
    }

    private boolean isDeployed(File file) {
        String dir = file.getParent();
        String name = file.getName();
        File dep = new File(dir + File.separator + name + ".deployed");
        return dep.exists();
    }

    private boolean isFailed(File file) {
        String dir = file.getParent();
        String name = file.getName();
        name = name.substring(0, name.lastIndexOf("."));
        File dep = new File(dir + name + ".failed");
        return dep.exists();
    }

    private void execProcess(final Process process) {
        new Thread(this){

            @Override
            public void run() {
                try {
                    process.waitFor();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                    Logger.getLogger(AuxTestWeb.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }.start();
    }
}

