/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.model;

import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchversoes.model.VersaoMentorSistema;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="VERSAO_MENTOR")
public class VersaoMentor {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Short ativo = 1;
    private Timestamp dataAtualizacao;
    private Long codigo = 0L;
    private VersaoMentor versaoAnterior;
    private Date dataInicial;
    private Date dataFinal;
    private Date dataInicialDesenvolvimento;
    private Date dataFinalDesenvolvimento;
    private Short versaoFechada = 0;
    private Short versaoPatch = 0;
    private String nomeBranch;
    private List<VersaoMentorSistema> sistemasVersao = new LinkedList<VersaoMentorSistema>();
    private Short maturidade;
    private Short liberarVersao;
    private Short versaoAtualizador = 11;

    @Id
    @Column(nullable=false, name="ID_VERSAO_MENTOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_VERSAO_MENTOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="CODIGO")
    public Long getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @JoinColumn(name="ID_VERSAO_ANTERIOR", foreignKey=@ForeignKey(name="FK_VERSAO_MENTOR_VER_MENTOR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public VersaoMentor getVersaoAnterior() {
        return this.versaoAnterior;
    }

    public void setVersaoAnterior(VersaoMentor versaoAnterior) {
        this.versaoAnterior = versaoAnterior;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="VERSAO_FECHADA")
    public Short getVersaoFechada() {
        return this.versaoFechada;
    }

    public void setVersaoFechada(Short versaoFechada) {
        this.versaoFechada = versaoFechada;
    }

    @Column(name="VERSAO_PATCH")
    public Short getVersaoPatch() {
        return this.versaoPatch;
    }

    public void setVersaoPatch(Short versaoPatch) {
        this.versaoPatch = versaoPatch;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INICIAL_DESENVOLVIMENTO")
    public Date getDataInicialDesenvolvimento() {
        return this.dataInicialDesenvolvimento;
    }

    public void setDataInicialDesenvolvimento(Date dataInicialDesenvolvimento) {
        this.dataInicialDesenvolvimento = dataInicialDesenvolvimento;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINAL_DESENVOLVIMENTO")
    public Date getDataFinalDesenvolvimento() {
        return this.dataFinalDesenvolvimento;
    }

    public void setDataFinalDesenvolvimento(Date dataFinalDesenvolvimento) {
        this.dataFinalDesenvolvimento = dataFinalDesenvolvimento;
    }

    @OneToMany(mappedBy="versaoMentor", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<VersaoMentorSistema> getSistemasVersao() {
        return this.sistemasVersao;
    }

    public void setSistemasVersao(List<VersaoMentorSistema> sistemasVersao) {
        this.sistemasVersao = sistemasVersao;
    }

    @Column(name="NOME_BRANCH")
    public String getNomeBranch() {
        return this.nomeBranch;
    }

    public void setNomeBranch(String nomeBranch) {
        this.nomeBranch = nomeBranch;
    }

    @Column(name="MATURIDADE")
    public Short getMaturidade() {
        return this.maturidade;
    }

    public void setMaturidade(Short maturidade) {
        this.maturidade = maturidade;
    }

    @Column(name="LIBERAR_VERSAO")
    public Short getLiberarVersao() {
        return this.liberarVersao;
    }

    public void setLiberarVersao(Short liberarVersao) {
        this.liberarVersao = liberarVersao;
    }

    @Column(name="VERSAO_ATUALIZADOR")
    public Short getVersaoAtualizador() {
        return this.versaoAtualizador;
    }

    public void setVersaoAtualizador(Short versaoAtualizador) {
        this.versaoAtualizador = versaoAtualizador;
    }
}

