/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.properties;

import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import java.io.File;

public class ConfigProperties {
    private static ConfigProperties instance;
    private DTOConfiguracoes configuracoes;
    private File found = new File("properties.json");

    private ConfigProperties() {
    }

    public static ConfigProperties get() {
        if (instance == null) {
            instance = new ConfigProperties();
            if (ConfigProperties.instance.found.exists()) {
                try {
                    String content = ToolFile.getConteudoArquivo((File)ConfigProperties.instance.found);
                    ConfigProperties.instance.configuracoes = (DTOConfiguracoes)ToolJson.readJson((String)content, DTOConfiguracoes.class);
                }
                catch (ExceptionIO ex) {
                    ConfigProperties.instance.configuracoes = new DTOConfiguracoes();
                    ex.printStackTrace();
                    TLogger.get(ConfigProperties.class).error((Throwable)ex);
                    throw new ExceptionErroProgramacao("Erro ao ler o arquivo de configuracoes.");
                }
            } else {
                ConfigProperties.instance.configuracoes = new DTOConfiguracoes();
            }
        }
        return instance;
    }

    public void saveConfiguracoes() {
        try {
            String json = ToolJson.toJson((Object)this.configuracoes);
            ToolFile.writeStringInFile((File)this.found, (String)json);
        }
        catch (ExceptionIO ex) {
            ex.printStackTrace();
            TLogger.get(ConfigProperties.class).error((Throwable)ex);
            throw new ExceptionErroProgramacao("Erro ao salvar o arquivo de configuracoes.");
        }
    }

    public DTOConfiguracoes getConfiguracoes() {
        return this.configuracoes;
    }
}

