/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.properties;

import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.criptografia.ToolCriptografia;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertiesDatabase {
    public static final String URL_DB_MENTOR = "jdbc.url";
    public static final String SHOW_SQL = "hibernate.show_sql";
    public static final String FORMAT_SQL = "hibernate.format_sql";
    private final String DATABASE_PASS = "database.pass";
    private final String DATABASE_USER = "database.user";
    private final String DATABASE_DRIVER = "database.driver";
    private final String DATABASE_SEED = "database.seed";
    private static final String DEFAULT_FILE_NAME_CONFIG = "database_touchcomp_erp.properties";
    private final String DEFAULT_URL_MENTOR = "jdbc:firebirdsql://localhost:3051/mentor?lc_ctype=ISO8859_1";

    public static PropertiesDatabase get() {
        return new PropertiesDatabase();
    }

    public static Properties getProperties() {
        System.out.println("Props file entered");
        File propsFile = new File(DEFAULT_FILE_NAME_CONFIG);
        System.out.println("Props File: " + propsFile.getAbsolutePath());
        Properties props = new Properties();
        if (propsFile.exists()) {
            try {
                props.load(new FileInputStream(propsFile));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Logger.getLogger(PropertiesDatabase.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                FileOutputStream fout = new FileOutputStream(propsFile);
                props.put(URL_DB_MENTOR, "");
                props.put(SHOW_SQL, "");
                props.put(FORMAT_SQL, "");
                props.store(fout, "TouchComp Sistemas\nExemplo de Configuracoes:\nurl.database: jdbc:firebirdsql://host:porta/mentor  \nurl.database.cep: jdbc:firebirdsql://host:porta/endereco\nurl.database.log: jdbc:firebirdsql://host:porta/log\nurl.database.nfe: jdbc:firebirdsql://host:porta/nfe\nurl.database.binarydata: jdbc:firebirdsql://host:porta/binarydata?lc_ctype=ISO8859_1\n");
                fout.flush();
                fout.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    public String getDBPass(String defaultPass) throws ExceptionIO, ExceptionInvalidData {
        String st = PropertiesDatabase.getProperties().getProperty("database.pass");
        if (TMethods.isStrWithData((String)st)) {
            String semente = this.getDBSeedCripto();
            if (TMethods.isStrWithData((String)semente)) {
                try {
                    st = ToolCriptografia.decrypte((String)semente, (String)st);
                }
                catch (Exception e) {
                    throw new ExceptionInvalidData("W.GEN.000027", new Object[0]);
                }
            }
            try {
                st = ToolCriptografia.decrypteBase64((String)st);
            }
            catch (Exception e) {
                throw new ExceptionInvalidData("W.GEN.000028", new Object[0]);
            }
            return st;
        }
        return defaultPass;
    }

    public String getDBUser(String defaultUser) throws ExceptionIO {
        String st = PropertiesDatabase.getProperties().getProperty("database.user");
        if (TMethods.isStrWithData((String)st)) {
            return st;
        }
        return defaultUser;
    }

    public String getDBSeedCripto() throws ExceptionIO {
        String st = PropertiesDatabase.getProperties().getProperty("database.seed");
        if (TMethods.isStrWithData((String)st)) {
            return st;
        }
        return st;
    }

    public String getDBDriver(String defaultDriver) throws ExceptionIO {
        String st = PropertiesDatabase.getProperties().getProperty("database.driver");
        if (TMethods.isStrWithData((String)st)) {
            return st;
        }
        return defaultDriver;
    }

    public String getURLBDMentor() throws ExceptionIO {
        String str = PropertiesDatabase.getProperties().getProperty(URL_DB_MENTOR);
        if (!TMethods.isStrWithData((String)str)) {
            str = "jdbc:firebirdsql://localhost:3051/mentor?lc_ctype=ISO8859_1";
        }
        return str;
    }
}

