/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.service.nodo;

import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchversoes.dao.RepoNodo;
import com.touchcomp.touchversoes.model.Nodo;
import com.touchcomp.touchversoes.model.VersaoMentor;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceNodoImpl {
    @Autowired
    RepoNodo repo;

    public List<Nodo> getNodosWEBAll() {
        return this.repo.getNodosWEBAll();
    }

    public List<Nodo> getNodosWEBCrud() {
        return this.repo.getNodosWEBCrud();
    }

    private HashSet<Nodo> getNodosAlteradosOuLibWeb(VersaoMentor versao) {
        Date dataInicial = versao.getDataInicialDesenvolvimento();
        Date dataFinal = versao.getDataFinalDesenvolvimento();
        if (dataInicial == null || dataInicial.after(versao.getDataInicial())) {
            dataInicial = versao.getDataInicial();
        }
        if (dataFinal == null || dataFinal.after(versao.getDataFinal())) {
            dataFinal = versao.getDataFinal();
        }
        List<Nodo> nodos = this.repo.getNodosAlterados(dataInicial, dataFinal);
        List<Nodo> nodosWeb = this.repo.getNodosWeb(dataInicial, dataFinal);
        HashSet<Nodo> novos = new HashSet<Nodo>();
        novos.addAll(nodos);
        novos.addAll(nodosWeb);
        return novos;
    }

    public List<String> getComandosNodos(VersaoMentor versao) {
        HashSet<Nodo> nodos = this.getNodosAlteradosOuLibWeb(versao);
        LinkedList<String> queries = new LinkedList<String>();
        String base = "UPDATE OR INSERT INTO NODO (ID_NODO, DESCRICAO, REL_INDIVIDUAL,FRAME_CLASS, ID_CHILD, INDICE,LIST_REPORT,PRINCIPAL,BLOQUEADO,DATA_ATUALIZACAO,PATH_WEB,VO_CLASSES,PERMITE_INSERIR,PERMITE_EDITAR,PERMITE_EXCLUIR,PERMITE_EXCLUIR_TODOS,PERMITE_CLONAR,PERMITE_PESQUISAR,POSSUI_FILTROS_FIXOS, BLOQUEADO_DESKTOP,TIPO_NODO,DATA_LIBERACAO_WEB,UTILIZA_CERTIFICADO_DIGITAL) VALUES (@ID_NODO@, '@DESCRICAO@', '@REL_INDIVIDUAL@', '@FRAME_CLASS@', @ID_CHILD@,@INDICE@,'@LIST_REPORT@',@PRINCIPAL@,@BLOQUEADO@,'@DATA_ATUALIZACAO@','@PATH_WEB@','@VO_CLASSES@',@PERMITE_INSERIR@,@PERMITE_EDITAR@,@PERMITE_EXCLUIR@,@PERMITE_EXCLUIR_TODOS@,@PERMITE_CLONAR@,@PERMITE_PESQUISAR@,@POSSUI_FILTROS_FIXOS@,@BLOQUEADO_DESKTOP@,@TIPO_NODO@,'@DATA_LIBERACAO_WEB@',@UTILIZA_CERTIFICADO_DIGITAL@)MATCHING (ID_NODO);";
        String baseSemDataWeb = "UPDATE OR INSERT INTO NODO (ID_NODO, DESCRICAO, REL_INDIVIDUAL,FRAME_CLASS, ID_CHILD, INDICE,LIST_REPORT,PRINCIPAL,BLOQUEADO,DATA_ATUALIZACAO,PATH_WEB,VO_CLASSES,PERMITE_INSERIR,PERMITE_EDITAR,PERMITE_EXCLUIR,PERMITE_EXCLUIR_TODOS,PERMITE_CLONAR,PERMITE_PESQUISAR,POSSUI_FILTROS_FIXOS, BLOQUEADO_DESKTOP,TIPO_NODO,UTILIZA_CERTIFICADO_DIGITAL) VALUES (@ID_NODO@, '@DESCRICAO@', '@REL_INDIVIDUAL@', '@FRAME_CLASS@', @ID_CHILD@,@INDICE@,'@LIST_REPORT@',@PRINCIPAL@,@BLOQUEADO@,'@DATA_ATUALIZACAO@','@PATH_WEB@','@VO_CLASSES@',@PERMITE_INSERIR@,@PERMITE_EDITAR@,@PERMITE_EXCLUIR@,@PERMITE_EXCLUIR_TODOS@,@PERMITE_CLONAR@,@PERMITE_PESQUISAR@,@POSSUI_FILTROS_FIXOS@,@BLOQUEADO_DESKTOP@,@TIPO_NODO@,@UTILIZA_CERTIFICADO_DIGITAL@)MATCHING (ID_NODO);";
        for (Nodo nodo : nodos) {
            String st;
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("ID_NODO", nodo.getIdentificador());
            h.put("DESCRICAO", nodo.getDescricao() != null ? nodo.getDescricao() : "");
            h.put("REL_INDIVIDUAL", nodo.getSingleReport() != null ? nodo.getSingleReport() : "");
            h.put("FRAME_CLASS", nodo.getFrameClass() != null ? nodo.getFrameClass() : "");
            h.put("ID_CHILD", nodo.getIdChild());
            h.put("INDICE", nodo.getIndice());
            h.put("LIST_REPORT", nodo.getListReport() != null ? nodo.getListReport() : "");
            h.put("PRINCIPAL", nodo.getPrincipal());
            h.put("BLOQUEADO", nodo.getBloqueado());
            h.put("DATA_ATUALIZACAO", nodo.getDataAtualizacao());
            h.put("PATH_WEB", nodo.getPathWeb() != null ? nodo.getPathWeb() : "");
            h.put("VO_CLASSES", nodo.getVoClasses() != null ? nodo.getVoClasses() : "");
            h.put("PERMITE_INSERIR", nodo.getPermiteInserir());
            h.put("PERMITE_EDITAR", nodo.getPermiteEditar());
            h.put("PERMITE_EXCLUIR", nodo.getPermiteExcluir());
            h.put("PERMITE_EXCLUIR_TODOS", nodo.getPermiteExcluirTodos());
            h.put("PERMITE_CLONAR", nodo.getPermiteClonar());
            h.put("PERMITE_PESQUISAR", nodo.getPermitePesquisar());
            h.put("POSSUI_FILTROS_FIXOS", nodo.getPossuiFiltrosFixos());
            h.put("TIPO_NODO", nodo.getTipoNodo());
            h.put("BLOQUEADO_DESKTOP", String.valueOf(nodo.getBloqueadoDesktop()));
            h.put("UTILIZA_CERTIFICADO_DIGITAL", String.valueOf(nodo.getUtilizaCertificadoDigital()));
            if (nodo.getDataLiberacaoWeb() != null) {
                h.put("DATA_LIBERACAO_WEB", ToolDate.dateToStr((Date)nodo.getDataLiberacaoWeb(), (String)"dd.MM.yyyy"));
                st = ToolString.build((String)base, h);
                queries.add(st);
                continue;
            }
            st = ToolString.build((String)baseSemDataWeb, h);
            queries.add(st);
        }
        return queries;
    }
}

