/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.service.searchclass;

import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchversoes.dao.RepoSearchClass;
import com.touchcomp.touchversoes.model.SearchClass;
import com.touchcomp.touchversoes.model.SearchClassField;
import com.touchcomp.touchversoes.model.SearchClassFieldResItem;
import com.touchcomp.touchversoes.model.VersaoMentor;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSearchClassImpl {
    @Autowired
    RepoSearchClass repo;

    public SearchClass getSearchClass(String voClass) {
        return this.repo.getSearchClass(voClass);
    }

    public List<SearchClass> getSearchClassAlterados(Date dataBase) {
        return this.repo.getSearchClassAlterados(dataBase);
    }

    public List<String> getComandosNodos(VersaoMentor versao) {
        Date dataBase = versao.getDataInicialDesenvolvimento();
        if (dataBase == null) {
            dataBase = versao.getDataInicial();
        }
        if (dataBase == null) {
            dataBase = new Date();
        }
        dataBase = ToolDate.previousDays((Date)dataBase, (int)60);
        List<SearchClass> searchs = this.getSearchClassAlterados(dataBase);
        LinkedList<String> queries = new LinkedList<String>();
        for (SearchClass searchClass : searchs) {
            String defaultQueryRes = "UPDATE OR INSERT INTO SEARCH_CLASS_FIELD_RES (ID_SEARCH_CLASS_FIELD_RES, MASCARA,MASCARA_RES) VALUES (@id_search_class@, '@mascara@','@mascara_res@');";
            ArrayList<StringToken> tks = new ArrayList<StringToken>();
            tks.add(new StringToken("id_search_class", searchClass.getSearchFieldsRes().getIdentificador().toString()));
            tks.add(new StringToken("mascara", searchClass.getSearchFieldsRes().getMascara()));
            tks.add(new StringToken("mascara_res", searchClass.getSearchFieldsRes().getMascaraRes()));
            queries.add(ToolString.build((String)defaultQueryRes, tks));
            String defaultQueryResField = "UPDATE OR INSERT INTO SEARCH_CLASS_FIELD_R_ITEM (ID_SEARCH_CLASS_FIELD_R_IT, PATH_FIELD, ATIVO, ID_SEARCH_CLASS_FIELD_RES, INDICE,PATH_FIELD_DESC) VALUES (@id_field@, '@field@', @ativo@, @res_id_search_class@, @indice@,'@PATH_FIELD_DESC@');";
            for (SearchClassFieldResItem field : searchClass.getSearchFieldsRes().getFields()) {
                tks.clear();
                if (field == null) continue;
                tks.add(new StringToken("id_field", TString.onlyNumbers((String)field.getIdentificador().toString())));
                tks.add(new StringToken("field", field.getPathField()));
                tks.add(new StringToken("ativo", field.getAtivo() != null ? field.getAtivo().toString() : "0"));
                tks.add(new StringToken("res_id_search_class", searchClass.getSearchFieldsRes() != null ? TString.onlyNumbers((String)searchClass.getSearchFieldsRes().getIdentificador().toString()) : null));
                tks.add(new StringToken("indice", String.valueOf(field.getIndice())));
                tks.add(new StringToken("PATH_FIELD_DESC", field.getPathFieldDesc()));
                queries.add(ToolString.build((String)defaultQueryResField, tks));
            }
            String defaultQuery = "update or INSERT INTO SEARCH_CLASS (ID_SEARCH_CLASS, VO_CLASS, DESCRICAO,ID_SEARCH_CLASS_FIELD_RES) VALUES  (@id_search_class@, '@class@', '@descricao@', @id_search_class_res@);";
            tks.clear();
            tks.add(new StringToken("id_search_class", TString.onlyNumbers((String)searchClass.getIdentificador().toString())));
            tks.add(new StringToken("class", searchClass.getVoClass()));
            tks.add(new StringToken("descricao", searchClass.getDescricao()));
            tks.add(new StringToken("id_search_class_res", searchClass.getSearchFieldsRes() != null ? TString.onlyNumbers((String)searchClass.getSearchFieldsRes().getIdentificador().toString()) : null));
            queries.add(ToolString.build((String)defaultQuery, tks));
            String defaultQueryFields = "update or INSERT INTO SEARCH_FIELDS (ID_SEARCH_FIELD, DESCRICAO, PATH_FIELD, ID_SEARCH_CLASS, FIELD_CLASS, PERC_SIZE, INDICE, FIELD_TYPE_OPT, DEFAULT_VALUE, DEFAULT_CRITERIA, VISIBLE_OPT, ATIVO,TIPO_SMART_SEARCH) VALUES (@id_field@, '@desc_field@', '@path_field@', @id_search@, '@field_class@', @perc_size@, @indice@, @field_type@,'@default_value@', @default_criteria@, @visible_opt@,@ativo_opt@,@TIPO_SMART_SEARCH@);";
            for (SearchClassField field : searchClass.getSearchFields()) {
                if (field == null) continue;
                tks.clear();
                tks.add(new StringToken("id_field", TString.onlyNumbers((String)field.getIdentificador().toString())));
                tks.add(new StringToken("desc_field", field.getDescricao()));
                tks.add(new StringToken("path_field", field.getPathField()));
                tks.add(new StringToken("id_search", searchClass.getIdentificador().toString()));
                tks.add(new StringToken("field_class", field.getFieldClass()));
                tks.add(new StringToken("perc_size", field.getPercSize() != null ? TString.onlyNumbers((String)field.getPercSize().toString()) : "0"));
                tks.add(new StringToken("indice", String.valueOf(field.getIndice())));
                tks.add(new StringToken("field_type", field.getFieldTypeOpt() != null ? TString.onlyNumbers((String)field.getFieldTypeOpt().toString()) : "0"));
                tks.add(new StringToken("default_value", TMethods.isStrWithData((String)field.getDefaultValue()) ? field.getDefaultValue() : "null"));
                tks.add(new StringToken("default_criteria", field.getDefaultCriteria() != null ? TString.onlyNumbers((String)field.getDefaultCriteria().toString()) : "0"));
                tks.add(new StringToken("visible_opt", field.getVisibleOpt() != null ? TString.onlyNumbers((String)field.getVisibleOpt().toString()) : "0"));
                tks.add(new StringToken("ativo_opt", field.getAtivo() != null ? TString.onlyNumbers((String)field.getAtivo().toString()) : "0"));
                tks.add(new StringToken("TIPO_SMART_SEARCH", field.getTipoSmartSearch() != null ? TString.onlyNumbers((String)field.getTipoSmartSearch().toString()) : "null"));
                queries.add(ToolString.build((String)defaultQueryFields, tks));
            }
        }
        return queries;
    }
}

