/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.service.suiteversao;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchversoes.gui.suiteversao.auxiliar.UtilVersao;
import com.touchcomp.touchversoes.model.ScriptsVersoesMentorCont;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.model.VersaoMentorControle;
import com.touchcomp.touchversoes.service.nodo.ServiceNodoImpl;
import com.touchcomp.touchversoes.service.searchclass.ServiceSearchClassImpl;
import com.touchcomp.touchversoes.service.suiteversao.AuxBaseCriacao;
import com.touchcomp.touchversoes.service.versaomentorcontrole.ServiceVersaoMentorControleImpl;
import com.touchcomp.touchversoes.tools.ToolPaths;
import contatocore.util.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxCriarArquivoAtualizacaoBD
extends AuxBaseCriacao {
    private final ServiceVersaoMentorControleImpl serviceMentor;
    private String LOCAL_BASE_MENTOR = "web\\basementor\\src\\main\\java\\com\\touchcomp\\basementor\\model\\vo";
    private final ServiceNodoImpl serviceNodoImpl;
    private final ServiceSearchClassImpl serviceSearchClassImpl;

    public AuxCriarArquivoAtualizacaoBD(ServiceVersaoMentorControleImpl serviceMentor, ServiceNodoImpl serviceNodoImpl, ServiceSearchClassImpl serviceSearchClassImpl) {
        this.serviceMentor = serviceMentor;
        this.serviceNodoImpl = serviceNodoImpl;
        this.serviceSearchClassImpl = serviceSearchClassImpl;
    }

    public File criarArquivoZip(SuiteVersaoItem suiteItem, VersaoMentor versao, String projetosLocal) throws Exception {
        TipoBDVersao tipoBD = suiteItem.getTipoBDVersao();
        System.out.println("teste");
        File f = this.getFileUpdApp(ToolPaths.getVersionsDir(), tipoBD);
        f.delete();
        f.getParentFile().mkdirs();
        VersaoMentorControle versaoMentor = this.serviceMentor.getVersao(tipoBD, versao);
        if (versaoMentor == null) {
            return null;
        }
        List<File> toZip = this.criarArquivos(versaoMentor);
        if (ToolMethods.isEquals((Object)suiteItem.getTipoBDVersao().getCodigoSistema(), (Object)EnumConstTipoSistemasTouch.MENTOR_BD.getValue())) {
            File fValBD;
            File nodos = this.getFileNodos(versao);
            File pesquisa = this.getFileSearch(versao);
            if (nodos != null) {
                toZip.add(nodos);
            }
            if (pesquisa != null) {
                toZip.add(pesquisa);
            }
            if ((fValBD = this.criarArquivoValBD(suiteItem, projetosLocal)) != null && fValBD.exists()) {
                toZip.add(fValBD);
            }
        }
        new ZipUtils().criarZip((OutputStream)new FileOutputStream(f), toZip);
        return f;
    }

    public File criarArquivoAtualizacao(SuiteVersaoItem suiteItem, VersaoMentor versao, String projetosLocal) throws Exception {
        File f = this.criarArquivoZip(suiteItem, versao, projetosLocal);
        f = new UtilVersao().createZipFile(f, null, versao, suiteItem);
        return f;
    }

    private List<File> criarArquivos(VersaoMentorControle versao) throws IOException {
        LinkedList<File> files = new LinkedList<File>();
        int i = 0;
        for (ScriptsVersoesMentorCont script : versao.getScriptVersoes()) {
            LinkedList<String> data = new LinkedList<String>();
            script.getQuerys().forEach(j -> data.add(j.getQuery()));
            File fl = this.getFile(data, "val");
            String nome = "script".toUpperCase().replaceAll(" ", "_");
            File aux = new File(fl.getParentFile().getAbsolutePath() + "/" + nome + "-" + String.valueOf(script.getIdentificador() == null ? "gerado_sistema" + i : script.getIdentificador()) + ".upd");
            aux.delete();
            fl.renameTo(aux);
            files.add(aux);
            ++i;
        }
        return files;
    }

    private File criarArquivoValBD(SuiteVersaoItem suiteItem, String projetosLocal) throws FileNotFoundException, ExceptionIO, IOException {
        EnumConstTipoSistemasTouch tipo = EnumConstTipoSistemasTouch.get((Object)suiteItem.getTipoBDVersao().getCodigoSistema());
        if (ToolMethods.isEquals((Object)tipo, (Object)EnumConstTipoSistemasTouch.MENTOR_BD)) {
            List<String> data = this.getQueriesCheck(projetosLocal + File.separator + this.LOCAL_BASE_MENTOR);
            File f = this.getFile(data, "val");
            return f;
        }
        return null;
    }

    private List<String> getQueriesCheck(String string) throws FileNotFoundException {
        File[] data = new File(string).listFiles();
        LinkedList<String> queries = new LinkedList<String>();
        for (File f : data) {
            if (!f.exists() || !f.getName().toLowerCase().endsWith(".java")) continue;
            this.appendQuery(f, queries);
        }
        return queries;
    }

    private void appendQuery(File f, List<String> data) throws FileNotFoundException {
        Optional auxC;
        String auxName;
        JavaParser parser = new JavaParser();
        ParseResult pr = parser.parse(f);
        if (!pr.isSuccessful()) {
            return;
        }
        String className = f.getName().substring(0, f.getName().lastIndexOf("."));
        CompilationUnit comp = (CompilationUnit)pr.getResult().get();
        Optional found = comp.getClassByName(className);
        if (!found.isPresent()) {
            return;
        }
        ClassOrInterfaceDeclaration cl = (ClassOrInterfaceDeclaration)found.get();
        Optional auxAn = cl.getAnnotationByName("Entity");
        if (!auxAn.isPresent()) {
            return;
        }
        Optional auxIg = cl.getAnnotationByName("Ignore");
        if (auxIg.isPresent()) {
            return;
        }
        Optional auxtab = cl.getAnnotationByName("Table");
        if (!auxtab.isPresent()) {
            return;
        }
        String tableName = className;
        if (auxtab.isPresent() && TMethods.isStrWithData((String)(auxName = this.getFieldColumn((AnnotationExpr)auxtab.get())))) {
            tableName = auxName;
        }
        StringBuilder aux = new StringBuilder();
        StringBuilder fields = new StringBuilder();
        aux.append("select first 1 ");
        for (FieldDeclaration field : cl.getFields()) {
            auxC = field.getAnnotationByName("Column");
            if (auxC.isPresent()) {
                fields.append(this.getFieldColumn((AnnotationExpr)auxC.get()));
                fields.append(",");
            }
            if (!(auxC = field.getAnnotationByName("JoinColumn")).isPresent()) continue;
            fields.append(this.getFieldColumn((AnnotationExpr)auxC.get()));
            fields.append(",");
        }
        for (MethodDeclaration method : cl.getMethods()) {
            auxC = method.getAnnotationByName("Column");
            if (auxC.isPresent()) {
                fields.append(this.getFieldColumn((AnnotationExpr)auxC.get()));
                fields.append(",");
            }
            if (!(auxC = method.getAnnotationByName("JoinColumn")).isPresent()) continue;
            fields.append(this.getFieldColumn((AnnotationExpr)auxC.get()));
            fields.append(",");
        }
        if (fields.length() > 0) {
            fields.deleteCharAt(fields.length() - 1);
            aux.append((CharSequence)fields).append(" from ").append(tableName).append(";");
            data.add(aux.toString());
        } else {
            System.out.println("Classe nao foi adicionada por nao ter fields diretos declarados, provavelmente heranca " + tableName);
        }
    }

    public String getValueAtFromAnn(NormalAnnotationExpr an, String name) {
        NodeList anns = an.getPairs();
        Optional<MemberValuePair> found = anns.stream().filter(i -> i.getNameAsString().equalsIgnoreCase(name)).findFirst();
        if (found.isPresent()) {
            if (found.get().getValue() instanceof StringLiteralExpr) {
                return found.get().getValue().asStringLiteralExpr().asString();
            }
            return String.valueOf(found.get().getValue());
        }
        return null;
    }

    public String getFieldColumn(AnnotationExpr n) {
        if (n == null) {
            return null;
        }
        if (n instanceof NormalAnnotationExpr) {
            return this.getFieldColumn((NormalAnnotationExpr)n);
        }
        return null;
    }

    public String getFieldColumn(NormalAnnotationExpr n) {
        if (n != null) {
            return this.getValueAtFromAnn(n, "name");
        }
        return null;
    }

    public String getFieldName(FieldDeclaration field) {
        for (Node childNode : field.getChildNodes()) {
            if (!(childNode instanceof VariableDeclarator)) continue;
            return ((VariableDeclarator)childNode).getNameAsString();
        }
        return "";
    }

    public AnnotationExpr getAnnotation(FieldDeclaration decl, String ann) {
        NodeList anns = decl.getAnnotations();
        Optional<AnnotationExpr> found = anns.stream().filter(i -> i.getNameAsString().equalsIgnoreCase(ann)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    private File getFile(List<String> data, String extension) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        File fl = File.createTempFile("temp", "." + extension);
        fl.delete();
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        sb.append("<mentor beta=\"").append(Boolean.FALSE).append("\">");
        for (String ob : data) {
            sb.append("<outros><![CDATA[").append(ob).append("]]></outros>");
            sb.append("\n");
        }
        sb.append("</mentor>");
        fl.delete();
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fl), "UTF-8"));){
            out.write(sb.toString());
            out.flush();
        }
        return fl;
    }

    private File getFileSearch(VersaoMentor versao) throws ExceptionIO {
        try {
            List<String> queries = this.serviceSearchClassImpl.getComandosNodos(versao);
            if (!TMethods.isWithData(queries)) {
                return null;
            }
            return this.getFile(queries, "upd");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }

    private File getFileNodos(VersaoMentor versao) throws ExceptionIO {
        try {
            List<String> queries = this.serviceNodoImpl.getComandosNodos(versao);
            if (!TMethods.isWithData(queries)) {
                return null;
            }
            return this.getFile(queries, "upd");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new ExceptionIO(ex);
        }
    }
}

