/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.service.suiteversao;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.zip.ToolZipUtils;
import com.touchcomp.touchversoes.dto.DTOFilesInfo;
import com.touchcomp.touchversoes.gui.suiteversao.auxiliar.UtilVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.TipoBDVersaoArquivos;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.service.suiteversao.AuxBaseCriacao;
import com.touchcomp.touchversoes.service.suiteversao.ServiceSuiteVersaoImpl;
import com.touchcomp.touchversoes.service.versaomentor.ServiceVersaoMentorSistemaImpl;
import com.touchcomp.touchversoes.tools.ToolFilesVersion;
import com.touchcomp.touchversoes.tools.ToolPaths;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class AuxCriarArquivoAtualizacaoLocal
extends AuxBaseCriacao {
    private final ServiceSuiteVersaoImpl serviceSuiteVersao;
    private final ServiceVersaoMentorSistemaImpl serviceMentorSistema;

    public AuxCriarArquivoAtualizacaoLocal(ServiceSuiteVersaoImpl serviceSuiteVersao, ServiceVersaoMentorSistemaImpl serviceMentorSistema) {
        this.serviceSuiteVersao = serviceSuiteVersao;
        this.serviceMentorSistema = serviceMentorSistema;
    }

    public File criarArquivoZip(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        TipoBDVersao tipoBDVersao = suiteItem.getTipoBDVersao();
        SuiteVersaoItem versaoAnt = this.getVersaoAnterior(versao, suiteItem);
        LinkedList<DTOFilesInfo> arquivosAntigos = new LinkedList();
        if (versaoAnt != null && TMethods.isStrWithData((String)versaoAnt.getDadosArquivos())) {
            try {
                arquivosAntigos = ToolJson.readJsonList((String)versaoAnt.getDadosArquivos(), DTOFilesInfo.class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Erro ao carregar os dados de arquivos anteriores. Serao enviados todos os arquivos.");
            }
        }
        File dirVersao = new File(ToolPaths.getVersionsDir().getAbsolutePath() + File.separator + tipoBDVersao.getCodigoSistema());
        dirVersao.getParentFile().mkdirs();
        File dirVersaoTemp = new File(dirVersao.getAbsolutePath() + File.separator + "temp");
        dirVersaoTemp.getParentFile().mkdirs();
        List<DTOFilesInfo> novos = new LinkedList<DTOFilesInfo>();
        File f = this.getArquivoApp(suiteItem, arquivosAntigos, novos);
        novos = this.mesclarArquivos(novos, arquivosAntigos);
        suiteItem.setDadosArquivos(ToolJson.toJson(novos));
        return f;
    }

    public File criarArquivoAtualizacao(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        File f = this.criarArquivoZip(versao, suiteItem);
        f = new UtilVersao().createZipFile(null, f, versao, suiteItem);
        return f;
    }

    File getArquivoAppPatch(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        List<DTOFilesInfo> data = new LinkedList<DTOFilesInfo>();
        if (TMethods.isStrWithData((String)suiteItem.getDadosArquivos())) {
            data = ToolJson.readJsonList((String)suiteItem.getDadosArquivos(), DTOFilesInfo.class);
        }
        File f = this.getArquivoApp(suiteItem, data, new LinkedList<DTOFilesInfo>());
        System.out.println("Arquivo patch: " + f.getAbsolutePath());
        return f;
    }

    private File getArquivoApp(SuiteVersaoItem suiteItem, List<DTOFilesInfo> data, List<DTOFilesInfo> novos) throws Exception {
        TipoBDVersao tipoBDVersao = suiteItem.getTipoBDVersao();
        File dirVersao = new File(ToolPaths.getVersionsDir().getAbsolutePath() + File.separator + tipoBDVersao.getCodigoSistema());
        dirVersao.getParentFile().mkdirs();
        File dirVersaoTemp = new File(dirVersao.getAbsolutePath() + File.separator + "temp");
        dirVersaoTemp.getParentFile().mkdirs();
        File f = this.getFileUpdApp(ToolPaths.getVersionsDir(), suiteItem.getTipoBDVersao());
        File dirSourceApp = ToolPaths.getProjectAppDir(tipoBDVersao);
        if (!dirSourceApp.exists()) {
            throw new Exception("Verifique o diretorio do aplicativo " + String.valueOf(tipoBDVersao) + ". Informe-o no cadastro do sistema: " + dirSourceApp.getAbsolutePath());
        }
        ToolFile.removeFiles((File)dirVersaoTemp);
        new ToolFilesVersion().copyFiles(tipoBDVersao, data, novos, dirSourceApp, dirVersaoTemp);
        System.out.println("Compactando arquivos...");
        this.zipFiles(dirVersaoTemp, f);
        return f;
    }

    private List<String> getExtensoes(TipoBDVersao tipoBD) {
        if (tipoBD.getExtensoesArquivos() == null) {
            return new LinkedList<String>();
        }
        return Arrays.asList(tipoBD.getExtensoesArquivos().split(";"));
    }

    private void copyChangedFiles(List<DTOFilesInfo> data, List<DTOFilesInfo> novos, String sourceBaseDirProject, String sourceBaseDirApp, File currentLocal, File dirVersaoTemp, List<String> extensao, List<TipoBDVersaoArquivos> arquivos) throws ExceptionIO {
        for (File file : currentLocal.listFiles()) {
            if (file.isDirectory()) {
                this.copyChangedFiles(data, novos, sourceBaseDirProject, sourceBaseDirApp, file, dirVersaoTemp, extensao, arquivos);
                continue;
            }
            File temp = this.checkFile(sourceBaseDirProject, file, data, extensao, arquivos);
            if (temp == null) continue;
            this.copyFile(temp, sourceBaseDirProject, sourceBaseDirApp, dirVersaoTemp, arquivos, novos);
        }
    }

    private File checkFile(String sourceBaseDir, File file, List<DTOFilesInfo> data, List<String> extensoes, List<TipoBDVersaoArquivos> arquivos) {
        String relativePath = file.getAbsolutePath().substring(sourceBaseDir.length() + 1);
        boolean extensaoVal = this.isExtensaoValida(file, extensoes);
        boolean arquivoFixado = this.isArquivoFixado(relativePath, arquivos);
        if (!extensaoVal && !arquivoFixado) {
            return null;
        }
        if (!this.isArquivoModificado(relativePath, file, data)) {
            return null;
        }
        return file;
    }

    private boolean isExtensaoValida(File file, List<String> extensoes) {
        String extensao;
        int index = file.getName().lastIndexOf(".") + 1;
        return index < 0 || extensoes.contains(extensao = file.getName().substring(index));
    }

    private boolean isArquivoFixado(String relativePath, List<TipoBDVersaoArquivos> arquivos) {
        for (TipoBDVersaoArquivos arq : arquivos) {
            if (!arq.getArquivo().equalsIgnoreCase(relativePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isArquivoModificado(String pathFile, File file, List<DTOFilesInfo> data) {
        Optional<DTOFilesInfo> aux = data.stream().filter(i -> ToolMethods.isEquals((Object)i.getFilePath(), (Object)pathFile)).findFirst();
        if (!aux.isPresent()) {
            return true;
        }
        DTOFilesInfo info = aux.get();
        return file.length() != info.getLenght();
    }

    private void copyFile(File temp, String sourceBaseProject, String sourceBaseApp, File dirVersaoTemp, List<TipoBDVersaoArquivos> arquivos, List<DTOFilesInfo> novos) throws ExceptionIO {
        String relativeToParentFile = temp.getAbsolutePath().substring(sourceBaseProject.length() + 1);
        Optional<TipoBDVersaoArquivos> found = arquivos.stream().filter(i -> relativeToParentFile.startsWith(i.getArquivo())).findFirst();
        if (!found.isPresent()) {
            return;
        }
        DTOFilesInfo d = new DTOFilesInfo();
        d.setFilePath(relativeToParentFile);
        d.setLenght(temp.length());
        novos.add(d);
        TipoBDVersaoArquivos tp = found.get();
        String orignalName = temp.getName();
        String destDir = tp.getNovoNomeArquivo();
        File tempFile = new File(sourceBaseApp + File.separator + tp.getArquivo());
        File out = tempFile.isDirectory() ? (TMethods.isStrWithData((String)destDir) ? new File(String.valueOf(dirVersaoTemp) + File.separator + destDir + File.separator + orignalName) : new File(String.valueOf(dirVersaoTemp) + File.separator + relativeToParentFile)) : new File(String.valueOf(dirVersaoTemp) + File.separator + destDir);
        System.out.println("Copiando arquivo: " + temp.getName());
        ToolFile.copyFile((File)temp, (File)out);
    }

    private void zipFiles(File dirVersaoTemp, File fVersao) throws ExceptionIO {
        if (fVersao.exists()) {
            fVersao.delete();
        }
        ToolZipUtils.compressFilesFolder((File)dirVersaoTemp, (File)fVersao);
    }

    private SuiteVersaoItem getVersaoAnterior(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        SuiteVersaoItem suiteItemAnt = this.serviceSuiteVersao.getSuiteVersaoItemAnt(versao, suiteItem.getTipoBDVersao());
        return suiteItemAnt;
    }

    public List<DTOFilesInfo> mesclarArquivos(List<DTOFilesInfo> novos, List<DTOFilesInfo> arquivosAntigos) {
        for (DTOFilesInfo arquivosAntigo : arquivosAntigos) {
            Optional<DTOFilesInfo> found = novos.stream().filter(i -> TMethods.isEquals((Object)i.getFilePath(), (Object)arquivosAntigo.getFilePath())).findFirst();
            if (found.isPresent()) continue;
            novos.add(arquivosAntigo);
        }
        return novos;
    }
}

