/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.service.suiteversao;

import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.touchversoes.gui.suiteversao.auxiliar.UtilVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.service.nodo.ServiceNodoImpl;
import com.touchcomp.touchversoes.service.searchclass.ServiceSearchClassImpl;
import com.touchcomp.touchversoes.service.suiteversao.AuxBaseCriacao;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoBD;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoLocal;
import com.touchcomp.touchversoes.service.suiteversao.ServiceSuiteVersaoImpl;
import com.touchcomp.touchversoes.service.versaomentor.ServiceVersaoMentorSistemaImpl;
import com.touchcomp.touchversoes.service.versaomentorcontrole.ServiceVersaoMentorControleImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class AuxCriarArquivoAtualizacaoLocalBD
extends AuxBaseCriacao {
    private final ServiceVersaoMentorControleImpl serviceVersaoMentor;
    private final ServiceSuiteVersaoImpl serviceSuiteVersao;
    private final ServiceVersaoMentorSistemaImpl serviceVersaoMentorSistemaImpl;
    private static final String ENTRY_NAME_F_PROPERTIES = "update.properties";
    private static final String ENTRY_NAME_APLICACAO = "aplicacao.zip";
    private static final String ENTRY_NAME_SERVIDOR = "servidor.zip";
    private final ServiceNodoImpl serviceNodoImpl;
    private final ServiceSearchClassImpl serviceSearchClassImpl;

    public AuxCriarArquivoAtualizacaoLocalBD(ServiceVersaoMentorControleImpl serviceVersaoMentor, ServiceSuiteVersaoImpl serviceSuiteVersao, ServiceVersaoMentorSistemaImpl serviceVersaoMentorSistemaImpl, ServiceNodoImpl serviceNodoImpl, ServiceSearchClassImpl serviceSearchClassImpl) {
        this.serviceVersaoMentor = serviceVersaoMentor;
        this.serviceSuiteVersao = serviceSuiteVersao;
        this.serviceVersaoMentorSistemaImpl = serviceVersaoMentorSistemaImpl;
        this.serviceNodoImpl = serviceNodoImpl;
        this.serviceSearchClassImpl = serviceSearchClassImpl;
    }

    File criarArquivoAtualizacao(VersaoMentor versao, SuiteVersaoItem suiteItem, String localProjeto) throws Exception {
        File fileApp;
        File fSys = new AuxCriarArquivoAtualizacaoBD(this.serviceVersaoMentor, this.serviceNodoImpl, this.serviceSearchClassImpl).criarArquivoZip(suiteItem, versao, localProjeto);
        if (fSys != null) {
            fSys = ToolFile.renameFileName((File)fSys, (String)"servidor", (boolean)true);
        }
        if ((fileApp = new AuxCriarArquivoAtualizacaoLocal(this.serviceSuiteVersao, this.serviceVersaoMentorSistemaImpl).criarArquivoZip(versao, suiteItem)) != null) {
            fileApp = ToolFile.renameFileName((File)fileApp, (String)"aplicacao", (boolean)true);
        }
        File f = new UtilVersao().createZipFile(fSys, fileApp, versao, suiteItem);
        return f;
    }

    public File createFProperty(File fBD, File fSys, SuiteVersaoItem q, VersaoMentor versao) throws Exception {
        File f = new File(ENTRY_NAME_F_PROPERTIES);
        Properties props = new Properties();
        if (fBD != null) {
            props.setProperty("arquivo_servidor", ENTRY_NAME_SERVIDOR);
        }
        if (fSys != null) {
            props.setProperty("arquivo_aplicacao", ENTRY_NAME_APLICACAO);
        }
        props.setProperty("descricao", versao.getDescricao());
        props.setProperty("versao", versao.getCodigo().toString());
        if (versao.getVersaoAnterior() != null && versao.getVersaoAnterior().getCodigo() != null) {
            props.setProperty("versaoMinimo", versao.getVersaoAnterior().getCodigo().toString());
        } else {
            props.setProperty("versaoMinimo", "0");
        }
        props.setProperty("codigoAplicacao", q.getTipoBDVersao().getCodigoSistema().toString());
        props.setProperty("tipo", q.getTipoBDVersao().getTipo().toString());
        if (q.getUrlModificacoes() != null) {
            props.setProperty("urlModificacoes", q.getUrlModificacoes());
        }
        props.store(new FileOutputStream(f), "Configuracoes de atualizador");
        return f;
    }

    private void addFileToZip(ZipOutputStream zos, File arquivo, String entradaZip) throws IOException {
        if ((entradaZip = entradaZip.replaceAll("\\\\", "/")).startsWith("\\") || entradaZip.startsWith("/")) {
            entradaZip = entradaZip.substring(1);
        }
        byte[] buffer = new byte[4096];
        ZipEntry entrada = new ZipEntry(entradaZip);
        zos.putNextEntry(entrada);
        zos.setMethod(8);
        FileInputStream fis = new FileInputStream(arquivo);
        BufferedInputStream bis = new BufferedInputStream(fis, 2048);
        int bytesLidos = 0;
        while ((bytesLidos = bis.read(buffer, 0, 2048)) != -1) {
            zos.write(buffer, 0, bytesLidos);
        }
        zos.closeEntry();
    }
}

