/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.service.suiteversao;

import com.touchcomp.touchversoes.dao.RepoSuiteVersao;
import com.touchcomp.touchversoes.model.SuiteVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.VersaoMentor;
import com.touchcomp.touchversoes.service.nodo.ServiceNodoImpl;
import com.touchcomp.touchversoes.service.searchclass.ServiceSearchClassImpl;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoBD;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoLocal;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoLocalBD;
import com.touchcomp.touchversoes.service.suiteversao.AuxCriarArquivoAtualizacaoWEBApp;
import com.touchcomp.touchversoes.service.suiteversao.ServiceTesteEntidadeImpl;
import com.touchcomp.touchversoes.service.versaomentor.ServiceVersaoMentorSistemaImpl;
import com.touchcomp.touchversoes.service.versaomentorcontrole.ServiceVersaoMentorControleImpl;
import com.touchcomp.touchvomodel.temp.DTOSuiteVersaoQueryTest;
import java.io.File;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceSuiteVersaoImpl {
    @Autowired
    ServiceTesteEntidadeImpl serviceTestEntidade;
    @Autowired
    ServiceVersaoMentorControleImpl serviceVersaoMentor;
    @Autowired
    RepoSuiteVersao repo;
    @Autowired
    ServiceVersaoMentorSistemaImpl serviceVersaoMentorSistemaImpl;
    @Autowired
    private ServiceNodoImpl serviceNodoImpl;
    @Autowired
    private ServiceSearchClassImpl serviceSearchClassImpl;

    public SuiteVersao getSuiteVersao(VersaoMentor versao) {
        List<SuiteVersao> data = this.repo.getSuiteVersao(versao);
        return data.isEmpty() ? null : data.get(0);
    }

    public File createFileBDVersao(VersaoMentor versao, SuiteVersaoItem suiteItem, String localProjetos) throws Exception {
        return new AuxCriarArquivoAtualizacaoBD(this.serviceVersaoMentor, this.serviceNodoImpl, this.serviceSearchClassImpl).criarArquivoAtualizacao(suiteItem, versao, localProjetos);
    }

    public File createFileWEBApp(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        return new AuxCriarArquivoAtualizacaoWEBApp().criarArquivoAtualizacao(versao, suiteItem);
    }

    public File createFileLocal(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        return new AuxCriarArquivoAtualizacaoLocal(this, this.serviceVersaoMentorSistemaImpl).criarArquivoAtualizacao(versao, suiteItem);
    }

    public File createFileLocalPatch(SuiteVersaoItem suiteItem) throws Exception {
        return new AuxCriarArquivoAtualizacaoLocal(this, this.serviceVersaoMentorSistemaImpl).getArquivoAppPatch(suiteItem.getSuiteVersao().getVersaoMentor(), suiteItem);
    }

    public File createFileRemote(VersaoMentor versao, SuiteVersaoItem suiteItem) throws Exception {
        return new AuxCriarArquivoAtualizacaoLocal(this, this.serviceVersaoMentorSistemaImpl).criarArquivoAtualizacao(versao, suiteItem);
    }

    public File createFileLocalBD(VersaoMentor versao, SuiteVersaoItem item, String localProjetos) throws Exception {
        return new AuxCriarArquivoAtualizacaoLocalBD(this.serviceVersaoMentor, this, this.serviceVersaoMentorSistemaImpl, this.serviceNodoImpl, this.serviceSearchClassImpl).criarArquivoAtualizacao(versao, item, localProjetos);
    }

    public SuiteVersao saveOrUpdate(SuiteVersao suiteVersao) {
        return (SuiteVersao)this.repo.save(suiteVersao);
    }

    public DTOSuiteVersaoQueryTest validaVersaoMentor() throws Exception {
        return null;
    }

    SuiteVersaoItem getSuiteVersaoItemAnt(VersaoMentor versao, TipoBDVersao tipoBDVersao) {
        if (versao == null || tipoBDVersao == null) {
            return null;
        }
        return this.repo.getSuiteVersaoItem(versao.getCodigo(), tipoBDVersao);
    }
}

