/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.build.maven;

import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class BuildApiWarJar
extends CommandBaseProgress {
    public BuildApiWarJar(ProgressCurrentTask progress) {
        super(progress);
    }

    public void buildProjectsWar(DTOConfiguracoes tv, String codigoVersao) throws IOException, InterruptedException, JDOMException {
        this.forceWar(tv);
        this.buildInternal(tv);
    }

    public void buildProjectsJar(DTOConfiguracoes tv, String codigoVersao) throws IOException, InterruptedException, JDOMException {
        this.forceJar(tv);
        this.buildInternal(tv);
    }

    public void forceWar(DTOConfiguracoes tv) throws JDOMException, IOException {
        this.forceType(tv, true);
    }

    public void forceJar(DTOConfiguracoes tv) throws JDOMException, IOException {
        this.forceType(tv, false);
    }

    private void forceType(DTOConfiguracoes tv, boolean isWar) throws JDOMException, IOException {
        String path = tv.getLocalProjetoBase() + File.separator + "web\\mentorapi\\src\\main\\java\\com\\touchcomp\\touchapi\\";
        String fileNameTempWar = "AppMainWar.temp";
        String fileNameWar = "AppMainWar.java";
        String fileNameTempJar = "AppMainJar.temp";
        String fileNameJar = "AppMainJar.java";
        Namespace namespace = Namespace.getNamespace((String)"http://maven.apache.org/POM/4.0.0");
        String pathPom = tv.getLocalProjetoBase() + File.separator + "\\web\\mentorapi\\pom.xml";
        Document document = new SAXBuilder().build(pathPom);
        Element root = document.getRootElement();
        Element paking = root.getChild("packaging", namespace);
        Element props = root.getChild("properties", namespace);
        Element mainClass = props.getChild("main.class", namespace);
        if (isWar) {
            paking.setText("war");
            mainClass.setText("com.touchcomp.touchapi.AppMainWar");
        } else {
            paking.setText("jar");
            mainClass.setText("com.touchcomp.touchapi.AppMainJar");
        }
        Element dependency = root.getChild("dependencies", namespace);
        List dependencies = dependency.getChildren();
        Optional<Element> found = dependencies.stream().filter(i -> i.getChildText("artifactId", namespace) != null && i.getChildText("artifactId", namespace).equalsIgnoreCase("spring-boot-starter-web")).findFirst();
        Element baseElementSpring = found.get();
        baseElementSpring.removeChildren("exclusions", namespace);
        Element exclusions = new Element("exclusions", namespace);
        baseElementSpring.addContent((Content)exclusions);
        Element exclusionLogging = new Element("exclusion", namespace);
        exclusionLogging.addContent((Content)new Element("groupId", namespace).setText("org.springframework.boot"));
        exclusionLogging.addContent((Content)new Element("artifactId", namespace).setText("spring-boot-starter-logging"));
        if (isWar) {
            Element exclusionStartTomcat = new Element("exclusion", namespace);
            exclusionStartTomcat.addContent((Content)new Element("groupId", namespace).setText("org.springframework.boot"));
            exclusionStartTomcat.addContent((Content)new Element("artifactId", namespace).setText("spring-boot-starter-tomcat"));
            Element exclusionEmbedTomcat = new Element("exclusion", namespace);
            exclusionEmbedTomcat.addContent((Content)new Element("groupId", namespace).setText("org.apache.tomcat.embed"));
            exclusionEmbedTomcat.addContent((Content)new Element("artifactId", namespace).setText("tomcat-embed-websocket"));
            exclusions.addContent((Content)exclusionStartTomcat);
            exclusions.addContent((Content)exclusionEmbedTomcat);
        }
        exclusions.addContent((Content)exclusionLogging);
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(document, (OutputStream)new FileOutputStream(pathPom));
    }

    private void buildInternal(DTOConfiguracoes tv) throws IOException, InterruptedException {
        DTOCommand cmd = new DTOCommand(String.valueOf(this.getBaseDir()) + "\\apache-maven\\bin\\mvn.cmd clean install -DskipTests", new File(tv.getLocalProjetoBase() + File.separator + "web" + File.separator + "mentorapi"), "Build Projetos - Touch API");
        this.getProgress().onProgress(0, 3, cmd.getDescricao());
        this.exec(cmd);
    }
}

