/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.copy;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import com.touchcomp.touchversoes.tools.ToolSystem;
import com.touchcomp.touchversoes.util.UtilDirs;
import java.io.File;

public class CopyFiles
extends CommandBaseProgress {
    public CopyFiles(ProgressCurrentTask progress) {
        super(progress);
    }

    public void copyFiles(DTOConfiguracoes config, String codigoVersao) throws ExceptionIO {
        this.getProgress().onProgress(0, 3, "Copiando Instaladores ERP");
        this.copyInstaladoresERP(config, codigoVersao);
        this.getProgress().onProgress(1, 3, "Copiando Instaladores NFCe");
        this.copyInstaladoresNFCe(config, codigoVersao);
        this.getProgress().onProgress(2, 3, "Copiando WAR's");
        this.copyWars(config, codigoVersao);
        this.getProgress().finish("Copia finalizada");
    }

    private void copyInstaladoresERP(DTOConfiguracoes config, String codigoVersao) throws ExceptionIO {
        File dest = new File(config.getLocalInstaladoresBaseERP() + File.separator + "touch_comp_erp" + File.separator + codigoVersao + File.separator + "instalador_touch_comp_ERP_x32_" + codigoVersao + ".exe");
        File orig = new File(UtilDirs.getPathERP() + File.separator + "output" + File.separator + "instalador_touch_comp_ERP_x32.exe");
        ToolFile.copyFile((File)orig, (File)dest);
        dest = new File(config.getLocalInstaladoresBaseERP() + File.separator + "touch_comp_erp" + File.separator + codigoVersao + File.separator + "instalador_touch_comp_ERP_x64_" + codigoVersao + ".exe");
        orig = new File(UtilDirs.getPathERP() + File.separator + "output" + File.separator + "instalador_touch_comp_ERP_x64.exe");
        ToolFile.copyFile((File)orig, (File)dest);
        dest = new File(config.getLocalInstaladoresBaseERP() + File.separator + "touch_comp_erp" + File.separator + codigoVersao + File.separator + "instalador_touch_comp_ERP_" + codigoVersao + ".jar");
        orig = new File(String.valueOf(ToolSystem.getLocalDir()) + File.separator + "instaladores" + File.separator + "install_erp_java" + File.separator + "install.jar");
        ToolFile.copyFile((File)orig, (File)dest);
    }

    private void copyInstaladoresNFCe(DTOConfiguracoes config, String codigoVersao) throws ExceptionIO {
        File dest = new File(config.getLocalInstaladoresBaseNFCe() + File.separator + "touch_comp_nfce" + File.separator + codigoVersao + File.separator + "instalador_touch_nfce_" + codigoVersao + ".exe");
        File orig = new File(UtilDirs.getPathNFCe() + File.separator + "output" + File.separator + "instalador_NFCE.exe");
        ToolFile.copyFile((File)orig, (File)dest);
        dest = new File(config.getLocalInstaladoresBaseNFCe() + File.separator + "touch_comp_nfce" + File.separator + codigoVersao + File.separator + "instalador_touch_comp_NFCe_" + codigoVersao + ".jar");
        orig = new File(String.valueOf(UtilDirs.getPathNFCeFileJava()) + File.separator + "install.jar");
        ToolFile.copyFile((File)orig, (File)dest);
    }

    public void copyWars(DTOConfiguracoes config, String codigoVersao) throws ExceptionIO {
        File dest = new File(config.getLocalInstaladoresBaseWEB() + File.separator + "touch_comp_erp_api" + File.separator + codigoVersao + File.separator + "touch_api_" + codigoVersao + ".war");
        File orig = new File(config.getLocalProjetoBase() + File.separator + "web" + File.separator + "mentorapi" + File.separator + "target" + File.separator + "touch-api-0.0.1-SNAPSHOT.war");
        if (!orig.exists()) {
            orig = new File(config.getLocalProjetoBase() + File.separator + "web" + File.separator + "mentorapi" + File.separator + "target" + File.separator + "touch-erp.war");
        }
        System.out.println("copiando arquivo: " + String.valueOf(orig) + " para " + String.valueOf(dest));
        ToolFile.copyFile((File)orig, (File)dest);
        dest = new File(config.getLocalInstaladoresBaseWEB() + File.separator + "touch_comp_erp_web_old" + File.separator + codigoVersao + File.separator + "touch_api_web_old_" + codigoVersao + ".war");
        orig = new File(config.getLocalProjetoBase() + File.separator + "web-antigo" + File.separator + "mentorweb" + File.separator + "target" + File.separator + "mentor-0.0.1-SNAPSHOT.war");
        System.out.println("copiando arquivo: " + String.valueOf(orig) + " para " + String.valueOf(dest));
        ToolFile.copyFile((File)orig, (File)dest);
        dest = new File(config.getLocalInstaladoresBaseWEB() + File.separator + "touch_comp_erp_web_" + File.separator + codigoVersao + File.separator + "touch_api_web_" + codigoVersao + ".war");
        orig = new File(config.getLocalProjetoBase() + File.separator + "web" + File.separator + "touchwebfrontent" + File.separator + "target" + File.separator + "app.war");
        if (!orig.exists()) {
            orig = new File(config.getLocalProjetoBase() + File.separator + "web" + File.separator + "touchwebfrontent" + File.separator + "target" + File.separator + "touch-web.war");
        }
        System.out.println("copiando arquivo: " + String.valueOf(orig) + " para " + String.valueOf(dest));
        ToolFile.copyFile((File)orig, (File)dest);
    }
}

