/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.docker;

import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.stream.StreamGobbler;
import com.touchcomp.touchversoes.tools.ToolSystem;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;

public abstract class CommandBaseProgress {
    private final ProgressCurrentTask progress;

    public CommandBaseProgress(ProgressCurrentTask progress) {
        this.progress = progress;
    }

    public Process getProcess(DTOCommand cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("powershell.exe", "/c", cmd.getCommand());
        System.out.println("Command: " + cmd.getCommand());
        if (cmd.getBaseDir() != null) {
            builder.directory(cmd.getBaseDir());
        }
        Process process = builder.start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println, process.getErrorStream());
        Executors.newSingleThreadExecutor().submit(streamGobbler);
        return process;
    }

    public void exec(DTOCommand cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("powershell.exe", "/c", cmd.getCommand());
        System.out.println("Command: " + cmd.getCommand());
        if (cmd.getBaseDir() != null) {
            builder.directory(cmd.getBaseDir());
        }
        Process process = builder.start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println, process.getErrorStream());
        Executors.newSingleThreadExecutor().submit(streamGobbler);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new InterruptedException("Comando nao foi executado corretamente \n" + cmd.getCommand() + "\n\nCodigo retorno: " + exitCode);
        }
    }

    public void execPrompt(DTOCommand cmd) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("cmd.exe", "/c", cmd.getCommand());
        System.out.println("Command: " + cmd.getCommand());
        if (cmd.getBaseDir() != null) {
            builder.directory(cmd.getBaseDir());
        }
        Process process = builder.start();
        StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), System.out::println, process.getErrorStream());
        Executors.newSingleThreadExecutor().submit(streamGobbler);
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new InterruptedException("Comando nao foi executado corretamente \n" + cmd.getCommand() + "\n\nCodigo retorno: " + exitCode);
        }
    }

    public File getBaseDir() {
        return ToolSystem.getLocalDir();
    }

    public ProgressCurrentTask getProgress() {
        return this.progress;
    }
}

