/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.docker.front;

import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import com.touchcomp.touchversoes.tools.ToolSystem;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class DockerBaseFront
extends CommandBaseProgress {
    public DockerBaseFront(ProgressCurrentTask progress) {
        super(progress);
    }

    public List<DTOCommand> getCommands(DTOConfiguracoes config, String imageName, String codigoVersao) {
        LinkedList<DTOCommand> l = new LinkedList<DTOCommand>();
        String base = "npm install";
        String ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[0]);
        l.add(new DTOCommand(ret, this.getBaseDirSource(config), "Instalando dependencias"));
        base = "npm run build";
        ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[0]);
        l.add(new DTOCommand(ret, this.getBaseDirSource(config), "Construindo Projeto WEB"));
        base = "Xcopy /E /I \"{0}\" \"{1}\\build\" /K /D /H /Y";
        ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[]{this.getBaseDirSourceBuild(config).getAbsolutePath(), this.getBaseDir()});
        l.add(new DTOCommand(ret, "Copiando pasta Build"));
        base = "copy \"{0}\\package.json\" \"{1}\\package.json\"";
        ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[]{this.getBaseDirSource(config).getAbsolutePath(), this.getBaseDir()});
        l.add(new DTOCommand(ret, "Copiando arquivo package.json"));
        base = "copy \"{0}\\package-lock.json\" \"{1}\\package-lock.json\"";
        ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[]{this.getBaseDirSource(config).getAbsolutePath(), this.getBaseDir()});
        l.add(new DTOCommand(ret, "Copiando arquivo package-lock.json"));
        base = "docker build -t {0}/{1}:{2} .";
        ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[]{config.getDockerRepo(), imageName, codigoVersao});
        l.add(new DTOCommand(ret, this.getBaseDir(), "Construindo Docker Imagem - Front WEB"));
        base = "docker push {0}/{1}:{2}";
        ret = ToolBaseMethodsVO.toString((String)base, (Object[])new Object[]{config.getDockerRepo(), imageName, codigoVersao});
        l.add(new DTOCommand(ret, this.getBaseDir(), "Enviando Imagem Docker Hub - Front WEB"));
        return l;
    }

    private File getBaseDirSourceBuild(DTOConfiguracoes config) {
        return new File(config.getLocalProjetoBase() + File.separator + "web" + File.separator + "touchweberp" + File.separator + "build");
    }

    private File getBaseDirSource(DTOConfiguracoes config) {
        return new File(config.getLocalProjetoBase() + File.separator + "web" + File.separator + "touchweberp" + File.separator);
    }

    public void clearOldFiles() {
        File dir = this.getBaseDir();
        ToolFile.removeFiles((File)dir, (boolean)false, (String[])new String[]{"Dockerfile"});
    }

    private File getBaseDirDocker() {
        return new File(String.valueOf(ToolSystem.getLocalDir()) + File.separator + "front" + File.separator + "windows" + File.separator);
    }
}

