/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.instaladores;

import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.dto.DTOFilesInfo;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersaoArquivos;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import com.touchcomp.touchversoes.tools.ToolFilesVersion;
import com.touchcomp.touchversoes.tools.ToolPaths;
import com.touchcomp.touchversoes.util.UtilDirs;
import java.io.File;
import java.util.LinkedList;
import org.jdom2.Document;
import org.jdom2.Element;

public class InstallExeFiles
extends CommandBaseProgress {
    private static final String SCRIPT_64 = "script_instalacao_x64.iss";
    private static final String SCRIPT_32 = "script_instalacao_x32.iss";

    public InstallExeFiles(ProgressCurrentTask progress) {
        super(progress);
    }

    public void buildInstall(DTOConfiguracoes tv, SuiteVersaoItem item) throws Exception {
        this.changeLocalXMLVersionFile(tv, item);
        this.deleteOldFiles(tv, item);
        this.copyFiles(tv, item);
        File f = new File(String.valueOf(ToolPaths.getLocalInstalador(item)) + File.separator + SCRIPT_64);
        if (f.exists()) {
            this.getProgress().onProgress(1, 2, "Gerando instalador " + String.valueOf(item.getTipoBDVersao()));
            this.exec(new DTOCommand("& \"" + String.valueOf(super.getBaseDir()) + File.separator + "inno_setup_6" + File.separator + "iscc.exe\" script_instalacao_x64.iss", ToolPaths.getLocalInstalador(item), "Compilando instalador x64 -"));
        }
        if ((f = new File(String.valueOf(ToolPaths.getLocalInstalador(item)) + File.separator + SCRIPT_32)).exists()) {
            this.getProgress().onProgress(1, 2, "Gerando instalador " + String.valueOf(item.getTipoBDVersao()));
            this.exec(new DTOCommand("& \"" + String.valueOf(super.getBaseDir()) + File.separator + "inno_setup_6" + File.separator + "iscc.exe\" script_instalacao_x32.iss", ToolPaths.getLocalInstalador(item), "Compilando instalador x64 -"));
        }
        this.getProgress().finish("Instaladores gerados - " + String.valueOf(item.getTipoBDVersao()));
    }

    @Override
    public File getBaseDir() {
        return UtilDirs.getPathERPFile();
    }

    private void changeLocalXMLVersionFile(DTOConfiguracoes tv, SuiteVersaoItem item) throws Exception {
        try {
            String localFileAppVersion = item.getTipoBDVersao().getArqVersaoInstalador();
            String tagAppVersion = item.getTipoBDVersao().getTagArqVersaoInstalador();
            File localFileVersion = new File(String.valueOf(ToolPaths.getLocalInstalador(item)) + File.separator + localFileAppVersion);
            Document doc = ToolJdom.getDocument((File)localFileVersion);
            Element root = doc.getRootElement();
            Element child = root.getChild(tagAppVersion);
            if (child == null) {
                throw new Exception("Elemento " + tagAppVersion + "nao encotnrado no arrquivo de controle de versao " + localFileAppVersion);
            }
            child.setText(item.getSuiteVersao().getVersaoMentor().getCodigo().toString());
            ToolJdom.writeXMLPretty((Document)doc, (File)localFileVersion);
        }
        catch (ExceptionJDom ex) {
            ex.printStackTrace();
            TLogger.get(this.getClass()).error((Throwable)ex);
            throw new Exception(ex);
        }
    }

    private void copyFiles(DTOConfiguracoes tv, SuiteVersaoItem item) throws Exception {
        File destDir = ToolPaths.getLocalInstaladorAppFiles(item);
        File appDir = ToolPaths.getProjectAppDir(item.getTipoBDVersao());
        System.out.println("Copiando arquivo " + destDir.getAbsolutePath() + " para " + appDir.getAbsolutePath());
        new ToolFilesVersion().copyFiles(item.getTipoBDVersao(), new LinkedList<DTOFilesInfo>(), new LinkedList<DTOFilesInfo>(), appDir, destDir);
    }

    private void deleteOldFiles(DTOConfiguracoes tv, SuiteVersaoItem item) throws Exception {
        File instalador = ToolPaths.getLocalInstaladorAppFiles(item);
        for (TipoBDVersaoArquivos arquivo : item.getTipoBDVersao().getArquivos()) {
            File temp = new File(instalador.getAbsolutePath() + File.separator + arquivo.getNovoNomeArquivo());
            ToolFile.removeFiles((File)temp);
        }
    }
}

