/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.instaladores;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.jdom.ExceptionJDom;
import com.touchcomp.basementortools.tools.jdom.ToolJdom;
import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import com.touchcomp.touchversoes.util.UtilDirs;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class InstallNFCeJava
extends CommandBaseProgress {
    public InstallNFCeJava(ProgressCurrentTask progress) {
        super(progress);
    }

    public void buildInstall(DTOConfiguracoes tv, String codigoVersao) throws ExceptionIO, IOException, InterruptedException, ExceptionJDom {
        File f = this.buildInstallERP(tv, codigoVersao);
        System.out.println("Install XML: " + f.getAbsolutePath());
        this.getProgress().onProgress(1, 2, "Gerando instalador Touch NFCe JAVA");
        this.exec(new DTOCommand("& \"" + String.valueOf(super.getBaseDir()) + File.separator + "iz" + File.separator + "bin" + File.separator + "compile.bat\" " + f.getName(), this.getBaseDir(), "Compilando instalador NFCe Java"));
        this.getProgress().finish("Instalador Touch NFCe Java gerado");
    }

    @Override
    public File getBaseDir() {
        return UtilDirs.getPathNFCeFileJava();
    }

    private File buildInstallERP(DTOConfiguracoes tv, String codigoVersao) throws ExceptionIO, IOException, InterruptedException, ExceptionJDom {
        File input = new File(this.getBaseDir().getAbsolutePath() + File.separator + "install_nfce.xml");
        Document d = ToolJdom.getDocument((File)input);
        Element root = d.getRootElement();
        Element packs = root.getChild("packs");
        Element mainPack = packs.getChild("pack");
        mainPack.removeChildren("file");
        File base = new File(UtilDirs.getPathNFCe() + File.separator + "nfce");
        this.addFiles(mainPack, base, base);
        XMLOutputter x = new XMLOutputter();
        Format format = Format.getPrettyFormat();
        format.setEncoding("ISO-8859-1");
        x.setFormat(format);
        x.output(d, (Writer)new FileWriter(input.getAbsolutePath()));
        return input;
    }

    private void addFiles(Element pack, File relative, File parent) {
        if (parent == null || parent.listFiles() == null || !parent.exists()) {
            return;
        }
        for (File f : parent.listFiles()) {
            if (!f.exists()) {
                throw new RuntimeException("Arquivo necess\u00e1rio a instala\u00e7\u00e3o: \n" + f.getAbsolutePath() + "\n n\u00e3o existe.");
            }
            if (f.isDirectory()) {
                this.addFiles(pack, relative, f);
                continue;
            }
            String relativePath = "";
            if (f.getParent().length() > relative.getAbsolutePath().length()) {
                relativePath = f.getAbsolutePath().substring(relative.getAbsolutePath().length(), f.getParent().length());
            }
            Element file = new Element("file");
            file.setAttribute("override", "true");
            file.setAttribute("src", f.getAbsolutePath());
            file.setAttribute("targetdir", "$INSTALL_PATH" + relativePath);
            pack.addContent((Content)file);
        }
    }
}

