/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tasks.qualidade;

import com.touchcomp.touchversoes.dto.DTOCommand;
import com.touchcomp.touchversoes.dto.DTOConfiguracoes;
import com.touchcomp.touchversoes.gui.progress.ProgressCurrentTask;
import com.touchcomp.touchversoes.tasks.docker.CommandBaseProgress;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.JDOMException;

public class BuildMavenTestes
extends CommandBaseProgress {
    public BuildMavenTestes(ProgressCurrentTask progress) {
        super(progress);
    }

    public void testIt(DTOConfiguracoes conf) throws IOException, InterruptedException, JDOMException {
        File base = new File(conf.getLocalProjetoBase() + File.separator + "web");
        LinkedList<File> mavenProjects = new LinkedList<File>();
        this.listMavenProjects(base, mavenProjects);
        base = new File(conf.getLocalProjetoBase() + File.separator + "desktop" + File.separator + "nfce");
        this.listMavenProjects(base, mavenProjects);
        for (File mavenProject : mavenProjects) {
            DTOCommand cmd = new DTOCommand(String.valueOf(this.getBaseDir()) + "\\apache-maven\\bin\\mvn.cmd test", mavenProject.getParentFile(), "Realizando testes - " + mavenProject.getParentFile().getName());
            this.getProgress().onProgress(0, 4, cmd.getDescricao());
            this.exec(cmd);
        }
    }

    public void listMavenProjects(File folder, List<File> mavenProjects) {
        if (!folder.exists() || !folder.isDirectory()) {
            System.out.println("Invalid folder path.");
            return;
        }
        File[] subdirectories = folder.listFiles(File::isDirectory);
        if (subdirectories != null) {
            for (File subdir : subdirectories) {
                File pomFile = new File(subdir, "pom.xml");
                if (!pomFile.exists()) continue;
                System.out.println("Maven Project Found: " + subdir.getAbsolutePath());
                mavenProjects.add(pomFile);
            }
        }
    }

    public void listMavenProjects(File[] subdirectories, List<File> mavenProjects) {
        if (subdirectories == null) {
            return;
        }
        for (File subdir : subdirectories) {
            File pomFile = new File(subdir, "pom.xml");
            if (!pomFile.exists()) continue;
            mavenProjects.add(pomFile);
            break;
        }
    }
}

