/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tools;

import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchversoes.dto.DTOFilesInfo;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.model.TipoBDVersaoArquivos;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ToolFilesVersion {
    private List<String> getExtensoes(TipoBDVersao tipoBD) {
        if (tipoBD.getExtensoesArquivos() == null) {
            return new LinkedList<String>();
        }
        return Arrays.asList(tipoBD.getExtensoesArquivos().split(";"));
    }

    public void copyFiles(TipoBDVersao tipoBDVersao, List<DTOFilesInfo> data, List<DTOFilesInfo> novos, File sourceBaseDirApp, File dirVersaoTemp) throws ExceptionIO {
        List<String> extensoes = this.getExtensoes(tipoBDVersao);
        List<TipoBDVersaoArquivos> arquivos = tipoBDVersao.getArquivos();
        this.copyChangedFiles(data, novos, sourceBaseDirApp.getAbsolutePath(), sourceBaseDirApp.getAbsolutePath(), sourceBaseDirApp, dirVersaoTemp, arquivos, extensoes);
    }

    private void copyChangedFiles(List<DTOFilesInfo> data, List<DTOFilesInfo> novos, String sourceBaseDirProject, String sourceBaseDirApp, File currentLocal, File dirVersaoTemp, List<TipoBDVersaoArquivos> arquivos, List<String> extensoes) throws ExceptionIO {
        for (TipoBDVersaoArquivos arq : arquivos) {
            File aux = new File(currentLocal.getAbsolutePath() + File.separator + arq.getArquivo());
            if (aux.isDirectory()) {
                this.copyChangedFilesInternal(data, novos, sourceBaseDirProject, sourceBaseDirApp, aux, dirVersaoTemp, arquivos, extensoes);
                continue;
            }
            File temp = this.checkFile(sourceBaseDirProject, aux, data, extensoes, arquivos);
            if (temp == null) continue;
            this.copyFile(temp, sourceBaseDirProject, sourceBaseDirApp, dirVersaoTemp, arquivos, novos);
        }
    }

    private void copyChangedFilesInternal(List<DTOFilesInfo> data, List<DTOFilesInfo> novos, String sourceBaseDirProject, String sourceBaseDirApp, File currentLocal, File dirVersaoTemp, List<TipoBDVersaoArquivos> arquivos, List<String> extensoes) throws ExceptionIO {
        for (File file : currentLocal.listFiles()) {
            if (file.isDirectory()) {
                this.copyChangedFilesInternal(data, novos, sourceBaseDirProject, sourceBaseDirApp, file, dirVersaoTemp, arquivos, extensoes);
                continue;
            }
            File temp = this.checkFile(sourceBaseDirProject, file, data, extensoes, arquivos);
            if (temp == null) continue;
            this.copyFile(temp, sourceBaseDirProject, sourceBaseDirApp, dirVersaoTemp, arquivos, novos);
        }
    }

    private File checkFile(String sourceBaseDir, File file, List<DTOFilesInfo> data, List<String> extensoes, List<TipoBDVersaoArquivos> arquivos) {
        String relativePath = file.getAbsolutePath().substring(sourceBaseDir.length() + 1);
        boolean extensaoVal = this.isExtensaoValida(file, extensoes);
        boolean arquivoFixado = this.isArquivoFixado(relativePath, arquivos);
        if (!extensaoVal && !arquivoFixado) {
            return null;
        }
        if (!this.isArquivoModificado(relativePath, file, data)) {
            return null;
        }
        return file;
    }

    private boolean isExtensaoValida(File file, List<String> extensoes) {
        String extensao;
        int index = file.getName().lastIndexOf(".") + 1;
        return index < 0 || extensoes.contains(extensao = file.getName().substring(index));
    }

    private boolean isArquivoFixado(String relativePath, List<TipoBDVersaoArquivos> arquivos) {
        for (TipoBDVersaoArquivos arq : arquivos) {
            if (!arq.getArquivo().equalsIgnoreCase(relativePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isArquivoModificado(String pathFile, File file, List<DTOFilesInfo> data) {
        Optional<DTOFilesInfo> aux = data.stream().filter(i -> ToolMethods.isEquals((Object)i.getFilePath(), (Object)pathFile)).findFirst();
        if (!aux.isPresent()) {
            return true;
        }
        DTOFilesInfo info = aux.get();
        return Math.abs(file.length() - info.getLenght()) > 5L;
    }

    private void copyFile(File temp, String sourceBaseProject, String sourceBaseApp, File dirVersaoTemp, List<TipoBDVersaoArquivos> arquivos, List<DTOFilesInfo> novos) throws ExceptionIO {
        String relativeToParentFile = temp.getAbsolutePath().substring(sourceBaseProject.length() + 1);
        Optional<TipoBDVersaoArquivos> found = arquivos.stream().filter(i -> relativeToParentFile.startsWith(i.getArquivo())).findFirst();
        if (!found.isPresent()) {
            return;
        }
        DTOFilesInfo d = new DTOFilesInfo();
        d.setFilePath(relativeToParentFile);
        d.setLenght(temp.length());
        novos.add(d);
        TipoBDVersaoArquivos tp = found.get();
        String orignalName = temp.getName();
        String destDir = tp.getNovoNomeArquivo();
        File tempFile = new File(sourceBaseApp + File.separator + tp.getArquivo());
        File out = tempFile.isDirectory() ? (TMethods.isStrWithData((String)destDir) ? new File(String.valueOf(dirVersaoTemp) + File.separator + destDir + File.separator + orignalName) : new File(String.valueOf(dirVersaoTemp) + File.separator + relativeToParentFile)) : new File(String.valueOf(dirVersaoTemp) + File.separator + destDir);
        System.out.println("Copiando arquivo: " + temp.getName());
        ToolFile.copyFile((File)temp, (File)out);
    }
}

