/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.touchversoes.tools;

import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistemasTouch;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchversoes.gui.AuxSuiteVersao;
import com.touchcomp.touchversoes.model.SuiteVersaoItem;
import com.touchcomp.touchversoes.model.TipoBDVersao;
import com.touchcomp.touchversoes.properties.ConfigProperties;
import java.io.File;
import java.util.Optional;

public class ToolPaths {
    public static File getProjectAppDir(TipoBDVersao tipo) {
        File dirApp = new File(String.valueOf(ToolPaths.getProjectsDir()) + File.separator + tipo.getPathRelativoProjetoDir());
        return dirApp;
    }

    public static File getFileApp(TipoBDVersao tipo, String extension) throws Exception {
        String[] aux = ToolString.splitString((String)tipo.getPathArquivoApp(), (char[])new char[]{'/', '\\', '.'});
        File dirApp = null;
        for (int i = 0; i < aux.length && (!(dirApp = new File(ToolPaths.getProjectAppDir(tipo).getAbsolutePath() + File.separator + aux[i])).exists() || extension != null && !dirApp.getName().endsWith(extension)); ++i) {
        }
        if (dirApp == null) {
            throw new Exception("Arquivo da aplicacao nao encontrado, conforme mapeamento no ERP, recurso Tipos de Bancos de Dados/Sistema: " + String.valueOf(tipo));
        }
        return dirApp;
    }

    public static File getVersionsDir() {
        File versoesDir = new File(ToolPaths.getUserDir() + File.separator + "suite_versao");
        return versoesDir;
    }

    public static File getProjectsDir() {
        File dirProjetos = new File(ConfigProperties.get().getConfiguracoes().getLocalProjetoBase());
        return dirProjetos;
    }

    public static String getUserDir() {
        return ToolFile.getUserDir();
    }

    public static File getDirInstaladores() {
        File dirProjetos = new File(ToolPaths.getUserDir() + File.separator + "install");
        return dirProjetos;
    }

    public static File getLocalInstalador(SuiteVersaoItem item) throws Exception {
        String localInstalador = item.getTipoBDVersao().getPathInstalador();
        File f = new File(ToolPaths.getDirInstaladores().getAbsolutePath() + File.separator + localInstalador);
        if (!f.exists()) {
            throw new Exception("Arquivo de controle de versao nao existe " + localInstalador);
        }
        return f;
    }

    public static File getLocalInstaladorJava(SuiteVersaoItem item) throws Exception {
        String localInstalador = item.getTipoBDVersao().getPathInstaladorJava();
        File f = new File(ToolPaths.getDirInstaladores().getAbsolutePath() + File.separator + localInstalador);
        if (!f.exists()) {
            throw new Exception("Arquivo de controle de versao nao existe " + localInstalador);
        }
        return f;
    }

    public static File getLocalInstaladorAppFiles(SuiteVersaoItem item) throws Exception {
        File f = new File(ToolPaths.getLocalInstalador(item).getAbsolutePath() + File.separator + "app_files");
        if (!f.exists()) {
            throw new Exception("Arquivo de controle de versao nao existe " + f.getAbsolutePath());
        }
        return f;
    }

    public static boolean existsSuiteItem(EnumConstTipoSistemasTouch tipo, AuxSuiteVersao suiteVersao) throws Exception {
        if (suiteVersao.getItensSelecionadosVersao() == null) {
            return false;
        }
        Optional<SuiteVersaoItem> found = suiteVersao.getItensSelecionadosVersao().stream().filter(i -> TMethods.isEquals((Object)EnumConstTipoSistemasTouch.get((Object)i.getTipoBDVersao().getCodigoSistema()), (Object)EnumConstTipoSistemasTouch.get((Object)tipo.getValue()))).findFirst();
        return found.isPresent();
    }

    public static SuiteVersaoItem getSuiteItem(EnumConstTipoSistemasTouch tipo, AuxSuiteVersao suiteVersao) throws Exception {
        if (suiteVersao.getItensSelecionadosVersao() == null) {
            return null;
        }
        Optional<SuiteVersaoItem> found = suiteVersao.getItensSelecionadosVersao().stream().filter(i -> TMethods.isEquals((Object)EnumConstTipoSistemasTouch.get((Object)i.getTipoBDVersao().getCodigoSistema()), (Object)EnumConstTipoSistemasTouch.get((Object)tipo.getValue()))).findFirst();
        if (!found.isPresent()) {
            throw new Exception("Erro de programacao para gerar o instalador. Tipo nao encontrado na versao " + String.valueOf(tipo));
        }
        return found.get();
    }
}

