/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.helper.impl.colaborador;

import com.touchcomp.basementor.constants.ConstantsColaborador;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.helper.AbstractHelperVO;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDependente;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PreCadastroColaborador;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class HelperColaborador
implements AbstractHelperVO<Colaborador> {
    private Colaborador colaborador;

    @Override
    public HelperColaborador build(Colaborador colaborador) {
        this.colaborador = colaborador;
        return this;
    }

    @Override
    public Colaborador get() {
        return this.colaborador;
    }

    public List<ColaboradorDependente> getDependentesPensao(List<ColaboradorDependente> todosDeps, Date dataBase) {
        List<ColaboradorDependente> deps = todosDeps.stream().filter(i -> !(!ToolMethods.isAffirmative((Number)i.getDependenteBenefPensao()) || i.getDadosDepPensao() == null || i.getDadosDepPensao().getDataBaixa() != null && !ToolMethods.isAfterEqual((Date)i.getDadosDepPensao().getDataBaixa(), (Date)dataBase, (boolean)true) || i.getDadosDepPensao().getDataVigenciaFinal() != null && !ToolMethods.isBetweenEqual((Date)dataBase, (Date)i.getDadosDepPensao().getDataVigenciaInicial(), (Date)i.getDadosDepPensao().getDataVigenciaFinal(), (boolean)true))).collect(Collectors.toList());
        return deps;
    }

    public List<ColaboradorDependente> getDependentesPensao(Date dataBase) {
        return this.getDependentesPensao(this.colaborador.getDependentesColaborador(), dataBase);
    }

    public List<ColaboradorDependente> getDependentesPlanoSaude(List<ColaboradorDependente> todosDeps, Date dataBase) {
        List<ColaboradorDependente> deps = todosDeps.stream().filter(i -> !(!ToolMethods.isAffirmative((Number)i.getDependentePlanoSaude()) || i.getDadosDepPlanoSaude() == null || i.getDadosDepPlanoSaude().getDataBaixa() != null && !ToolMethods.isAfterEqual((Date)i.getDadosDepPlanoSaude().getDataBaixa(), (Date)dataBase, (boolean)true) || i.getDadosDepPlanoSaude().getDataVigenciaFinal() != null && !ToolMethods.isBetweenEqual((Date)dataBase, (Date)i.getDadosDepPlanoSaude().getDataVigenciaInicial(), (Date)i.getDadosDepPlanoSaude().getDataVigenciaFinal(), (boolean)true))).collect(Collectors.toList());
        return deps;
    }

    public List<ColaboradorDependente> getDependentesPlanoSaude(Date dataBase) {
        return this.getDependentesPlanoSaude(this.colaborador.getDependentesColaborador(), dataBase);
    }

    public List<ColaboradorDependente> getDependentesSalFamIRRF(Date dataBase) {
        List<ColaboradorDependente> deps = this.colaborador.getDependentesColaborador().stream().filter(i -> {
            if (ToolMethods.isAffirmative((Number)i.getDependenteIncapacitado()) || ToolMethods.isAffirmative((Number)i.getDependenteSalarioFamilia()) && i.getDadosDepSalFamilia() != null && (i.getDadosDepSalFamilia().getDataBaixa() == null || ToolMethods.isAfterEqual((Date)i.getDadosDepSalFamilia().getDataBaixa(), (Date)dataBase, (boolean)true)) && (i.getDadosDepSalFamilia().getDataVigenciaFinal() == null || ToolMethods.isBetweenEqual((Date)dataBase, (Date)i.getDadosDepSalFamilia().getDataVigenciaInicial(), (Date)i.getDadosDepSalFamilia().getDataVigenciaFinal(), (boolean)true))) {
                return true;
            }
            return ToolMethods.isAffirmative((Number)i.getDependenteIncapacitado()) || ToolMethods.isAffirmative((Number)i.getDependenteIRRF()) && i.getDadosDepIRRF() != null && (i.getDadosDepIRRF().getDataBaixa() == null || ToolMethods.isAfterEqual((Date)i.getDadosDepIRRF().getDataBaixa(), (Date)dataBase, (boolean)true)) && (i.getDadosDepIRRF().getDataVigenciaFinal() == null || ToolMethods.isBetweenEqual((Date)dataBase, (Date)i.getDadosDepIRRF().getDataVigenciaInicial(), (Date)i.getDadosDepIRRF().getDataVigenciaFinal(), (boolean)true));
        }).collect(Collectors.toList());
        return deps;
    }

    public List getDependentesIRRF(Date dataFinal) {
        List deps = this.colaborador.getDependentesColaborador().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getDependenteIncapacitado()) || ToolMethods.isAffirmative((Number)i.getDependenteIRRF()) && i.getDadosDepIRRF() != null && (i.getDadosDepIRRF().getDataBaixa() == null || ToolMethods.isAfterEqual((Date)i.getDadosDepIRRF().getDataBaixa(), (Date)dataFinal, (boolean)true)) && (i.getDadosDepIRRF().getDataVigenciaFinal() == null || ToolMethods.isBetweenEqual((Date)dataFinal, (Date)i.getDadosDepIRRF().getDataVigenciaInicial(), (Date)i.getDadosDepIRRF().getDataVigenciaFinal(), (boolean)true))).collect(Collectors.toList());
        return deps;
    }

    public List<ColaboradorDependente> getDependentesSalFam(Date dataFinal) {
        List<ColaboradorDependente> deps = this.colaborador.getDependentesColaborador().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getDependenteIncapacitado()) || ToolMethods.isAffirmative((Number)i.getDependenteSalarioFamilia()) && i.getDadosDepSalFamilia() != null && (i.getDadosDepSalFamilia().getDataBaixa() == null || ToolMethods.isAfterEqual((Date)i.getDadosDepSalFamilia().getDataBaixa(), (Date)dataFinal, (boolean)true)) && (i.getDadosDepSalFamilia().getDataVigenciaFinal() == null || ToolMethods.isBetweenEqual((Date)dataFinal, (Date)i.getDadosDepSalFamilia().getDataVigenciaInicial(), (Date)i.getDadosDepSalFamilia().getDataVigenciaFinal(), (boolean)true))).collect(Collectors.toList());
        return deps;
    }

    public Colaborador getBuscarPreCadastro(PreCadastroColaborador preCadastroColaborador, Colaborador colaborador) {
        colaborador.setNumeroRegistro(preCadastroColaborador.getNumeroRegistro());
        colaborador.setCentroCusto(preCadastroColaborador.getCentroCusto());
        colaborador.setTipoColaborador(preCadastroColaborador.getTipoColaborador());
        colaborador.setNomePai(preCadastroColaborador.getNomePai());
        colaborador.setNomeMae(preCadastroColaborador.getNomeMae());
        colaborador.setRacaCor(preCadastroColaborador.getRacaCor());
        colaborador.setTipoDeficiencia(preCadastroColaborador.getTipoDeficiencia());
        colaborador.setGrauInstrucao(preCadastroColaborador.getGrauInstrucao());
        colaborador.setEstadoCivil(preCadastroColaborador.getEstadoCivil());
        colaborador.setNumeroPis(preCadastroColaborador.getNumeroPis());
        colaborador.setDataEmissaoCTPS(preCadastroColaborador.getDataCarteiraProfissional());
        colaborador.setCarteiraHabilitacao(preCadastroColaborador.getCnh());
        colaborador.setCategoriaCNH(preCadastroColaborador.getCategoriaCnh());
        colaborador.setDataValidadeCNH(preCadastroColaborador.getDataValidadeCnh());
        colaborador.setDataAdmissao(preCadastroColaborador.getDataAdmissao());
        colaborador.setCarteiraProfissional(preCadastroColaborador.getCarteiraProfissional());
        colaborador.setSerieCarteiraProfissional(preCadastroColaborador.getSerieCarteira());
        colaborador.setUfCarteiraProfissional(preCadastroColaborador.getUfCarteira());
        colaborador.setFuncao(preCadastroColaborador.getFuncao());
        colaborador.setRegimeJornadaTrabalho(preCadastroColaborador.getRegimeJornada());
        colaborador.setQtdadeValeTransportes(preCadastroColaborador.getQtdadeValeTransporte());
        colaborador.setDiasExperiencia(preCadastroColaborador.getDiasExperiencia());
        colaborador.setPeriodoAdmissao(this.getPeriodoAdmissao(colaborador.getDataAdmissao()));
        colaborador.setOptanteFgts(EnumConstantsMentorSimNao.SIM.getValue());
        colaborador.setPessoa(this.setarCamposPreCadastroPessoa(preCadastroColaborador));
        colaborador.setRecebimentoSeguroDesemprego(ToolMethods.isNotNull((Object)preCadastroColaborador.getRecebimentoSeguroDesemprego()) != false && ToolMethods.isEquals((Object)preCadastroColaborador.getRecebimentoSeguroDesemprego(), (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? EnumConstantsMentorSimNao.SIM.getValue() : EnumConstantsMentorSimNao.NAO.getValue());
        colaborador.setHorarioTrabalho(preCadastroColaborador.getHorarioTrabalho());
        return colaborador;
    }

    private String getPeriodoAdmissao(Date dataAdmissao) {
        String strDataAdmissao = ToolDate.dateToStr((Date)dataAdmissao);
        return strDataAdmissao.substring(3, strDataAdmissao.length());
    }

    private Pessoa setarCamposPreCadastroPessoa(PreCadastroColaborador preCadastroColaborador) {
        Pessoa pessoa = new Pessoa();
        if (ToolMethods.isNotNull((Object)preCadastroColaborador.getEndereco()).booleanValue()) {
            pessoa.setEndereco(preCadastroColaborador.getEndereco());
        }
        pessoa.setNome(preCadastroColaborador.getNome());
        pessoa.setComplemento(this.setarCamposPreCadastroComplemento(preCadastroColaborador));
        return pessoa;
    }

    private Complemento setarCamposPreCadastroComplemento(PreCadastroColaborador preCadastroColaborador) {
        Complemento complemento = new Complemento();
        complemento.setCnpj(ToolString.refina((String)preCadastroColaborador.getCpf()));
        complemento.setRg(preCadastroColaborador.getRg());
        complemento.setOrgaoEmissor(preCadastroColaborador.getOrgaoExpedidorRG());
        complemento.setEmailPrincipal(preCadastroColaborador.getEmail());
        complemento.setFone1(preCadastroColaborador.getTelefoneContato());
        complemento.setCel1(preCadastroColaborador.getCelular());
        complemento.setDataNascimento(preCadastroColaborador.getDataNascimento());
        return complemento;
    }

    public Date getDataVigenciaFinalDepIRRF(Date dataNascimento) {
        return ToolDate.nextYear((Date)dataNascimento, (int)ConstantsColaborador.IDADE_DEP_IRRF);
    }

    public Date getDataVigenciaFinalSalFam(Date dataNascimento) {
        return ToolDate.nextYear((Date)dataNascimento, (int)ConstantsColaborador.IDADE_DEP_SAL_FAM);
    }
}

