/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.examples.vo;

import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.model.examples.DefaultEntitiesTest;
import com.touchcomp.basementor.model.examples.vo.CentroCustoTest;
import com.touchcomp.basementor.model.examples.vo.CentroEstoqueTest;
import com.touchcomp.basementor.model.examples.vo.ControleEntregaEquipamentoTest;
import com.touchcomp.basementor.model.examples.vo.EmpresaTest;
import com.touchcomp.basementor.model.examples.vo.GradeCorTest;
import com.touchcomp.basementor.model.examples.vo.ItemComunicadoProducaoTest;
import com.touchcomp.basementor.model.examples.vo.LoteFabricacaoTest;
import com.touchcomp.basementor.model.examples.vo.NaturezaRequisicaoTest;
import com.touchcomp.basementor.model.examples.vo.NotaFiscalTerceirosTest;
import com.touchcomp.basementor.model.examples.vo.PessoaTest;
import com.touchcomp.basementor.model.examples.vo.PlanoContaGerencialTest;
import com.touchcomp.basementor.model.examples.vo.ProdutoTest;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemConsumoAtivo;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ConsumoAtivoTest
extends DefaultEntitiesTest<ConsumoAtivo> {
    @Override
    public ConsumoAtivo getDefault() {
        ConsumoAtivo vo = new ConsumoAtivo();
        vo.setIdentificador(0L);
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setDataAtualizacao(this.dataHoraAtualSQL());
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setDataMovimentacao(this.dataHoraAtual());
        vo.setObservacao("teste");
        vo.setNrDocOrigem(0L);
        vo.setHodometro(0.0);
        vo.setHodometroAnterior(0.0);
        vo.setCodigoCTF("teste");
        vo.setSolicitante((Pessoa)this.getDefaultTest(PessoaTest.class));
        vo.setDataConsumo(this.dataHoraAtual());
        vo.setGerarColeta((short)0);
        vo.setDataHoraColeta(this.dataHoraAtualSQL());
        vo.setValorColeta(0);
        vo.setColeta(this.getColeta(vo));
        return vo;
    }

    private Requisicao getRequisicao(ConsumoAtivo param) {
        Requisicao vo = new Requisicao();
        vo.setIdentificador(0L);
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setDataAtualizacao(this.dataHoraAtualSQL());
        vo.setDataRequisicao(this.dataHoraAtual());
        vo.setNotaFiscalTerc((NotaFiscalTerceiros)this.getDefaultTest(NotaFiscalTerceirosTest.class));
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setItensRequisicao(this.getItensRequisicao(vo));
        vo.setObservacao("teste");
        vo.setTipoRequisicao((short)0);
        vo.setItemComunicadoProducao((ItemComunicadoProducao)this.getDefaultTest(ItemComunicadoProducaoTest.class));
        vo.setControleEntregaEquipamento((ControleEntregaEquipamento)this.getDefaultTest(ControleEntregaEquipamentoTest.class));
        return vo;
    }

    private List<ItemRequisicao> getItensRequisicao(Requisicao param) {
        ItemRequisicao vo = new ItemRequisicao();
        vo.setIdentificador(0L);
        vo.setRequisicao(param);
        vo.setProduto((Produto)this.getDefaultTest(ProdutoTest.class));
        vo.setQuantidadeTotal(0.0);
        vo.setCentroCusto((CentroCusto)this.getDefaultTest(CentroCustoTest.class));
        vo.setGradeItemRequisicao(this.getGradeItemRequisicao(vo));
        vo.setCentroEstoque((CentroEstoque)this.getDefaultTest(CentroEstoqueTest.class));
        vo.setNaturezaRequisicao((NaturezaRequisicao)this.getDefaultTest(NaturezaRequisicaoTest.class));
        vo.setProdutoSubstituto((Produto)this.getDefaultTest(ProdutoTest.class));
        vo.setObservacoes("teste");
        vo.setValorPrecoMedioCont(0.0);
        return this.toList(vo);
    }

    private List<GradeItemRequisicao> getGradeItemRequisicao(ItemRequisicao param) {
        GradeItemRequisicao vo = new GradeItemRequisicao();
        vo.setIdentificador(0L);
        vo.setQuantidade(0.0);
        vo.setGradeCor((GradeCor)this.getDefaultTest(GradeCorTest.class));
        vo.setLoteFabricacao((LoteFabricacao)this.getDefaultTest(LoteFabricacaoTest.class));
        vo.setItemRequisicao(param);
        vo.setDataMovimentacao(this.dataHoraAtual());
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setCentroEstoque((CentroEstoque)this.getDefaultTest(CentroEstoqueTest.class));
        return this.toList(vo);
    }

    private List<ItemConsumoAtivo> getItemConsumoAtivo(ConsumoAtivo param) {
        ItemConsumoAtivo vo = new ItemConsumoAtivo();
        vo.setIdentificador(0L);
        vo.setMovInterno((short)0);
        vo.setValorUnitario(0.0);
        vo.setValorDesconto(0.0);
        vo.setValorTotal(0.0);
        vo.setQuantidadeTotal(0.0);
        vo.setCentroCusto((CentroCusto)this.getDefaultTest(CentroCustoTest.class));
        vo.setCentroEstoque((CentroEstoque)this.getDefaultTest(CentroEstoqueTest.class));
        vo.setProduto((Produto)this.getDefaultTest(ProdutoTest.class));
        vo.setNaturezaRequisicao((NaturezaRequisicao)this.getDefaultTest(NaturezaRequisicaoTest.class));
        vo.setGradeItemConsumoAtivo(this.getGradeItemConsumoAtivo(vo));
        vo.setConsumoAtivo(param);
        vo.setLancamentoCtbGerencial(this.getLancamentoCtbGerencial(vo));
        vo.setGerarPagamentoAgregado((short)0);
        return this.toList(vo);
    }

    private List<GradeItemConsumoAtivo> getGradeItemConsumoAtivo(ItemConsumoAtivo param) {
        GradeItemConsumoAtivo vo = new GradeItemConsumoAtivo();
        vo.setIdentificador(0L);
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setQuantidade(0.0);
        vo.setGradeCor((GradeCor)this.getDefaultTest(GradeCorTest.class));
        vo.setLoteFabricacao((LoteFabricacao)this.getDefaultTest(LoteFabricacaoTest.class));
        vo.setItemConsumoAtivo(param);
        return this.toList(vo);
    }

    private LancamentoCtbGerencial getLancamentoCtbGerencial(ItemConsumoAtivo param) {
        LancamentoCtbGerencial vo = new LancamentoCtbGerencial();
        vo.setIdentificador(0L);
        vo.setDebCred((short)0);
        vo.setValor(0.0);
        vo.setHistorico("teste");
        vo.setCentroCusto((CentroCusto)this.getDefaultTest(CentroCustoTest.class));
        vo.setPlanoContaGerencial((PlanoContaGerencial)this.getDefaultTest(PlanoContaGerencialTest.class));
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setDataAtualizacao(this.dataHoraAtualSQL());
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setGerado((short)0);
        vo.setProvRealizado((short)0);
        vo.setTipoLancamento((short)0);
        vo.setDataPrevista(this.dataHoraAtual());
        vo.setIdLancOrigem(0L);
        return vo;
    }

    private Coleta getColeta(ConsumoAtivo param) {
        Coleta vo = new Coleta();
        vo.setIdentificador(0L);
        vo.setEmpresa((Empresa)this.getDefaultTest(EmpresaTest.class));
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setDataHoraColeta(this.dataHoraAtualSQL());
        vo.setNumeroColeta(0L);
        vo.setValorColeta(0);
        vo.setValorAcumulado(0);
        vo.setDescricao("teste");
        return vo;
    }

    public ConsumoAtivo buildIdNome(Long id, String nome, int etapaTeste) {
        ConsumoAtivo obj = new ConsumoAtivo();
        obj.setIdentificador(id);
        obj.setDataConsumo(ToolDate.intToDate((Integer)2022, (Integer)1, (Integer)1));
        obj.setDataCadastro(ToolDate.intToDate((Integer)2022, (Integer)1, (Integer)1));
        obj.setEmpresa(new EmpresaTest().getDefault());
        if (etapaTeste == 1) {
            return obj;
        }
        obj.setItemConsumoAtivo(this.getItens(nome, 5L));
        return obj;
    }

    public List<ItemConsumoAtivo> getItens(String nome, Long qtd) {
        ArrayList<ItemConsumoAtivo> list = new ArrayList<ItemConsumoAtivo>();
        Long i = 1L;
        while (i <= qtd) {
            ItemConsumoAtivo il = new ItemConsumoAtivo();
            if (i % 2L == 1L) {
                il.setMovInterno(EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO.getValue());
            } else {
                il.setMovInterno(EnumConstTipoMovimentoConsumo.CONSUMO_EXTERNO.getValue());
            }
            il.setGradeItemConsumoAtivo(this.getGradesItem(il, i, i.doubleValue(), nome));
            il.setCentroEstoque(new CentroEstoqueTest().buildIdNome(i, nome));
            il.setProduto(new ProdutoTest().buildIdNome(i, nome));
            il.setCentroCusto(new CentroCustoTest().buildIdNome(i, nome));
            list.add(il);
            Long l = i;
            i = i + 1L;
        }
        return list;
    }

    public List<GradeItemConsumoAtivo> getGradesItem(ItemConsumoAtivo i, Long id, Double qtd, String nome) {
        GradeItemConsumoAtivo g = new GradeItemConsumoAtivo();
        g.setIdentificador(id);
        g.setQuantidade(qtd);
        g.setItemConsumoAtivo(i);
        g.setGradeCor(new GradeCorTest().buildIdNome(id, nome));
        g.setLoteFabricacao(new LoteFabricacaoTest().buildIdNome(id, nome));
        return Arrays.asList(g);
    }
}

