/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.examples.vo;

import com.touchcomp.basementor.model.examples.DefaultEntitiesTest;
import com.touchcomp.basementor.model.examples.vo.CentroResultadoContFinTest;
import com.touchcomp.basementor.model.examples.vo.CnaeTest;
import com.touchcomp.basementor.model.examples.vo.PessoaTest;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RegimeTributario;

public class EmpresaTest
extends DefaultEntitiesTest<Empresa> {
    @Override
    public Empresa getDefault() {
        Empresa e = new Empresa();
        e.setDataAtualizacao(this.dataHoraAtualSQL());
        e.setDataUltModificacao(this.dataHoraAtual());
        e.setEmpresaDados(this.getEmpresaDados(e));
        e.setIdentificador(1L);
        e.setPessoa((Pessoa)this.getDefaultTest(PessoaEmpresaTest.class));
        e.setSiglaEmpresa("TOUCH");
        return e;
    }

    private EmpresaDados getEmpresaDados(Empresa e) {
        EmpresaDados ed = new EmpresaDados();
        ed.setCentroResultadoContFin((CentroResultadoContFin)this.getDefaultTest(CentroResultadoContFinTest.class));
        ed.setGrupoEmpresa(this.getGrupoEmpresa(ed));
        ed.setCnae(new CnaeTest().getDefault());
        ed.setRegimeTributario(this.getRegimeTributario());
        ed.setMatriz((short)1);
        return ed;
    }

    public GrupoEmpresa getGrupoEmpresa(EmpresaDados emp) {
        GrupoEmpresa vo = new GrupoEmpresa();
        vo.setDataAtualizacao(this.dataHoraAtualSQL());
        vo.setDataCadastro(this.dataHoraAtual());
        vo.setDescricao("teste");
        vo.setEmpresas(this.toList(emp));
        vo.setIdentificador(0L);
        vo.setSociedadesContaParticipacao(this.toList(new PessoaTest().getDefault()));
        return vo;
    }

    public RegimeTributario getRegimeTributario() {
        RegimeTributario r = new RegimeTributario();
        r.setCodigo(1345);
        return r;
    }

    public static class PessoaEmpresaTest
    extends PessoaTest {
        @Override
        public Pessoa getDefault() {
            Pessoa p = super.getDefault();
            p.setNome("Touch Comp Sistemas LTDA");
            p.setNomeFantasia("Touch");
            return p;
        }
    }
}

