/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.examples.vo;

import com.touchcomp.basementor.model.examples.DefaultEntitiesTest;
import com.touchcomp.basementor.model.examples.vo.EmpresaTest;
import com.touchcomp.basementor.model.examples.vo.IndiceGerencialTest;
import com.touchcomp.basementor.model.examples.vo.IntervaloControleGerencialTest;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentaria;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPer;
import com.touchcomp.basementor.model.vo.EstruturaOrcamentariaPerLinha;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.IntervaloControleGerPer;
import com.touchcomp.basementor.model.vo.LinhasIndiceGerencial;
import java.util.LinkedList;
import java.util.List;

public class EstruturaOrcamentariaTest
extends DefaultEntitiesTest<EstruturaOrcamentaria> {
    @Override
    public EstruturaOrcamentaria getDefault() {
        EstruturaOrcamentaria p = new EstruturaOrcamentaria();
        p.setDataAtualizacao(this.dataHoraAtualSQL());
        p.setDataCadastro(this.dataHoraAtual());
        p.setDescricao("Estrutura Orcamentaria");
        p.setIdentificador(1L);
        p.setIndiceGerencial((IndiceGerencial)this.getDefaultTest(IndiceGerencialTest.class));
        p.setIntervaloControleGer((IntervaloControleGer)this.getDefaultTest(IntervaloControleGerencialTest.class));
        p.setObservacao("OBS");
        p.setRevisao("Revisao 1");
        p.setTravarEstrutura((short)0);
        p.setEstruturaOrcamentariaPeriodos(this.getPeriodos(p));
        p.setEmpresa(new EmpresaTest().getDefault());
        return p;
    }

    private List<EstruturaOrcamentariaPer> getPeriodos(EstruturaOrcamentaria p) {
        LinkedList<EstruturaOrcamentariaPer> ret = new LinkedList<EstruturaOrcamentariaPer>();
        for (IntervaloControleGerPer intervalo : p.getIntervaloControleGer().getIntervalos()) {
            EstruturaOrcamentariaPer est = new EstruturaOrcamentariaPer();
            est.setEstruturaOrcamentaria(p);
            est.setIdentificador(1L);
            est.setIntervaloControleGerPer(intervalo);
            est.setEstruturaOrcamentariaPeriodos(this.getValores(est));
            ret.add(est);
        }
        return ret;
    }

    private List<EstruturaOrcamentariaPerLinha> getValores(EstruturaOrcamentariaPer est) {
        LinkedList<EstruturaOrcamentariaPerLinha> ret = new LinkedList<EstruturaOrcamentariaPerLinha>();
        for (LinhasIndiceGerencial linha : est.getEstruturaOrcamentaria().getIndiceGerencial().getLinhas()) {
            EstruturaOrcamentariaPerLinha es = new EstruturaOrcamentariaPerLinha();
            es.setDataAtualizacaoLinhaInd(linha.getDataAtualizacao());
            es.setEstruturaOrcamentariaPer(est);
            es.setIdentificador(1L);
            es.setLinhaIndiceGerencial(linha);
            es.setValorCalculado(100.0);
            ret.add(es);
        }
        return ret;
    }
}

