/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementor.model.vo.TipoPagamentoFolha;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ABERTURA_PERIODO", uniqueConstraints={@UniqueConstraint(name="UNQ1_ABERTURA_PERIODO", columnNames={"INDICE", "DATA_INICIAL", "DATA_FINAL", "ID_EMPRESA"})})
public class AberturaPeriodo
implements InterfaceVO {
    private Long identificador;
    private TipoCalculo tipoCalculo;
    private Date dataInicio;
    private Date dataFinal;
    private Date dataPagamento;
    private Double percCalculo = 100.0;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short indice = 0;
    private List<MovimentoFolha> movimentoFolha = new ArrayList<MovimentoFolha>();
    private Double numeroFeriados = 0.0;
    private Double numeroFolgas = 0.0;
    private Double numeroDiasUteis = 0.0;
    private Date periodoApuracao;
    private Short buscarRescisaoComplementar = 0;
    private Short personalizarPesquisa = 0;
    private TipoPagamentoFolha tipoPagamentoFolha;

    @Id
    @Column(nullable=false, name="ID_ABERTURA_PERIODO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ABERTURA_PERIODO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ABERTURA_PERIODO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_INICIAL")
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Column(nullable=false, name="PERC_CALCULO", precision=15, scale=2)
    public Double getPercCalculo() {
        return this.percCalculo;
    }

    public void setPercCalculo(Double percCalculo) {
        this.percCalculo = percCalculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO", foreignKey=@ForeignKey(name="FK_ABERTURA_PERIODO_TP_CALC"))
    public TipoCalculo getTipoCalculo() {
        return this.tipoCalculo;
    }

    public void setTipoCalculo(TipoCalculo tipoCalculo) {
        this.tipoCalculo = tipoCalculo;
    }

    @Column(nullable=false, name="INDICE")
    public Short getIndice() {
        return this.indice;
    }

    public void setIndice(Short indice) {
        this.indice = indice;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getTipoPagamentoFolha() == null || !this.getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
            return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.indice, this.getTipoCalculo(), ToolDate.dateToStr((Date)this.dataInicio)});
        }
        return ToolBaseMethodsVO.toString((String)"{0} - {1} {2}", (Object[])new Object[]{this.indice, this.getTipoPagamentoFolha(), ToolDate.dateToStr((Date)this.dataInicio)});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="aberturaPeriodo", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<MovimentoFolha> getMovimentoFolha() {
        return this.movimentoFolha;
    }

    public void setMovimentoFolha(List<MovimentoFolha> movimentoFolha) {
        this.movimentoFolha = movimentoFolha;
    }

    @Column(name="NUMERO_DIAS_FERIADOS", precision=5, scale=2)
    public Double getNumeroFeriados() {
        return this.numeroFeriados;
    }

    public void setNumeroFeriados(Double numeroFeriado) {
        this.numeroFeriados = numeroFeriado;
    }

    @Column(name="NUMERO_DIAS_FOLGAS", precision=5, scale=2)
    public Double getNumeroFolgas() {
        return this.numeroFolgas;
    }

    public void setNumeroFolgas(Double numeroFolgas) {
        this.numeroFolgas = numeroFolgas;
    }

    @Column(name="NUMERO_DIAS_UTEIS")
    public Double getNumeroDiasUteis() {
        return this.numeroDiasUteis;
    }

    public void setNumeroDiasUteis(Double numeroDiasUteis) {
        this.numeroDiasUteis = numeroDiasUteis;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_APURACAO")
    public Date getPeriodoApuracao() {
        return this.periodoApuracao;
    }

    public void setPeriodoApuracao(Date periodoApuracao) {
        this.periodoApuracao = periodoApuracao;
    }

    @Column(name="BUSCAR_RESCISAO_COMPLEMENTAR")
    public Short getBuscarRescisaoComplementar() {
        return this.buscarRescisaoComplementar;
    }

    public void setBuscarRescisaoComplementar(Short buscarRescisaoComplementar) {
        this.buscarRescisaoComplementar = buscarRescisaoComplementar;
    }

    @Column(name="PERSONALIZAR_PESQUISA")
    public Short getPersonalizarPesquisa() {
        return this.personalizarPesquisa;
    }

    public void setPersonalizarPesquisa(Short personalizarPesquisa) {
        this.personalizarPesquisa = personalizarPesquisa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_FOLHA", foreignKey=@ForeignKey(name="FK_ABERTURA_PERIODO_TP_PAG"))
    public TipoPagamentoFolha getTipoPagamentoFolha() {
        return this.tipoPagamentoFolha;
    }

    public void setTipoPagamentoFolha(TipoPagamentoFolha tipoPagamentoFolha) {
        this.tipoPagamentoFolha = tipoPagamentoFolha;
    }
}

