/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FechamAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.IntegAdiantViagemAdiantViagem;
import com.touchcomp.basementor.model.vo.ParametrizacaoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ADIANTAMENTO_VIAGEM")
public class AdiantamentoViagem
implements InterfaceVO {
    private Long identificador;
    private Date dataEmissao;
    private Double valorAdiantamento = 0.0;
    private ConjuntoTransportador conjuntoTransportador;
    private String observacao;
    private Date dataFechamento;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<FechamAdiantamentoViagem> fechamAdiantamentoViagem = new ArrayList<FechamAdiantamentoViagem>();
    private Double valorSaldoAnterior = 0.0;
    private Double valorDespesaTotal = 0.0;
    private Pessoa pessoa;
    private PlanoConta planoConta;
    private PlanoContaGerencial planoContaGerencial;
    private Titulo titulo;
    private IntegAdiantViagemAdiantViagem integAdiantViagemAdiantViagem;
    private Titulo tituloFechamento;
    private CentroCusto centroCusto;
    private Date dataPrevFechamento;
    private ParametrizacaoAdiantamentoViagem parametrizacaoAdiantViagem;

    @Id
    @Column(nullable=false, name="ID_ADIANTAMENTO_VIAGEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ADIANTAMENTO_VIAGEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @Column(nullable=false, name="VALOR_ADIANTAMENTO", precision=12, scale=2)
    public Double getValorAdiantamento() {
        return this.valorAdiantamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_CONJ_TRA"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    @Column(nullable=false, name="VALOR_DESPESA_TOTAL", precision=15, scale=2)
    public Double getValorDespesaTotal() {
        return this.valorDespesaTotal;
    }

    public void setValorDespesaTotal(Double valorDespesaTotal) {
        this.valorDespesaTotal = valorDespesaTotal;
    }

    @Column(name="OBSERVACAO", length=250)
    public String getObservacao() {
        return this.observacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=true, name="DATA_FECHAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PREV_FECHAMENTO")
    public Date getDataPrevFechamento() {
        return this.dataPrevFechamento;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public void setValorAdiantamento(Double valorAdiantamento) {
        this.valorAdiantamento = valorAdiantamento;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataPrevFechamento(Date dataPrevFechamento) {
        this.dataPrevFechamento = dataPrevFechamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getPessoa() != null ? this.getPessoa().getNome() : this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="adiantamentoViagem", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FechamAdiantamentoViagem> getFechamAdiantamentoViagem() {
        return this.fechamAdiantamentoViagem;
    }

    public void setFechamAdiantamentoViagem(List<FechamAdiantamentoViagem> fechamAdiantamentoViagem) {
        this.fechamAdiantamentoViagem = fechamAdiantamentoViagem;
    }

    @Column(nullable=false, name="VALOR_SALDO_ANTERIOR", precision=15, scale=2)
    public Double getValorSaldoAnterior() {
        return this.valorSaldoAnterior;
    }

    public void setValorSaldoAnterior(Double valorSaldoAnterior) {
        this.valorSaldoAnterior = valorSaldoAnterior;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_PC"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_PC_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @OneToOne(mappedBy="adiantamentoViagem", cascade={CascadeType.ALL, CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    @OneToOne(mappedBy="adiantamentoViagemFechamento", cascade={CascadeType.ALL, CascadeType.PERSIST}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Titulo getTituloFechamento() {
        return this.tituloFechamento;
    }

    public void setTituloFechamento(Titulo tituloFechamento) {
        this.tituloFechamento = tituloFechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_C_C"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @OneToOne(mappedBy="adiantamentoViagem")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public IntegAdiantViagemAdiantViagem getIntegAdiantViagemAdiantViagem() {
        return this.integAdiantViagemAdiantViagem;
    }

    public void setIntegAdiantViagemAdiantViagem(IntegAdiantViagemAdiantViagem integAdiantViagemAdiantViagem) {
        this.integAdiantViagemAdiantViagem = integAdiantViagemAdiantViagem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PARAM_ADIANTAMENTO_VIAGEM", foreignKey=@ForeignKey(name="FK_ADIANTAMENTO_VIAGEM_PARAM_AV"))
    public ParametrizacaoAdiantamentoViagem getParametrizacaoAdiantViagem() {
        return this.parametrizacaoAdiantViagem;
    }

    public void setParametrizacaoAdiantViagem(ParametrizacaoAdiantamentoViagem parametrizacaoAdiantViagem) {
        this.parametrizacaoAdiantViagem = parametrizacaoAdiantViagem;
    }
}

