/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="AGENCIA_VALORES")
public class AgenciaValores
implements InterfaceVO {
    private Long identificador;
    private InstituicaoValores instituicaoValor;
    private Pessoa pessoa;
    private String nrAgencia;
    private String dvAgencia;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<ContaValores> contaValores = new ArrayList<ContaValores>();
    private String modeloFormularioContinuoTXT;
    private String modeloFolhaSoltaTXT;
    private Short tipoImpressaoCheque = 0;
    private String portaImpressora;

    @Id
    @Column(nullable=false, name="ID_AGENCIA_VALOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_AGENCIA_VALORES")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_AGENCIA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_VALOR", foreignKey=@ForeignKey(name="FK_AGENCIA_VALOR_INST_VALORES"))
    public InstituicaoValores getInstituicaoValor() {
        return this.instituicaoValor;
    }

    public void setInstituicaoValor(InstituicaoValores instituicaoValor) {
        this.instituicaoValor = instituicaoValor;
    }

    @Column(name="DV_AGENCIA", length=20)
    public String getDvAgencia() {
        return this.dvAgencia;
    }

    public void setDvAgencia(String nomeAgencia) {
        this.dvAgencia = nomeAgencia;
    }

    @Column(name="NR_AGENCIA", length=20)
    public String getNrAgencia() {
        return this.nrAgencia;
    }

    public void setNrAgencia(String nrAgencia) {
        this.nrAgencia = nrAgencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_AGENCIA_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getNrAgencia(), this.getNrAgencia()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="agenciaValor", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<ContaValores> getContaValores() {
        return this.contaValores;
    }

    public void setContaValores(List<ContaValores> contaValores) {
        this.contaValores = contaValores;
    }

    @Column(name="MODELO_FORM_CONT_TXT", length=5000)
    public String getModeloFormularioContinuoTXT() {
        return this.modeloFormularioContinuoTXT;
    }

    public void setModeloFormularioContinuoTXT(String modeloFormularioContinuoTXT) {
        this.modeloFormularioContinuoTXT = modeloFormularioContinuoTXT;
    }

    @Column(name="MODELO_FOLHA_SOLTA_TXT", length=5000)
    public String getModeloFolhaSoltaTXT() {
        return this.modeloFolhaSoltaTXT;
    }

    public void setModeloFolhaSoltaTXT(String modeloFolhaSoltaTXT) {
        this.modeloFolhaSoltaTXT = modeloFolhaSoltaTXT;
    }

    @Column(name="TIPO_IMPRESSAO_CHEQUE")
    public Short getTipoImpressaoCheque() {
        return this.tipoImpressaoCheque;
    }

    public void setTipoImpressaoCheque(Short tipoImpressaoCheque) {
        this.tipoImpressaoCheque = tipoImpressaoCheque;
    }

    @Column(name="PORTA_IMPRESSORA")
    public String getPortaImpressora() {
        return this.portaImpressora;
    }

    public void setPortaImpressora(String portaImpressora) {
        this.portaImpressora = portaImpressora;
    }
}

