/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="ALIQUOTA_ST", uniqueConstraints={@UniqueConstraint(name="UNQ1_ALIQUOTA_ST", columnNames={"ID_CATEGORIA_ST", "ID_UF"})})
public class AliquotaSt
implements InterfaceVO {
    private Long identificador;
    private Double aliquotaIcms = 0.0;
    private Double descontoPadrao = 0.0;
    private Double indiceAlteracao = 0.0;
    private CategoriaSt categoriaSt;
    private UnidadeFederativa unidadeFederativa;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private PlanoConta planoConta;
    private Double aliquotaIcmsGnre = 0.0;

    @Id
    @Column(name="ID_ALIQUOTA_ST")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ALIQUOTA_ST")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="ALIQUOTA_ICMS", precision=15, scale=2)
    public Double getAliquotaIcms() {
        return this.aliquotaIcms;
    }

    @Column(name="DESCONTO_PADRAO", precision=15, scale=2)
    public Double getDescontoPadrao() {
        return this.descontoPadrao;
    }

    @Column(name="INDICE_ALTERACAO", precision=15, scale=6)
    public Double getIndiceAlteracao() {
        return this.indiceAlteracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_ST", foreignKey=@ForeignKey(name="FK_ALIQUOTA_ST_CAT_ST"))
    public CategoriaSt getCategoriaSt() {
        return this.categoriaSt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UF", foreignKey=@ForeignKey(name="FK_ALIQUOTA_ST_UF"))
    public UnidadeFederativa getUnidadeFederativa() {
        return this.unidadeFederativa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ALIQUOTA_ST_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setCategoriaSt(CategoriaSt categoriaSt) {
        this.categoriaSt = categoriaSt;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setUnidadeFederativa(UnidadeFederativa uf) {
        this.unidadeFederativa = uf;
    }

    public void setIdentificador(Long idAliquotaSt) {
        this.identificador = idAliquotaSt;
    }

    public void setAliquotaIcms(Double aliquotaIcms) {
        this.aliquotaIcms = aliquotaIcms;
    }

    public void setDescontoPadrao(Double descontoPadrao) {
        this.descontoPadrao = descontoPadrao;
    }

    public void setIndiceAlteracao(Double indiceAlteracao) {
        this.indiceAlteracao = indiceAlteracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_ALIQUOTA_ST_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @Column(name="ALIQUOTA_ICMS_GNRE", precision=15, scale=2)
    public Double getAliquotaIcmsGnre() {
        return this.aliquotaIcmsGnre;
    }

    public void setAliquotaIcmsGnre(Double aliquotaIcmsGnre) {
        this.aliquotaIcmsGnre = aliquotaIcmsGnre;
    }
}

