/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteBaixasPag;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteTitulosFat;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentanteTitulosVenc;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APURACAO_COMISSAO_REP")
public class ApuracaoComissaoRepresentante
implements InterfaceVO {
    private Long identificador;
    private Double vrComissaoFaturamento = 0.0;
    private Double vrComissaoVendaNFCe = 0.0;
    private Double vrComissaoVendaNFCeNFe = 0.0;
    private Double vrComissaoVencimento = 0.0;
    private Double vrComissaoPagamento = 0.0;
    private Representante representante;
    private Titulo tituloGerado;
    private Date dataInicial;
    private Date dataFinal;
    private Date dataCadastro;
    private Empresa empresa;
    private Double comissaoFaturamento = 0.0;
    private Double comissaoVencimento = 0.0;
    private Double comissaoPagamento = 0.0;
    private Double valorDebito = 0.0;
    private Double valorCredito = 0.0;
    private Double valorLiquido = 0.0;
    private List<LancamentoComissaoRepresentante> lancamentosComissaoRepresentante;
    private Date dataLancamentoDebito;
    private Short titulosPercComissaoZerados = 0;
    private short gerarTituloIrrf = 0;
    private Titulo tituloIrrf;
    private List<ApuracaoComissaoRepresentanteBaixasPag> baixasPagamento = new ArrayList<ApuracaoComissaoRepresentanteBaixasPag>();
    private List<ApuracaoComissaoRepresentanteTitulosFat> titulosFaturamento = new ArrayList<ApuracaoComissaoRepresentanteTitulosFat>();
    private List<ApuracaoComissaoRepresentanteTitulosVenc> titulosVencimento = new ArrayList<ApuracaoComissaoRepresentanteTitulosVenc>();
    private LancamentoComissaoRepresentante lancamentoDebito;
    private Short consMovManualEstornoPeriodo = 0;
    private Short gerarTituloAntecipado = 0;
    private PlanoConta planoContaTituloAntecipado;
    private Short gerarTituloIndenizatorio = 0;
    private Titulo tituloIndenizatorio;
    private Short ignorarFiltrosNFCe = 0;

    public ApuracaoComissaoRepresentante() {
        this.lancamentosComissaoRepresentante = new ArrayList<LancamentoComissaoRepresentante>();
    }

    @Id
    @Column(name="ID_APURACAO_COMISSAO_REP")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APURACAO_COMISSAO_REP")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="VR_COMISSAO_FATURAMENTO", precision=15, scale=2)
    public Double getVrComissaoFaturamento() {
        return this.vrComissaoFaturamento;
    }

    public void setVrComissaoFaturamento(Double vrComissaoFaturamento) {
        this.vrComissaoFaturamento = vrComissaoFaturamento;
    }

    @Column(nullable=false, name="VR_COMISSAO_VENCIMENTO", precision=15, scale=2)
    public Double getVrComissaoVencimento() {
        return this.vrComissaoVencimento;
    }

    public void setVrComissaoVencimento(Double vrComissaoVencimento) {
        this.vrComissaoVencimento = vrComissaoVencimento;
    }

    @Column(nullable=false, name="VR_COMISSAO_PAGAMENTO", precision=15, scale=2)
    public Double getVrComissaoPagamento() {
        return this.vrComissaoPagamento;
    }

    public void setVrComissaoPagamento(Double vrComissaoPagamento) {
        this.vrComissaoPagamento = vrComissaoPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_AP_COMISSAO_REP_REP"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_AP_COMISSAO_REP_TITULO"))
    public Titulo getTituloGerado() {
        return this.tituloGerado;
    }

    public void setTituloGerado(Titulo tituloGerado) {
        this.tituloGerado = tituloGerado;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_AP_COMISSAO_REP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="PERC_FATURAMENTO", precision=15, scale=2)
    public Double getComissaoFaturamento() {
        return this.comissaoFaturamento;
    }

    public void setComissaoFaturamento(Double comissaoFaturamento) {
        this.comissaoFaturamento = comissaoFaturamento;
    }

    @Column(nullable=false, name="PERC_VENCIMENTO", precision=15, scale=2)
    public Double getComissaoVencimento() {
        return this.comissaoVencimento;
    }

    public void setComissaoVencimento(Double comissaoVencimento) {
        this.comissaoVencimento = comissaoVencimento;
    }

    @Column(nullable=false, name="PERC_PAGAMENTO", precision=15, scale=2)
    public Double getComissaoPagamento() {
        return this.comissaoPagamento;
    }

    public void setComissaoPagamento(Double comissaoPagamento) {
        this.comissaoPagamento = comissaoPagamento;
    }

    @Column(nullable=false, name="VALOR_DEBITO", precision=15, scale=2)
    public Double getValorDebito() {
        return this.valorDebito;
    }

    public void setValorDebito(Double valorDebito) {
        this.valorDebito = valorDebito;
    }

    @Column(nullable=false, name="VALOR_CREDITO", precision=15, scale=2)
    public Double getValorCredito() {
        return this.valorCredito;
    }

    public void setValorCredito(Double valorCredito) {
        this.valorCredito = valorCredito;
    }

    @Column(nullable=false, name="VALOR_LIQUIDO", precision=15, scale=2)
    public Double getValorLiquido() {
        return this.valorLiquido;
    }

    public void setValorLiquido(Double valorLiquido) {
        this.valorLiquido = valorLiquido;
    }

    @OneToMany(mappedBy="apuracaoComissaoRepresentante", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    public List<LancamentoComissaoRepresentante> getLancamentosComissaoRepresentante() {
        return this.lancamentosComissaoRepresentante;
    }

    public void setLancamentosComissaoRepresentante(List<LancamentoComissaoRepresentante> lancamentosComissaoRepresentante) {
        this.lancamentosComissaoRepresentante = lancamentosComissaoRepresentante;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LANC_DEB")
    public Date getDataLancamentoDebito() {
        return this.dataLancamentoDebito;
    }

    public void setDataLancamentoDebito(Date dataLancamentoDebito) {
        this.dataLancamentoDebito = dataLancamentoDebito;
    }

    @Column(name="TITULOS_PERC_COM_ZERADOS")
    public Short getTitulosPercComissaoZerados() {
        return this.titulosPercComissaoZerados;
    }

    public void setTitulosPercComissaoZerados(Short titulosPercComissaoZerados) {
        this.titulosPercComissaoZerados = titulosPercComissaoZerados;
    }

    @Column(name="CONS_MOV_MANUAL_ESTORNO_PERIODO")
    public Short getConsMovManualEstornoPeriodo() {
        return this.consMovManualEstornoPeriodo;
    }

    public void setConsMovManualEstornoPeriodo(Short consMovManualEstornoPeriodo) {
        this.consMovManualEstornoPeriodo = consMovManualEstornoPeriodo;
    }

    @Column(name="GERAR_TITULO_ANTECIPADO")
    public Short getGerarTituloAntecipado() {
        return this.gerarTituloAntecipado;
    }

    public void setGerarTituloAntecipado(Short gerarTituloAntecipado) {
        this.gerarTituloAntecipado = gerarTituloAntecipado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_TIT_ANTECIPADO", foreignKey=@ForeignKey(name="FK_AP_PLANO_CONTA_TIT_ANTECIP"))
    public PlanoConta getPlanoContaTituloAntecipado() {
        return this.planoContaTituloAntecipado;
    }

    public void setPlanoContaTituloAntecipado(PlanoConta planoContaTituloAntecipado) {
        this.planoContaTituloAntecipado = planoContaTituloAntecipado;
    }

    @OneToMany(mappedBy="apuracaoComissaoRepresentante", fetch=FetchType.LAZY, targetEntity=ApuracaoComissaoRepresentanteBaixasPag.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ApuracaoComissaoRepresentanteBaixasPag> getBaixasPagamento() {
        return this.baixasPagamento;
    }

    public void setBaixasPagamento(List<ApuracaoComissaoRepresentanteBaixasPag> baixasPagamento) {
        this.baixasPagamento = baixasPagamento;
    }

    @OneToMany(mappedBy="apuracaoComissaoRepresentante", fetch=FetchType.LAZY, targetEntity=ApuracaoComissaoRepresentanteTitulosFat.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ApuracaoComissaoRepresentanteTitulosFat> getTitulosFaturamento() {
        return this.titulosFaturamento;
    }

    public void setTitulosFaturamento(List<ApuracaoComissaoRepresentanteTitulosFat> titulosFaturamento) {
        this.titulosFaturamento = titulosFaturamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} - {2}", (Object[])new Object[]{this.getDataInicial(), this.getDataFinal(), this.getRepresentante() != null ? this.getRepresentante().getPessoa().getNome() : this.getRepresentante()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="apuracaoComissaoRepresentante", fetch=FetchType.LAZY, targetEntity=ApuracaoComissaoRepresentanteTitulosVenc.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ApuracaoComissaoRepresentanteTitulosVenc> getTitulosVencimento() {
        return this.titulosVencimento;
    }

    public void setTitulosVencimento(List<ApuracaoComissaoRepresentanteTitulosVenc> titulosVencimento) {
        this.titulosVencimento = titulosVencimento;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_LANC_COMISSAO_REP_DEBITO", foreignKey=@ForeignKey(name="FK_APUR_COMISSAO_REP_LANC_DEB"))
    public LancamentoComissaoRepresentante getLancamentoDebito() {
        return this.lancamentoDebito;
    }

    public void setLancamentoDebito(LancamentoComissaoRepresentante lancamentoDebito) {
        this.lancamentoDebito = lancamentoDebito;
    }

    @Column(name="VR_COMISSAO_VENDA_NFCE")
    public Double getVrComissaoVendaNFCe() {
        return this.vrComissaoVendaNFCe;
    }

    public void setVrComissaoVendaNFCe(Double vrComissaoVendaNFCe) {
        this.vrComissaoVendaNFCe = vrComissaoVendaNFCe;
    }

    @Column(name="VR_COMISSAO_VENDA_NFCE_NFE")
    public Double getVrComissaoVendaNFCeNFe() {
        return this.vrComissaoVendaNFCeNFe;
    }

    public void setVrComissaoVendaNFCeNFe(Double vrComissaoVendaNFCeNFe) {
        this.vrComissaoVendaNFCeNFe = vrComissaoVendaNFCeNFe;
    }

    @Column(name="TITULO_IRRF")
    public short getGerarTituloIrrf() {
        return this.gerarTituloIrrf;
    }

    public void setGerarTituloIrrf(short gerarTituloIrrf) {
        this.gerarTituloIrrf = gerarTituloIrrf;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID_TITULO_IRRF", foreignKey=@ForeignKey(name="FK_AP_COMISSAO_REP_TITULO_IRRF"))
    public Titulo getTituloIrrf() {
        return this.tituloIrrf;
    }

    public void setTituloIrrf(Titulo tituloIrrf) {
        this.tituloIrrf = tituloIrrf;
    }

    @Column(name="GERAR_TITULO_INDENIZATORIO")
    public Short getGerarTituloIndenizatorio() {
        return this.gerarTituloIndenizatorio;
    }

    public void setGerarTituloIndenizatorio(Short gerarTituloIndenizatorio) {
        this.gerarTituloIndenizatorio = gerarTituloIndenizatorio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="id_titulo_indenizatorio")
    public Titulo getTituloIndenizatorio() {
        return this.tituloIndenizatorio;
    }

    public void setTituloIndenizatorio(Titulo tituloIndenizatorio) {
        this.tituloIndenizatorio = tituloIndenizatorio;
    }

    @Column(name="IGNORAR_FILTROS_NFCE")
    public Short getIgnorarFiltrosNFCe() {
        return this.ignorarFiltrosNFCe;
    }

    public void setIgnorarFiltrosNFCe(Short ignorarFiltrosNFCe) {
        this.ignorarFiltrosNFCe = ignorarFiltrosNFCe;
    }
}

