/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoSimplesNacionalAnexo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APUR_SIMPLES_NACIONAL")
public class ApuracaoSimplesNacional
implements InterfaceVO {
    private Long identificador;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Date periodo;
    private Empresa empresa;
    private Double valorSimplesNacional = 0.0;
    private List<ApuracaoSimplesNacionalAnexo> anexos = new ArrayList<ApuracaoSimplesNacionalAnexo>();
    private Double valorAcumuladoAnterior = 0.0;
    private Double valorAcumuladoAnual = 0.0;
    private Double valorAcimaSublimiteAnual = 0.0;
    private Double fatorR = 0.0;
    private Short calcularTabelaFatorR = 0;

    @Id
    @Column(nullable=false, name="ID_APUR_SIMPLES_NACIONAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APUR_SIMPLES_NACIONAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APUR_SIMPLES_NACIONAL_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="VALOR_SIMPLES_NACIONAL", precision=15, scale=2)
    public Double getValorSimplesNacional() {
        return this.valorSimplesNacional;
    }

    public void setValorSimplesNacional(Double valorSimplesNacional) {
        this.valorSimplesNacional = valorSimplesNacional;
    }

    @OneToMany(mappedBy="apuracaoSimplesNacional", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ApuracaoSimplesNacionalAnexo> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<ApuracaoSimplesNacionalAnexo> anexos) {
        this.anexos = anexos;
    }

    @Column(name="VALOR_ACUMUL_ANTERIOR", precision=15, scale=2)
    public Double getValorAcumuladoAnterior() {
        return this.valorAcumuladoAnterior;
    }

    public void setValorAcumuladoAnterior(Double valorAcumuladoAnterior) {
        this.valorAcumuladoAnterior = valorAcumuladoAnterior;
    }

    @Column(name="VALOR_ACUMUL_ANUAL", precision=15, scale=2)
    public Double getValorAcumuladoAnual() {
        return this.valorAcumuladoAnual;
    }

    public void setValorAcumuladoAnual(Double valorAcumuladoAnual) {
        this.valorAcumuladoAnual = valorAcumuladoAnual;
    }

    @Column(name="VALOR_ACIMA_SUBLIMITE", precision=15, scale=2)
    public Double getValorAcimaSublimiteAnual() {
        return this.valorAcimaSublimiteAnual;
    }

    public void setValorAcimaSublimiteAnual(Double valorAcimaSublimiteAnual) {
        this.valorAcimaSublimiteAnual = valorAcimaSublimiteAnual;
    }

    @Column(name="fator_r", scale=15, precision=2)
    public Double getFatorR() {
        return this.fatorR;
    }

    public void setFatorR(Double fatorR) {
        this.fatorR = fatorR;
    }

    @Column(name="calcular_tabela_fator_r")
    public Short getCalcularTabelaFatorR() {
        return this.calcularTabelaFatorR;
    }

    public void setCalcularTabelaFatorR(Short calcularTabelaFatorR) {
        this.calcularTabelaFatorR = calcularTabelaFatorR;
    }
}

