/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AcuracidadeEstContProdutos;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.EmbalagemProducaoOS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.ItemApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.PreAcuracidadeEst;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.SituacaoDocumento;
import com.touchcomp.basementor.model.vo.SubEspecie;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="APURACIDADE_ESTOQUE")
public class ApuracidadeEstoque
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Date dataApuracidadeEstoque;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private CentroEstoque centroEstoque;
    private CentroCusto centroCusto;
    private ImplantacaoSaldos implantacaoSaldo;
    private Requisicao requisicao;
    private Double apuracidadeTotal = 0.0;
    private List<ItemApuracidadeEstoque> itensApuracidadeEstoque = new ArrayList<ItemApuracidadeEstoque>();
    private List<EmbalagemProducaoOS> embalagemProducaoOS = new ArrayList<EmbalagemProducaoOS>();
    private Especie especie;
    private SubEspecie subEspecie;
    private Short filtrarEspecie = 0;
    private Short filtrarSubEspecie = 0;
    private Short tipoBaixaEstoque = 0;
    private Short tipoEntradaEstoque = 0;
    private List<PreAcuracidadeEst> preAcuracidadeEstoque = new ArrayList<PreAcuracidadeEst>();
    private List<AcuracidadeEstContProdutos> contagemProdutos = new ArrayList<AcuracidadeEstContProdutos>();
    private List<NotaFiscalPropria> notasPerda;
    private List<NotaFiscalPropria> notasEntrada;
    private NaturezaOperacao naturezaOperacaoEntrada;
    private NaturezaOperacao naturezaOperacaoSaida;
    private UnidadeFatCliente unidadeFatCliente;
    private CondicoesPagamento condicoesPagamento;
    private SituacaoDocumento situacaoDocumento;
    private Integer quantidadeItensPorNota;

    public ApuracidadeEstoque() {
        this.setQuantidadeItensPorNota(200);
        this.notasPerda = new ArrayList<NotaFiscalPropria>();
        this.notasEntrada = new ArrayList<NotaFiscalPropria>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_APURACIDADE_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_APURACIDADE_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_APURACIDADE_ESTOQUE")
    public Date getDataApuracidadeEstoque() {
        return this.dataApuracidadeEstoque;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_CEN_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_CEN_CUST"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    @OneToOne(fetch=FetchType.LAZY, targetEntity=ImplantacaoSaldos.class)
    @JoinColumn(name="ID_IMPLANTACAO_SALDO", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_IMP_SALD"))
    public ImplantacaoSaldos getImplantacaoSaldo() {
        return this.implantacaoSaldo;
    }

    @OneToOne(fetch=FetchType.LAZY, targetEntity=Requisicao.class, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_REQUISICAO", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_REQUIS"))
    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    @Column(nullable=false, name="APURACIDADE_TOTAL", precision=15, scale=6)
    public Double getApuracidadeTotal() {
        return this.apuracidadeTotal;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="apuracidadeEstoque", targetEntity=ItemApuracidadeEstoque.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemApuracidadeEstoque> getItensApuracidadeEstoque() {
        return this.itensApuracidadeEstoque;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataApuracidadeEstoque(Date dataApuracidadeEstoque) {
        this.dataApuracidadeEstoque = dataApuracidadeEstoque;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public void setImplantacaoSaldo(ImplantacaoSaldos implantacaoSaldo) {
        this.implantacaoSaldo = implantacaoSaldo;
    }

    public void setRequisicao(Requisicao requisicao) {
        this.requisicao = requisicao;
    }

    public void setApuracidadeTotal(Double apuracidadeTotal) {
        this.apuracidadeTotal = apuracidadeTotal;
    }

    public void setItensApuracidadeEstoque(List<ItemApuracidadeEstoque> itensApuracidadeEstoque) {
        this.itensApuracidadeEstoque = itensApuracidadeEstoque;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataApuracidadeEstoque())});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="APUR_EST_EMB_PROD_OS", joinColumns={@JoinColumn(name="ID_APURACIDADE_ESTOQUE")}, inverseJoinColumns={@JoinColumn(name="ID_EMBALAGEM_PRODUCAO_OS")})
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.REFRESH})
    public List<EmbalagemProducaoOS> getEmbalagemProducaoOS() {
        return this.embalagemProducaoOS;
    }

    public void setEmbalagemProducaoOS(List<EmbalagemProducaoOS> embalagemProducaoOS) {
        this.embalagemProducaoOS = embalagemProducaoOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESPECIE", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_ESPECIE"))
    public Especie getEspecie() {
        return this.especie;
    }

    public void setEspecie(Especie especie) {
        this.especie = especie;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SUB_ESPECIE", foreignKey=@ForeignKey(name="FK_APURACIDADE_ESTOQUE_SUB_ESP"))
    public SubEspecie getSubEspecie() {
        return this.subEspecie;
    }

    public void setSubEspecie(SubEspecie subEspecie) {
        this.subEspecie = subEspecie;
    }

    @Column(name="FILTRAR_ESPECIE")
    public Short getFiltrarEspecie() {
        return this.filtrarEspecie;
    }

    public void setFiltrarEspecie(Short filtrarEspecie) {
        this.filtrarEspecie = filtrarEspecie;
    }

    @Column(name="FILTRAR_SUB_ESPECIE")
    public Short getFiltrarSubEspecie() {
        return this.filtrarSubEspecie;
    }

    public void setFiltrarSubEspecie(Short filtrarSubEspecie) {
        this.filtrarSubEspecie = filtrarSubEspecie;
    }

    @Column(name="TIPO_BAIXA_ESTOQUE")
    public Short getTipoBaixaEstoque() {
        return this.tipoBaixaEstoque;
    }

    public void setTipoBaixaEstoque(Short tipoBaixaEstoque) {
        this.tipoBaixaEstoque = tipoBaixaEstoque;
    }

    @Column(name="TIPO_ENTRADA_ESTOQUE")
    public Short getTipoEntradaEstoque() {
        return this.tipoEntradaEstoque;
    }

    public void setTipoEntradaEstoque(Short tipoEntradaEstoque) {
        this.tipoEntradaEstoque = tipoEntradaEstoque;
    }

    @OneToMany(mappedBy="apuracidadeEstoque")
    @Cascade(value={org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    public List<PreAcuracidadeEst> getPreAcuracidadeEstoque() {
        return this.preAcuracidadeEstoque;
    }

    public void setPreAcuracidadeEstoque(List<PreAcuracidadeEst> preAcuracidadeEstoque) {
        this.preAcuracidadeEstoque = preAcuracidadeEstoque;
    }

    @OneToMany(mappedBy="apuracidadeSaida", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<NotaFiscalPropria> getNotasPerda() {
        return this.notasPerda;
    }

    public void setNotasPerda(List<NotaFiscalPropria> notasPerda) {
        this.notasPerda = notasPerda;
    }

    @OneToMany(mappedBy="apuracidadeEntrada", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<NotaFiscalPropria> getNotasEntrada() {
        return this.notasEntrada;
    }

    public void setNotasEntrada(List<NotaFiscalPropria> notasEntrada) {
        this.notasEntrada = notasEntrada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NAT_OPERACAO_ENTRADA", foreignKey=@ForeignKey(name="FK_APUR_ESTOQUE_NAT_OP_ENTRADA"))
    public NaturezaOperacao getNaturezaOperacaoEntrada() {
        return this.naturezaOperacaoEntrada;
    }

    public void setNaturezaOperacaoEntrada(NaturezaOperacao naturezaOperacaoEntrada) {
        this.naturezaOperacaoEntrada = naturezaOperacaoEntrada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NAT_OPERACAO_SAIDA", foreignKey=@ForeignKey(name="FK_APUR_ESTOQUE_NAT_OP_SAIDA"))
    public NaturezaOperacao getNaturezaOperacaoSaida() {
        return this.naturezaOperacaoSaida;
    }

    public void setNaturezaOperacaoSaida(NaturezaOperacao naturezaOperacaoSaida) {
        this.naturezaOperacaoSaida = naturezaOperacaoSaida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_APUR_ESTOQUE_UNID_FAT_CLIENT"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COND_PAGAMENTO", foreignKey=@ForeignKey(name="FK_APUR_ESTOQUE_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_DOCUMENTO", foreignKey=@ForeignKey(name="FK_APUR_ESTOQUE_SIT_DOC"))
    public SituacaoDocumento getSituacaoDocumento() {
        return this.situacaoDocumento;
    }

    public void setSituacaoDocumento(SituacaoDocumento situacaoDocumento) {
        this.situacaoDocumento = situacaoDocumento;
    }

    @Column(name="QUANTIDADE_ITEM_POR_NOTA")
    public Integer getQuantidadeItensPorNota() {
        return this.quantidadeItensPorNota;
    }

    public void setQuantidadeItensPorNota(Integer quantidadeItensPorNota) {
        this.quantidadeItensPorNota = quantidadeItensPorNota;
    }

    @OneToMany(mappedBy="acuracidadeEstoque", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<AcuracidadeEstContProdutos> getContagemProdutos() {
        return this.contagemProdutos;
    }

    public void setContagemProdutos(List<AcuracidadeEstContProdutos> contagemProdutos) {
        this.contagemProdutos = contagemProdutos;
    }
}

